/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.StringUtils;

public class ExportEBPPivot
extends AbstractExport {
    private final DecimalFormat decimalFormat = new DecimalFormat("##0.00", DecimalFormatSymbols.getInstance(Locale.UK));
    private List<Object[]> data;

    private String formatCents(Number n) {
        return this.decimalFormat.format(BigDecimal.valueOf(n.longValue()).movePointLeft(2));
    }

    public ExportEBPPivot(DBRoot rootSociete) {
        super(rootSociete, "EBP_Pivot", ".txt");
    }

    @Override
    protected int fetchData(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        List l;
        SQLTable tableEcriture = this.getEcritureT();
        SQLTable tableMouvement = tableEcriture.getForeignTable("ID_MOUVEMENT");
        SQLTable tablePiece = tableMouvement.getForeignTable("ID_PIECE");
        SQLTable tableCompte = tableEcriture.getForeignTable("ID_COMPTE_PCE");
        SQLTable tableJrnl = tableEcriture.getForeignTable("ID_JOURNAL");
        SQLSelect sel = this.createSelect(from, to, selectedJournal, onlyNew);
        sel.addSelect(tableJrnl.getField("CODE"));
        sel.addSelect(tableJrnl.getField("NOM"));
        sel.addSelect(tableEcriture.getField("ID"));
        sel.addSelect(tableEcriture.getField("DATE"));
        sel.addSelect(tableCompte.getField("NUMERO"));
        sel.addSelect(tableCompte.getField("NOM"));
        sel.addSelect(tableMouvement.getField("NUMERO"));
        sel.addSelect(tableEcriture.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DEBIT"));
        sel.addSelect(tableEcriture.getField("CREDIT"));
        sel.addSelect(tablePiece.getField("NOM"));
        sel.addFieldOrder(tableJrnl.getField("CODE"));
        sel.addFieldOrder(tableEcriture.getField("DATE"));
        sel.addFieldOrder(tableMouvement.getField("NUMERO"));
        this.data = l = (List)this.getRootSociete().getDBSystemRoot().getDataSource().execute(sel.asString(), new ArrayListHandler());
        return l == null ? 0 : l.size();
    }

    @Override
    protected void export(OutputStream out) throws IOException {
        OutputStreamWriter bufOut = new OutputStreamWriter(out, StringUtils.ASCII);
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyy");
        bufOut.write("###EBPPivotV1\r\n");
        for (Object[] array : this.data) {
            int sign;
            long cents;
            bufOut.write(String.valueOf(array[2]));
            ((Writer)bufOut).write(44);
            bufOut.write(dateFormat.format((Date)array[3]));
            ((Writer)bufOut).write(44);
            String codeJournal = String.valueOf(array[0]);
            bufOut.write(codeJournal);
            ((Writer)bufOut).write(44);
            String numeroCompte = String.valueOf(array[4]);
            bufOut.write(StringUtils.toAsciiString(numeroCompte));
            ((Writer)bufOut).write(44);
            ((Writer)bufOut).write(44);
            String libelleEcriture = String.valueOf(array[7]);
            ((Writer)bufOut).write(34);
            bufOut.write(StringUtils.toAsciiString(libelleEcriture));
            ((Writer)bufOut).write(34);
            ((Writer)bufOut).write(44);
            String libellePiece = String.valueOf(array[10]);
            ((Writer)bufOut).write(34);
            bufOut.write(StringUtils.toAsciiString(libellePiece));
            ((Writer)bufOut).write(34);
            ((Writer)bufOut).write(44);
            long debit = ((Number)array[8]).longValue();
            long credit = ((Number)array[9]).longValue();
            if (debit > 0L && credit > 0L) {
                throw new IllegalStateException("debit et credit >0");
            }
            if (credit > 0L) {
                cents = credit;
                sign = 67;
            } else {
                cents = debit;
                sign = 68;
            }
            bufOut.write(this.formatCents(cents));
            ((Writer)bufOut).write(44);
            ((Writer)bufOut).write(sign);
            ((Writer)bufOut).write(44);
            ((Writer)bufOut).write(44);
            bufOut.write("EUR");
            bufOut.write("\r\n");
            ((Writer)bufOut).flush();
        }
    }
}

