/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.action.SauvegardeBaseAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.config.GestionLauncher;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.panel.UserExitConf;
import org.openconcerto.erp.preferences.BackupNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.utils.BackupPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.UserExit;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ProcessStreams;
import org.openconcerto.utils.prog.VMLauncher;

public class UserExitPanel
extends JPanel {
    private static final AtomicBoolean CLOSING = new AtomicBoolean(false);
    private final UserExitConf conf;

    public static final boolean isClosing() {
        return CLOSING.get();
    }

    public UserExitPanel(UserExitConf conf) {
        if (conf == null) {
            throw new NullPointerException("Null conf");
        }
        this.conf = conf;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.anchor = 10;
        c.insets = new Insets(2, 2, 5, 2);
        c.weightx = 1.0;
        c.gridwidth = 2;
        String text = "Voulez-vous vraiment " + (this.conf.shouldRestart() ? "relancer " : "quitter ") + Configuration.getInstance().getAppName() + " ?";
        if (this.conf.getMessage() != null) {
            text = String.valueOf(this.conf.getMessage()) + "<br/>" + text;
        }
        JLabel labelQuit = new JLabel("<html>" + text + "</html>");
        JButton buttonCancel = new JButton("Annuler");
        String verb = this.conf.shouldRestart() ? "Relancer" : "Quitter";
        JButton buttonExit = new JButton(verb);
        this.add((Component)labelQuit, c);
        ++c.gridy;
        c.fill = 0;
        c.gridwidth = 1;
        this.add((Component)buttonExit, c);
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        Action backupAction = this.createBackupAction(verb);
        if (backupAction != null && comptaPropsConfiguration.getRowSociete() != null) {
            ++c.gridx;
            this.add((Component)new JButton(backupAction), c);
        }
        ++c.gridx;
        this.add((Component)buttonCancel, c);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.getWindowAncestor(UserExitPanel.this).dispose();
            }
        });
        ActionListener listenerExit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserExitPanel.this.closeGNx();
            }
        };
        buttonExit.addActionListener(listenerExit);
    }

    protected Action createBackupAction(String verb) {
        if (!UserRightsManager.getCurrentUserRights().haveRight("BACKUP")) {
            return null;
        }
        return new AbstractAction("Sauvegarder et " + verb.toLowerCase()){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog frame = new JDialog();
                frame.setContentPane(new BackupPanel(null, SauvegardeBaseAction.getDirs(), false, BackupNXProps.getInstance()){

                    @Override
                    public void doOnClose() {
                        super.doOnClose();
                        UserExitPanel.this.closeGNx();
                    }
                });
                frame.setTitle("Sauvegarde des donn\u00e9es");
                frame.setDefaultCloseOperation(2);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        UserExitPanel.startTimeOut();
                    }
                });
                frame.setLocationRelativeTo(null);
                frame.pack();
                frame.setMinimumSize(frame.getSize());
                ((Window)SwingUtilities.getRoot(UserExitPanel.this)).dispose();
                frame.setModal(true);
                frame.setIconImages(Gestion.getFrameIcon());
                frame.setAlwaysOnTop(true);
                frame.setVisible(true);
            }
        };
    }

    private void closeGNx() {
        UserExitPanel.exit(this.conf);
    }

    public static void exit(final UserExitConf c) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!CLOSING.compareAndSet(false, true)) {
            return;
        }
        UserExit.closeAllWindows(null);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        c.beforeShutdown();
                        if (c.shouldRestart()) {
                            VMLauncher.restart(ProcessStreams.DISCARD, GestionLauncher.class, new String[0]);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            c.afterWindowsClosed();
            ModuleManager.tearDown();
            ComptaPropsConfiguration.closeOOConnexion();
        }
        catch (Exception exn) {
            ExceptionHandler.handle("Erreur lors de la fermeture", exn);
        }
        if (Gestion.pgFrameStart != null) {
            Gestion.pgFrameStart.setVisible(false);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Configuration.getInstance().destroy();
                    ComptaPropsConfiguration.getInstanceCompta().tearDownLogging(true);
                }
                finally {
                    UserExitPanel.startTimeOut();
                }
            }
        }.start();
    }

    private static final void startTimeOut() {
        Thread timeOut = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    System.err.println("Warning: Forcing exit");
                    Frame[] l = Frame.getFrames();
                    int i = 0;
                    while (i < l.length) {
                        Frame f = l[i];
                        System.err.println("Frame " + f.getName() + " " + f + " Displayable: " + f.isDisplayable() + " Valid: " + f.isValid() + " Active: " + f.isActive());
                        ++i;
                    }
                    Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
                    for (Thread thread : threadSet) {
                        if (thread.isDaemon()) continue;
                        System.err.println("Thread " + thread.getName() + " " + thread.getId() + " not daemon");
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                try {
                    Configuration.getInstance().destroy();
                    ComptaPropsConfiguration.getInstanceCompta().tearDownLogging(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
        });
        timeOut.setName("TimeOut Thread");
        timeOut.setDaemon(true);
        timeOut.start();
    }
}

