/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Objects;
import org.openconcerto.erp.modules.DepSolverGraph;

public class DepSolverResult {
    private final DepSolverResult parent;
    private final int triesCount;
    private final String error;
    private final DepSolverGraph graph;

    public DepSolverResult(DepSolverResult parent, int tryCount, String error, DepSolverGraph graph) {
        this.parent = parent;
        if (tryCount < 0) {
            throw new IllegalArgumentException("Negative try count : " + tryCount);
        }
        this.triesCount = tryCount;
        this.error = error;
        this.graph = Objects.requireNonNull(graph, "graph");
    }

    public final DepSolverResult getParent() {
        return this.parent;
    }

    public final int getTriesCount() {
        return this.triesCount;
    }

    public final String getError() {
        return this.error;
    }

    public final DepSolverGraph getGraph() {
        return this.graph;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + (this.getError() == null ? " no errors" : " error : " + this.getError());
    }

    public static interface Factory {
        public DepSolverResult create(DepSolverResult var1, int var2, String var3, DepSolverGraph var4);
    }
}

