/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class DevisFactureSQLInjector
extends SQLInjector {
    public DevisFactureSQLInjector(DBRoot root) {
        super(root, "DEVIS", "SAISIE_VENTE_FACTURE", true);
        SQLTable tableDevis = this.getSource();
        SQLTable tableFacture = this.getDestination();
        if (tableDevis.contains("T_ACOMPTE")) {
            this.map(tableDevis.getField("T_ACOMPTE"), tableFacture.getField("T_ACOMPTE"));
        }
        this.map(tableDevis.getField("PORT_HT"), tableFacture.getField("PORT_HT"));
        if (this.getSource().contains("FRAIS_DOCUMENT_HT") && this.getDestination().contains("FRAIS_DOCUMENT_HT")) {
            this.map(this.getSource().getField("FRAIS_DOCUMENT_HT"), this.getDestination().getField("FRAIS_DOCUMENT_HT"));
        }
        if (this.getSource().contains("ID_TAXE_FRAIS_DOCUMENT") && this.getDestination().contains("ID_TAXE_FRAIS_DOCUMENT")) {
            this.map(this.getSource().getField("ID_TAXE_FRAIS_DOCUMENT"), this.getDestination().getField("ID_TAXE_FRAIS_DOCUMENT"));
        }
        this.map(tableDevis.getField("REMISE_HT"), tableFacture.getField("REMISE_HT"));
        this.map(tableDevis.getField("ID_CLIENT"), tableFacture.getField("ID_CLIENT"));
        this.map(tableDevis.getField("ID_COMMERCIAL"), tableFacture.getField("ID_COMMERCIAL"));
        this.map(tableDevis.getField("ID_DEVIS"), tableFacture.getField("ID_DEVIS"));
        if (tableDevis.getTable().contains("ID_POLE_PRODUIT")) {
            this.map(tableDevis.getField("ID_POLE_PRODUIT"), tableFacture.getField("ID_POLE_PRODUIT"));
        }
        if (tableDevis.getTable().contains("ID_VERIFICATEUR") && tableFacture.getTable().contains("ID_VERIFICATEUR")) {
            this.map(tableDevis.getField("ID_VERIFICATEUR"), tableFacture.getField("ID_VERIFICATEUR"));
        }
        if (tableDevis.getTable().contains("ID_CONTACT")) {
            this.map(tableDevis.getField("ID_CONTACT"), tableFacture.getField("ID_CONTACT"));
        }
        if (this.getSource().getTable().contains("ID_CLIENT_DEPARTEMENT")) {
            this.map(tableDevis.getField("ID_CLIENT_DEPARTEMENT"), tableFacture.getField("ID_CLIENT_DEPARTEMENT"));
        }
        if (this.getSource().getTable().contains("ID_ADRESSE") && this.getDestination().contains("ID_ADRESSE")) {
            this.map(tableDevis.getField("ID_ADRESSE"), tableFacture.getField("ID_ADRESSE"));
        }
        if (this.getSource().getTable().contains("ID_ADRESSE_LIVRAISON") && this.getDestination().contains("ID_ADRESSE_LIVRAISON")) {
            this.map(tableDevis.getField("ID_ADRESSE_LIVRAISON"), tableFacture.getField("ID_ADRESSE_LIVRAISON"));
        }
        if (this.getSource().getTable().contains("MONTANT_REMISE") && tableFacture.contains("MONTANT_REMISE")) {
            this.map(tableDevis.getField("MONTANT_REMISE"), tableFacture.getField("MONTANT_REMISE"));
            this.map(tableDevis.getField("POURCENT_REMISE"), tableFacture.getField("POURCENT_REMISE"));
        }
        if (this.getSource().getTable().contains("ID_CATEGORIE_COMPTABLE") && this.getDestination().getTable().contains("ID_CATEGORIE_COMPTABLE")) {
            this.map(this.getSource().getField("ID_CATEGORIE_COMPTABLE"), this.getDestination().getField("ID_CATEGORIE_COMPTABLE"));
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        SQLRowAccessor rowClient;
        SQLRowAccessor rowFrais;
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("DEVIS_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_SAISIE_VENTE_FACTURE");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_SAISIE_VENTE_FACTURE", "OBJET", "NOM");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_SAISIE_VENTE_FACTURE", "INFOS", "INFOS");
        if (this.getDestination().contains("ID_TAXE_FRAIS_DOCUMENT") && (rowFrais = (rowClient = srcRow.getForeign("ID_CLIENT")).getForeign("ID_FRAIS_DOCUMENT")) != null && !rowFrais.isUndefined()) {
            rowVals.put("FRAIS_DOCUMENT_HT", rowFrais.getLong("MONTANT_HT"));
            rowVals.put("ID_TAXE_FRAIS_DOCUMENT", rowFrais.getForeignID("ID_TAXE"));
        }
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_SAISIE_VENTE_FACTURE", (Object)rowVals);
            }
        }
    }
}

