/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class DevisCommandeSQLInjector
extends SQLInjector {
    public DevisCommandeSQLInjector(DBRoot root) {
        super(root, "DEVIS", "COMMANDE_CLIENT", true);
        SQLTable tableDevis = this.getSource();
        SQLTable tableCommande = this.getDestination();
        this.map(tableDevis.getField("ID_CLIENT"), tableCommande.getField("ID_CLIENT"));
        if (tableDevis.contains("REMISE_HT") && tableCommande.contains("REMISE_HT")) {
            this.map(tableDevis.getField("REMISE_HT"), tableCommande.getField("REMISE_HT"));
        }
        if (tableDevis.contains("PORT_HT") && tableCommande.contains("PORT_HT")) {
            this.map(tableDevis.getField("PORT_HT"), tableCommande.getField("PORT_HT"));
        }
        if (this.getSource().contains("FRAIS_DOCUMENT_HT") && this.getDestination().contains("FRAIS_DOCUMENT_HT")) {
            this.map(this.getSource().getField("FRAIS_DOCUMENT_HT"), this.getDestination().getField("FRAIS_DOCUMENT_HT"));
        }
        if (this.getSource().contains("ID_TAXE_FRAIS_DOCUMENT") && this.getDestination().contains("ID_TAXE_FRAIS_DOCUMENT")) {
            this.map(this.getSource().getField("ID_TAXE_FRAIS_DOCUMENT"), this.getDestination().getField("ID_TAXE_FRAIS_DOCUMENT"));
        }
        this.mapDefaultValues(tableCommande.getField("SOURCE"), tableDevis.getName());
        this.map(tableDevis.getField("ID_DEVIS"), tableCommande.getField("IDSOURCE"));
        this.map(tableDevis.getField("ID_DEVIS"), tableCommande.getField("ID_DEVIS"));
        this.map(tableDevis.getField("ID_COMMERCIAL"), tableCommande.getField("ID_COMMERCIAL"));
        if (tableDevis.getTable().contains("ID_POLE_PRODUIT")) {
            this.map(tableDevis.getField("ID_POLE_PRODUIT"), tableCommande.getField("ID_POLE_PRODUIT"));
        }
        if (tableDevis.getTable().contains("ID_TARIF") && tableCommande.getTable().contains("ID_TARIF")) {
            this.map(tableDevis.getField("ID_TARIF"), tableCommande.getField("ID_TARIF"));
        }
        if (this.getSource().getTable().contains("ID_CONTACT")) {
            this.map(tableDevis.getField("ID_CONTACT"), tableCommande.getField("ID_CONTACT"));
        }
        if (this.getSource().getTable().contains("ID_CLIENT_DEPARTEMENT")) {
            this.map(this.getSource().getField("ID_CLIENT_DEPARTEMENT"), this.getDestination().getField("ID_CLIENT_DEPARTEMENT"));
        }
        if (this.getSource().getTable().contains("ID_ADRESSE") && this.getDestination().contains("ID_ADRESSE")) {
            this.map(tableDevis.getField("ID_ADRESSE"), this.getDestination().getField("ID_ADRESSE"));
        }
        if (this.getSource().getTable().contains("ID_ADRESSE_LIVRAISON")) {
            this.map(tableDevis.getField("ID_ADRESSE_LIVRAISON"), this.getDestination().getField("ID_ADRESSE_LIVRAISON"));
        }
        if (this.getSource().getTable().contains("MONTANT_REMISE") && this.getDestination().contains("MONTANT_REMISE")) {
            this.map(tableDevis.getField("MONTANT_REMISE"), this.getDestination().getField("MONTANT_REMISE"));
            this.map(tableDevis.getField("POURCENT_REMISE"), this.getDestination().getField("POURCENT_REMISE"));
        }
        if (this.getSource().getTable().contains("ID_CATEGORIE_COMPTABLE") && this.getDestination().getTable().contains("ID_CATEGORIE_COMPTABLE")) {
            this.map(this.getSource().getField("ID_CATEGORIE_COMPTABLE"), this.getDestination().getField("ID_CATEGORIE_COMPTABLE"));
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("DEVIS_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("COMMANDE_CLIENT_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_COMMANDE_CLIENT");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_COMMANDE_CLIENT", "OBJET", "NOM");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_COMMANDE_CLIENT", "INFOS", "INFOS");
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_COMMANDE_CLIENT", (Object)rowVals);
            }
        }
    }
}

