/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class CommandeBlSQLInjector
extends SQLInjector {
    public CommandeBlSQLInjector(DBRoot root) {
        super(root, "COMMANDE_CLIENT", "BON_DE_LIVRAISON", true);
        SQLTable tableCmd = this.getSource();
        SQLTable tableBl = this.getDestination();
        this.map(tableCmd.getField("ID_CLIENT"), tableBl.getField("ID_CLIENT"));
        this.map(tableCmd.getField("ID"), tableBl.getField("ID_COMMANDE_CLIENT"));
        if (tableCmd.getTable().contains("ID_POLE_PRODUIT") && tableBl.contains("ID_POLE_PRODUIT")) {
            this.map(tableCmd.getField("ID_POLE_PRODUIT"), tableBl.getField("ID_POLE_PRODUIT"));
        }
        if (tableCmd.contains("T_ACOMPTE") && tableBl.contains("T_ACOMPTE")) {
            this.map(tableCmd.getField("T_ACOMPTE"), tableBl.getField("T_ACOMPTE"));
        }
        if (this.getSource().getTable().contains("ID_CONTACT")) {
            this.map(this.getSource().getField("ID_CONTACT"), this.getDestination().getField("ID_CONTACT"));
        }
        if (this.getSource().getTable().contains("ID_CLIENT_DEPARTEMENT")) {
            this.map(this.getSource().getField("ID_CLIENT_DEPARTEMENT"), this.getDestination().getField("ID_CLIENT_DEPARTEMENT"));
        }
        if (this.getSource().getTable().contains("ID_TARIF") && this.getDestination().getTable().contains("ID_TARIF")) {
            this.map(this.getSource().getField("ID_TARIF"), this.getDestination().getField("ID_TARIF"));
        }
        if (tableBl.contains("ACOMPTE_COMMANDE")) {
            this.map(this.getSource().getField("ACOMPTE_COMMANDE"), this.getDestination().getField("ACOMPTE_COMMANDE"));
        }
        if (tableBl.contains("CREATE_VIRTUAL_STOCK")) {
            this.mapDefaultValues(tableBl.getField("CREATE_VIRTUAL_STOCK"), Boolean.FALSE);
        }
        if (tableBl.contains("ID_TAXE_PORT")) {
            this.map(tableCmd.getField("ID_TAXE_PORT"), tableBl.getField("ID_TAXE_PORT"));
        }
        if (tableBl.contains("PORT_HT")) {
            this.map(tableCmd.getField("PORT_HT"), tableBl.getField("PORT_HT"));
        }
        if (this.getSource().contains("FRAIS_DOCUMENT_HT") && this.getDestination().contains("FRAIS_DOCUMENT_HT")) {
            this.map(this.getSource().getField("FRAIS_DOCUMENT_HT"), this.getDestination().getField("FRAIS_DOCUMENT_HT"));
        }
        if (this.getSource().contains("ID_TAXE_FRAIS_DOCUMENT") && this.getDestination().contains("ID_TAXE_FRAIS_DOCUMENT")) {
            this.map(this.getSource().getField("ID_TAXE_FRAIS_DOCUMENT"), this.getDestination().getField("ID_TAXE_FRAIS_DOCUMENT"));
        }
        if (tableBl.contains("REMISE_HT")) {
            this.map(tableCmd.getField("REMISE_HT"), tableBl.getField("REMISE_HT"));
        }
        if (this.getSource().getTable().contains("ID_ADRESSE") && this.getDestination().contains("ID_ADRESSE")) {
            this.map(this.getSource().getField("ID_ADRESSE"), this.getDestination().getField("ID_ADRESSE"));
        }
        if (this.getSource().getTable().contains("ID_ADRESSE_LIVRAISON")) {
            this.map(this.getSource().getField("ID_ADRESSE_LIVRAISON"), this.getDestination().getField("ID_ADRESSE_LIVRAISON"));
        }
        if (this.getSource().getTable().contains("ID_CATEGORIE_COMPTABLE") && this.getDestination().getTable().contains("ID_CATEGORIE_COMPTABLE")) {
            this.map(this.getSource().getField("ID_CATEGORIE_COMPTABLE"), this.getDestination().getField("ID_CATEGORIE_COMPTABLE"));
        }
        if (this.getSource().contains("ID_COMMERCIAL") && this.getDestination().contains("ID_COMMERCIAL")) {
            this.map(this.getSource().getField("ID_COMMERCIAL"), this.getDestination().getField("ID_COMMERCIAL"));
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("COMMANDE_CLIENT_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("BON_DE_LIVRAISON_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_BON_DE_LIVRAISON");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_BON_DE_LIVRAISON", "NOM", "NOM");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_BON_DE_LIVRAISON", "INFOS", "INFOS");
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_BON_DE_LIVRAISON", (Object)rowVals);
            }
        }
    }
}

