/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class BonReceptionFactureFournisseurSQLInjector
extends SQLInjector {
    public BonReceptionFactureFournisseurSQLInjector(DBRoot root) {
        super(root, "BON_RECEPTION", "FACTURE_FOURNISSEUR", true);
        this.map(this.getSource().getField("ID_FOURNISSEUR"), this.getDestination().getField("ID_FOURNISSEUR"));
        this.map(this.getSource().getField("NOM"), this.getDestination().getField("NOM"));
        this.map(this.getSource().getField("INFOS"), this.getDestination().getField("INFOS"));
        if (this.getSource().contains("REMISE_HT")) {
            this.map(this.getSource().getField("TOTAL_POIDS"), this.getDestination().getField("T_POIDS"));
            this.map(this.getSource().getField("REMISE_HT"), this.getDestination().getField("REMISE_HT"));
            this.map(this.getSource().getField("PORT_HT"), this.getDestination().getField("PORT_HT"));
            this.map(this.getSource().getField("ID_TAXE_PORT"), this.getDestination().getField("ID_TAXE_PORT"));
        }
        if (this.getSource().contains("ID_AFFAIRE") && this.getDestination().contains("ID_AFFAIRE")) {
            this.map(this.getSource().getField("ID_AFFAIRE"), this.getDestination().getField("ID_AFFAIRE"));
        }
        if (this.getSource().contains("ID_POLE_PRODUIT") && this.getDestination().contains("ID_POLE_PRODUIT")) {
            this.map(this.getSource().getField("ID_POLE_PRODUIT"), this.getDestination().getField("ID_POLE_PRODUIT"));
        }
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        SQLRowAccessor rowCompte;
        super.merge(srcRow, rowVals);
        SQLRowAccessor rowFournisseur = srcRow.getNonEmptyForeign("ID_FOURNISSEUR");
        if (rowFournisseur != null && (rowCompte = rowFournisseur.getNonEmptyForeign("ID_COMPTE_PCE_CHARGE")) != null) {
            rowVals.put("ID_COMPTE_PCE", rowCompte.getID());
        }
        SQLTable tableElementSource = this.getSource().getTable("BON_RECEPTION_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("FACTURE_FOURNISSEUR_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        this.transfertNumberReference(srcRow, rowVals, tableElementDestination, "ID_FACTURE_FOURNISSEUR");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_FACTURE_FOURNISSEUR", "NOM", "NOM");
        this.transfertReference(srcRow, rowVals, tableElementDestination, "ID_FACTURE_FOURNISSEUR", "INFOS", "INFOS");
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_FACTURE_FOURNISSEUR", (Object)rowVals);
            }
        }
    }
}

