/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.generationEcritures.Ecriture;
import org.openconcerto.erp.generationEcritures.MouvementGED;
import org.openconcerto.erp.generationEcritures.MouvementPostInsertionAction;
import org.openconcerto.erp.generationEcritures.Piece;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.User;

public class Mouvement {
    private String numero;
    private List<Ecriture> ecritures = new ArrayList<Ecriture>();
    private List<MouvementGED> gedURLs;
    private Number id;
    private BigDecimal debit = BigDecimal.ZERO;
    private BigDecimal credit = BigDecimal.ZERO;
    private Piece piece;
    private Number idSource;
    private String source;
    private Mouvement pere;
    private MouvementPostInsertionAction postInsertionAction;

    public void setSource(Number idSource, String source) {
        this.idSource = idSource;
        this.source = source;
    }

    public void add(Ecriture e) {
        this.ecritures.add(e);
        this.debit = this.debit.add(e.getDebit());
        this.credit = this.credit.add(e.getCredit());
        e.setMouvement(this);
    }

    List<Ecriture> getEcritures() {
        return this.ecritures;
    }

    void setId(Number id) {
        this.id = id;
    }

    public Number getId() {
        return this.id;
    }

    public List<MouvementGED> getURLs() {
        return this.gedURLs;
    }

    public void addURL(MouvementGED e) {
        if (this.gedURLs == null) {
            this.gedURLs = new ArrayList<MouvementGED>();
        }
        e.setEcriture(this);
        this.gedURLs.add(e);
    }

    public boolean hasURLs() {
        return this.gedURLs != null;
    }

    SQLInsert createInsert(DBRoot root, User user) {
        SQLInsert insert = new SQLInsert();
        SQLTable table = root.getTable("MOUVEMENT");
        if (this.idSource != null) {
            insert.add(table.getField("IDSOURCE"), this.idSource);
            insert.add(table.getField("SOURCE"), this.source);
        }
        insert.add(table.getField("ID_PIECE"), this.piece.getId().intValue());
        if (this.pere != null) {
            insert.add(table.getField("ID_MOUVEMENT_PERE"), this.pere.getId().intValue());
        }
        insert.addCreationTrackedField(user, table);
        return insert;
    }

    public boolean isBalanced() {
        BigDecimal d = BigDecimal.ZERO;
        BigDecimal c = BigDecimal.ZERO;
        for (Ecriture e : this.ecritures) {
            d = d.add(e.getDebit());
            c = c.add(e.getCredit());
        }
        return d.compareTo(c) == 0;
    }

    public Piece getPiece() {
        return this.piece;
    }

    public void setPiece(Piece piece) {
        this.piece = piece;
    }

    public String asString() {
        StringBuilder s = new StringBuilder();
        BigDecimal d = BigDecimal.ZERO;
        BigDecimal c = BigDecimal.ZERO;
        s.append("Mouvement N\u00b0");
        s.append(this.numero);
        s.append("\n");
        for (Ecriture e : this.ecritures) {
            s.append("D : " + e.getDebit());
            s.append("\tC : " + e.getCredit());
            d = d.add(e.getDebit());
            c = c.add(e.getCredit());
            s.append("\tS : " + d.subtract(c) + "\n");
        }
        return s.toString();
    }

    public boolean isEmpty() {
        return this.ecritures.isEmpty();
    }

    public MouvementPostInsertionAction getPostInsertionAction() {
        return this.postInsertionAction;
    }

    public void setAfterInsert(MouvementPostInsertionAction insertionAction) {
        this.postInsertionAction = insertionAction;
    }
}

