/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementFactureFournisseur;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProviderManager;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationMvtFactureFournisseur
extends GenerationEcritures {
    public static final String ID = "accounting.records.supplychain.order";
    private int idFacture;
    private static final String source = "FACTURE_FOURNISSEUR";
    private static final Integer journal = new Integer(2);
    private static final SQLTable tableFacture = base.getTable("FACTURE_FOURNISSEUR");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableFournisseur = base.getTable("FOURNISSEUR");
    private static final SQLTable tableMvt = base.getTable("MOUVEMENT");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtFactureFournisseur(SQLRow row, int idMvt) throws SQLException {
        this.setRowAnalytiqueSource(row);
        this.idFacture = row.getID();
        this.idMvt = idMvt;
        this.genereMouvement();
    }

    public GenerationMvtFactureFournisseur(SQLRow row) throws SQLException {
        this(row, 1);
    }

    public void genereMouvement() throws SQLException {
        SQLRowValues rowValsPiece;
        SQLRow saisieRow = this.getRowAnalytiqueSource();
        SQLRow rowFournisseur = tableFournisseur.getRow(saisieRow.getInt("ID_FOURNISSEUR"));
        this.date = (Date)saisieRow.getObject("DATE");
        this.nom = "Achat : " + rowFournisseur.getString("NOM") + " Facture : " + saisieRow.getObject("NUMERO").toString() + " " + saisieRow.getObject("NOM").toString();
        this.putValue("DATE", this.date);
        this.putValue("NOM", this.nom);
        AccountingRecordsProvider provider = AccountingRecordsProviderManager.get(ID);
        if (provider != null) {
            provider.putLabel(saisieRow, this.mEcritures);
        }
        this.putValue("ID_JOURNAL", journal);
        this.putValue("ID_MOUVEMENT", new Integer(1));
        if (this.idMvt == 1) {
            rowValsPiece = new SQLRowValues(pieceTable);
            rowValsPiece.put("NOM", saisieRow.getObject("NUMERO").toString());
            if (provider != null) {
                provider.putPieceLabel(saisieRow, rowValsPiece);
            }
            this.getNewMouvement(source, this.idFacture, 1, rowValsPiece);
        } else {
            rowValsPiece = pieceTable.getTable("MOUVEMENT").getRow(this.idMvt).getForeign("ID_PIECE").asRowValues();
            rowValsPiece.put("NOM", saisieRow.getObject("NUMERO").toString());
            if (provider != null) {
                provider.putPieceLabel(saisieRow, rowValsPiece);
            }
            rowValsPiece.update();
            this.putValue("ID_MOUVEMENT", new Integer(this.idMvt));
        }
        SQLRow rowCompteAchat = saisieRow.getForeign("ID_COMPTE_PCE");
        if ((rowCompteAchat == null || rowCompteAchat.isUndefined()) && ((rowCompteAchat = rowPrefsCompte.getForeign("ID_COMPTE_PCE_ACHAT")) == null || rowCompteAchat.isUndefined())) {
            rowCompteAchat = ComptePCESQLElement.getRowComptePceDefault("Achats");
        }
        BigDecimal portHT = BigDecimal.valueOf(saisieRow.getLong("PORT_HT")).movePointLeft(2);
        TotalCalculator calc = this.getValuesFromElement(rowFournisseur.getBoolean("UE"), true, "T_PA_HT", saisieRow, saisieRow.getTable().getTable("FACTURE_FOURNISSEUR_ELEMENT"), portHT, saisieRow.getForeign("ID_TAXE_PORT"), BigDecimal.ZERO, null, null, rowCompteAchat);
        long ttcLongValue = calc.getTotalTTC().movePointRight(2).longValue();
        long htLongValue = calc.getTotalHT().movePointRight(2).longValue();
        for (SQLRowAccessor row : calc.getMapHt().keySet()) {
            long b = calc.getMapHt().get(row).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
            if (b == 0L) continue;
            this.putValue("ID_COMPTE_PCE", row.getID());
            this.putValue("CREDIT", 0L);
            this.putValue("DEBIT", b);
            SQLRow sQLRow = this.ajoutEcriture();
        }
        Map<SQLRowAccessor, BigDecimal> tvaMap = calc.getMapHtTVA();
        for (SQLRowAccessor rowAc : tvaMap.keySet()) {
            long longValue = tvaMap.get(rowAc).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
            if (longValue == 0L) continue;
            this.putValue("ID_COMPTE_PCE", rowAc.getID());
            this.putValue("CREDIT", 0L);
            this.putValue("DEBIT", longValue);
            this.ajoutEcriture();
        }
        Map<SQLRowAccessor, BigDecimal> tvaMapIntra = calc.getMapHtTVAIntra();
        for (SQLRowAccessor rowAc : tvaMapIntra.keySet()) {
            long longValue = tvaMapIntra.get(rowAc).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
            if (longValue == 0L) continue;
            this.putValue("ID_COMPTE_PCE", rowAc.getID());
            this.putValue("DEBIT", 0L);
            this.putValue("CREDIT", longValue);
            this.ajoutEcriture();
        }
        int idCompteFourn = rowFournisseur.getInt("ID_COMPTE_PCE");
        if (idCompteFourn <= 1 && (idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
            idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
        }
        this.putValue("ID_COMPTE_PCE", new Integer(idCompteFourn));
        if (rowFournisseur.getTable().getTable("ECRITURE").contains("CODE_CLIENT")) {
            this.putValue("CODE_CLIENT", rowFournisseur.getString("CODE"));
        }
        this.putValue("DEBIT", new Long(0L));
        if (rowFournisseur.getBoolean("UE").booleanValue()) {
            this.putValue("CREDIT", new Long(htLongValue));
        } else {
            this.putValue("CREDIT", new Long(ttcLongValue));
        }
        this.ajoutEcriture();
        new GenerationMvtReglementFactureFournisseur(this.idFacture, this.idMvt);
        SQLRowValues valEcriture = new SQLRowValues(tableFacture);
        valEcriture.put("ID_MOUVEMENT", new Integer(this.idMvt));
        if (valEcriture.getInvalid() == null) {
            valEcriture.update(this.idFacture);
            this.displayMvtNumber();
        }
    }
}

