/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.StringUtils;

public class GenerationMvtDepotChequeClient
extends GenerationEcritures {
    private long montant;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private final SQLRow depot;
    private SQLRowAccessor banque;

    public GenerationMvtDepotChequeClient(SQLRow depot) {
        this.montant = depot.getLong("MONTANT");
        this.date = depot.getDate("DATE").getTime();
        this.banque = depot.getForeign("ID_" + BanqueSQLElement.TABLENAME);
        this.depot = depot;
    }

    public void genere() throws Exception {
        Number n;
        SQLRow row;
        SQLRow rowBanque;
        Number n2;
        SQLRow row2;
        SQLRow rowBanque2;
        System.err.println("g\u00e9n\u00e9ration des ecritures de r\u00e8glement d'un cheque client du mouvement " + this.idMvt);
        this.nom = this.depot.getString("NOM");
        if (this.depot.getObject("ID_MOUVEMENT") == null || this.depot.isForeignEmpty("ID_MOUVEMENT")) {
            this.idMvt = this.getNewMouvement(this.depot.getTable().getName(), this.depot.getID(), 1, this.nom);
        } else {
            this.idMvt = this.depot.getForeignID("ID_MOUVEMENT");
            SQLRowValues rowValspiece = this.depot.getForeign("ID_MOUVEMENT").getForeign("ID_PIECE").createEmptyUpdateRow();
            rowValspiece.put("NOM", this.nom);
            rowValspiece.update();
        }
        this.putValue("ID_MOUVEMENT", new Integer(this.idMvt));
        this.putValue("DATE", new Date(this.date.getTime()));
        this.putValue("NOM", this.nom);
        if (this.banque == null || this.banque.isUndefined() || this.banque.isForeignEmpty("ID_JOURNAL")) {
            this.fillJournalBanqueFromRow(this.depot);
        } else {
            int idJrnl = this.banque.getForeignID("ID_JOURNAL");
            this.putValue("ID_JOURNAL", idJrnl);
        }
        if (!this.depot.isForeignEmpty("ID_" + BanqueSQLElement.TABLENAME) && (rowBanque2 = this.depot.getForeignRow("ID_" + BanqueSQLElement.TABLENAME)).getTable().contains("TYPE_CAISSE") && rowBanque2.getBoolean("TYPE_CAISSE").booleanValue() && (row2 = rowBanque2.getTable().getTable("TYPE_REGLEMENT").getRow(2)).getTable().contains("ID_COMPTE_PCE_CAISSE") && (n2 = row2.getNonEmptyForeignIDNumber("ID_COMPTE_PCE_CAISSE")) != null) {
            this.putValue("ID_JOURNAL", 5);
        }
        boolean genEcrDisabled = DefaultNXProps.getInstance().getBooleanValue("accounting.invoice.generation.disable", false);
        ArrayList<Integer> pieceIDs = new ArrayList<Integer>();
        SQLRowValues rowValsDepotElt = new SQLRowValues(this.depot.getTable().getTable("DEPOT_CHEQUE_ELEMENT"));
        rowValsDepotElt.putNulls("MONTANT", "TIERS", "PIECE");
        rowValsDepotElt.putRowValues("ID_CLIENT").putNulls("NOM", "ID_COMPTE_PCE");
        SQLRowValues rowValuesChq = rowValsDepotElt.putRowValues("ID_CHEQUE_A_ENCAISSER");
        rowValuesChq.putNulls("SANS_VALEUR_ENCAISSEMENT").putRowValues("ID_MOUVEMENT").putRowValues("ID_PIECE").putNulls("NOM");
        rowValuesChq.putNulls("ID_COMPTE_PCE_TIERS").putNulls("NUMERO");
        List<SQLRowValues> cheques = SQLRowValuesListFetcher.create(rowValsDepotElt).fetch(new Where((FieldRef)rowValsDepotElt.getTable().getField("ID_DEPOT_CHEQUE"), "=", this.depot.getID()));
        for (SQLRowValues sqlRowAccessor : cheques) {
            int idCompteClient;
            SQLRowAccessor clientRow = sqlRowAccessor.getForeign("ID_CLIENT");
            this.putValue("NOM", String.valueOf(this.nom) + " " + sqlRowAccessor.getString("PIECE") + " " + StringUtils.limitLength(clientRow.getString("NOM"), 20));
            SQLRowAccessor chequeRow = sqlRowAccessor.getForeign("ID_CHEQUE_A_ENCAISSER");
            pieceIDs.add(chequeRow.getForeign("ID_MOUVEMENT").getForeignID("ID_PIECE"));
            SQLRowAccessor rowCptTiers = chequeRow.getForeign("ID_COMPTE_PCE_TIERS");
            int n3 = idCompteClient = rowCptTiers != null && !rowCptTiers.isUndefined() ? rowCptTiers.getID() : -1;
            if (chequeRow.getBoolean("SANS_VALEUR_ENCAISSEMENT").booleanValue()) {
                if (idCompteClient == -1) {
                    if (clientRow != null) {
                        idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
                    }
                    if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                        idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                    }
                }
            } else {
                idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_VALEUR_ENCAISSEMENT");
                if (idCompteClient <= 1) {
                    idCompteClient = ComptePCESQLElement.getIdComptePceDefault("ValeurEncaissement");
                }
            }
            this.putValue("ID_COMPTE_PCE", new Integer(idCompteClient));
            this.putValue("DEBIT", new Long(0L));
            this.putValue("CREDIT", new Long(sqlRowAccessor.getLong("MONTANT")));
            if (!genEcrDisabled) {
                SQLRow insertedRow = this.ajoutEcriture();
                sqlRowAccessor.createEmptyUpdateRow().put("ID_ECRITURE", insertedRow.getID()).getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
            }
            sqlRowAccessor.getForeign("ID_CHEQUE_A_ENCAISSER").createEmptyUpdateRow().put("ENCAISSE", Boolean.TRUE).getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
        }
        this.fillCompteBanqueFromRow(this.depot, "VenteCheque", false);
        if (!this.depot.isForeignEmpty("ID_" + BanqueSQLElement.TABLENAME) && (rowBanque = this.depot.getForeignRow("ID_" + BanqueSQLElement.TABLENAME)).getTable().contains("TYPE_CAISSE") && rowBanque.getBoolean("TYPE_CAISSE").booleanValue() && (row = rowBanque.getTable().getTable("TYPE_REGLEMENT").getRow(2)).getTable().contains("ID_COMPTE_PCE_CAISSE") && (n = row.getNonEmptyForeignIDNumber("ID_COMPTE_PCE_CAISSE")) != null) {
            this.putValue("ID_COMPTE_PCE", n);
        }
        this.putValue("NOM", this.nom);
        this.putValue("DEBIT", new Long(this.montant));
        this.putValue("CREDIT", new Long(0L));
        if (!genEcrDisabled) {
            SQLRow insertedRow = this.ajoutEcriture();
            this.depot.createEmptyUpdateRow().put("ID_MOUVEMENT", this.idMvt).put("ID_ECRITURE", insertedRow.getID()).getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
        } else {
            this.depot.createEmptyUpdateRow().put("ID_MOUVEMENT", this.idMvt).getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
        }
        pieceIDs.add(mouvementTable.getRow(this.idMvt).getForeignID("ID_PIECE"));
        this.lettrageAuto(pieceIDs, this.date);
        System.err.println("Ecritures g\u00e9n\u00e9r\u00e9es pour le mouvement " + this.idMvt);
    }
}

