/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.GestionDevise;

public final class GenerationMvtAcompte
extends GenerationEcritures {
    private int idSalarie;
    private long montant;
    private int idAcompte;
    private static final SQLTable tableSalarie = base.getTable("SALARIE");
    private static final SQLTable tableAcompte = base.getTable("ACOMPTE");
    private static final Integer journalOD = 6;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtAcompte(SQLRow rowAcompte) throws SQLException {
        this.idAcompte = rowAcompte.getID();
        this.setRowAnalytiqueSource(rowAcompte);
        this.idSalarie = rowAcompte.getInt("ID_SALARIE");
        this.montant = GestionDevise.parseLongCurrency(String.valueOf(rowAcompte.getFloat("MONTANT")));
        SQLRow rowSal = tableSalarie.getRow(this.idSalarie);
        this.idMvt = this.getNewMouvement("ACOMPTE", this.idAcompte, 1, "Acompte " + rowSal.getString("NOM"));
        this.genereComptaAcompte();
    }

    private void genereComptaAcompte() throws SQLException {
        System.out.println("G\u00e9n\u00e9ration des ecritures du mouvement " + this.idMvt);
        SQLRow rowSal = tableSalarie.getRow(this.idSalarie);
        this.date = new Date();
        this.nom = "Acompte " + rowSal.getString("NOM");
        this.putValue("DATE", new java.sql.Date(this.date.getTime()));
        this.putValue("NOM", this.nom);
        this.putValue("ID_JOURNAL", journalOD);
        this.putValue("ID_MOUVEMENT", this.idMvt);
        int idCompteAcompte = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACOMPTE");
        if (idCompteAcompte <= 1) {
            idCompteAcompte = ComptePCESQLElement.getIdComptePceDefault("PayeAcompte");
        }
        this.putValue("ID_COMPTE_PCE", idCompteAcompte);
        this.putValue("NOM", this.nom);
        this.putValue("DEBIT", this.montant);
        this.putValue("CREDIT", 0L);
        this.ajoutEcriture();
        int idCompteTresor = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACOMPTE_REGL");
        if (idCompteTresor <= 1) {
            try {
                idCompteTresor = ComptePCESQLElement.getIdComptePceDefault("PayeReglementAcompte");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.putValue("ID_COMPTE_PCE", idCompteTresor);
        this.putValue("NOM", this.nom);
        this.putValue("DEBIT", 0L);
        this.putValue("CREDIT", this.montant);
        this.ajoutEcriture();
        SQLRowValues rowVals = new SQLRowValues(tableAcompte);
        rowVals.put("ID_MOUVEMENT", (Object)this.idMvt);
        rowVals.update(this.idAcompte);
    }
}

