/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.User;

public class Compte {
    private final Long id;
    private String numero;
    private String nom;

    public Compte(Long id, String numero, String nom) {
        this.id = id;
        this.numero = numero;
        this.nom = nom;
    }

    public Long getId() {
        return this.id;
    }

    public String getNumero() {
        return this.numero;
    }

    public String getNom() {
        return this.nom;
    }

    public int hashCode() {
        return this.numero.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ((Compte)obj).numero.equalsIgnoreCase(this.numero);
    }

    SQLInsert createInsert(DBRoot root, User user) {
        SQLInsert insert = new SQLInsert();
        SQLTable table = root.getTable("COMPTE_PCE");
        insert.add(table.getField("NUMERO"), this.numero);
        insert.add(table.getField("NOM"), this.nom);
        insert.addCreationTrackedField(user, table);
        return insert;
    }

    public String toString() {
        return "Compte numero:" + this.numero + " " + this.nom + " (id:" + this.id + ")";
    }
}

