/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class PrixUnitaireProvider
implements SpreadSheetCellValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        BigDecimal pv = row.getBigDecimal("PV_HT");
        if (pv == null || pv.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        int qte = row.getInt("QTE");
        if (row.getInt("ID_UNITE_VENTE") == 2) {
            return String.valueOf(qte);
        }
        BigDecimal qteUV = row.getBigDecimal("QTE_UNITAIRE");
        BigDecimal mergedQty = qteUV.multiply(new BigDecimal(qte));
        BigDecimal pvUnit = mergedQty.multiply(pv);
        return pvUnit;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("supplychain.element.unitprice", new PrixUnitaireProvider());
    }
}

