/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class PaiementRemainedDevisProvider
implements SpreadSheetCellValueProvider {
    private PaiementRemainedDevisProvider() {
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        return this.getRestant(row);
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("quote.payment.remained", new PaiementRemainedDevisProvider());
    }

    private BigDecimal getRestant(SQLRowAccessor r) {
        long acompte = r.getLong("T_ACOMPTE");
        long ttc = r.getLong("T_TTC");
        long total = ttc - acompte;
        return new BigDecimal(total).movePointLeft(2);
    }
}

