/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.DecimalUtils;

public class NbColisLineDocProvider
extends UserInitialsValueProvider {
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor sqlRowAccessor = context.getRow();
        return this.getVolumeFromRow(sqlRowAccessor);
    }

    protected BigDecimal getVolumeFromRow(SQLRowAccessor sqlRowAccessor) {
        SQLRowAccessor nonEmptyForeign = sqlRowAccessor.getNonEmptyForeign("ID_ARTICLE");
        if (nonEmptyForeign != null) {
            BigDecimal qteUV = sqlRowAccessor.getBigDecimal("QTE_UNITAIRE");
            BigDecimal qte = sqlRowAccessor.getTable().getName().equalsIgnoreCase("BON_DE_LIVRAISON_ELEMENT") ? new BigDecimal(sqlRowAccessor.getInt("QTE_LIVREE")) : new BigDecimal(sqlRowAccessor.getInt("QTE"));
            BigDecimal qteUVArticle = nonEmptyForeign.getBigDecimal("QTE_UNITAIRE");
            BigDecimal qteLine = qteUV.multiply(qte, DecimalUtils.HIGH_PRECISION);
            if (qteUVArticle != null && qteUVArticle.signum() != 0) {
                return qteLine.divide(qteUVArticle, DecimalUtils.HIGH_PRECISION).setScale(0, RoundingMode.HALF_UP);
            }
        }
        return BigDecimal.ZERO;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("nbcolis.line", new NbColisLineDocProvider());
    }
}

