/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.util.Collection;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class LabelAccountInvoiceProvider
implements SpreadSheetCellValueProvider {
    private final String label;

    public LabelAccountInvoiceProvider(String label) {
        this.label = label;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        Collection<? extends SQLRowAccessor> rows = row.getReferentRows(row.getTable().getTable("TR_COMMANDE_CLIENT"));
        String result = row.getBoolean("PARTIAL") != false ? String.valueOf(this.label) + ", commande N\u00b0" : "Solde, commande N\u00b0";
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.isForeignEmpty("ID_COMMANDE_CLIENT")) continue;
            SQLRowAccessor rowCmd = sQLRowAccessor.getForeign("ID_COMMANDE_CLIENT");
            result = String.valueOf(result) + rowCmd.getString("NUMERO");
        }
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.account.label", new LabelAccountInvoiceProvider("Facturation interm\u00e9diaire"));
        SpreadSheetCellValueProviderManager.put("sales.account.label.account", new LabelAccountInvoiceProvider("Facture d'acompte"));
    }
}

