/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;

public class InterfelProvider
implements SpreadSheetCellValueProvider {
    private final TypeInterfelProvider type;

    public InterfelProvider(TypeInterfelProvider t) {
        this.type = t;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        BigDecimal total = new BigDecimal(context.getRow().getLong("T_HT")).movePointLeft(2);
        BigDecimal totalInterfel = new BigDecimal(context.getRow().getLong("MONTANT_INTERFEL_HT")).movePointLeft(2);
        if (this.type == TypeInterfelProvider.TOTAL_HT) {
            return total;
        }
        if (this.type == TypeInterfelProvider.TOTAL_INTERFEL) {
            return totalInterfel;
        }
        if (this.type == TypeInterfelProvider.TOTAL_SANS_INTERFEL_HT) {
            return total.subtract(totalInterfel);
        }
        return null;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.interfel.total", new InterfelProvider(TypeInterfelProvider.TOTAL_HT));
        SpreadSheetCellValueProviderManager.put("sales.interfel.total.ht.sans.taxe", new InterfelProvider(TypeInterfelProvider.TOTAL_SANS_INTERFEL_HT));
    }

    private static enum TypeInterfelProvider {
        TOTAL_HT,
        TOTAL_INTERFEL,
        TOTAL_SANS_INTERFEL_HT;

    }
}

