/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.Tuple2;

public class IbanProvider
implements SpreadSheetCellValueProvider {
    private static Tuple2<Integer, Integer> CODE_PAYS = Tuple2.create(0, 2);
    private static Tuple2<Integer, Integer> CLE_IBAN = Tuple2.create(2, 4);
    private static Tuple2<Integer, Integer> CODE_BANQUE = Tuple2.create(4, 9);
    private static Tuple2<Integer, Integer> CODE_GUICHET = Tuple2.create(9, 14);
    private static Tuple2<Integer, Integer> NUMERO_COMPTE = Tuple2.create(14, 25);
    private static Tuple2<Integer, Integer> CLE_RIB = Tuple2.create(25, 27);
    private final Tuple2<Integer, Integer> currentTuple;

    public IbanProvider(Tuple2<Integer, Integer> tuple) {
        this.currentTuple = tuple;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        String iban = row.getString("IBAN").trim().replaceAll(" ", "");
        if (iban.length() >= this.currentTuple.get1()) {
            return iban.substring(this.currentTuple.get0(), this.currentTuple.get1());
        }
        return "";
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("iban.codepays", new IbanProvider(CODE_PAYS));
        SpreadSheetCellValueProviderManager.put("iban.cleiban", new IbanProvider(CLE_IBAN));
        SpreadSheetCellValueProviderManager.put("iban.codebanque", new IbanProvider(CODE_BANQUE));
        SpreadSheetCellValueProviderManager.put("iban.codeguichet", new IbanProvider(CODE_GUICHET));
        SpreadSheetCellValueProviderManager.put("iban.numerocompte", new IbanProvider(NUMERO_COMPTE));
        SpreadSheetCellValueProviderManager.put("iban.clerib", new IbanProvider(CLE_RIB));
    }

    public static void main(String[] args) {
        String iban = "FR763000401587000260111220";
        System.err.println(iban.substring(CODE_PAYS.get0(), CODE_PAYS.get1()));
        System.err.println(iban.substring(CLE_IBAN.get0(), CLE_IBAN.get1()));
        System.err.println(iban.substring(CODE_BANQUE.get0(), CODE_BANQUE.get1()));
        System.err.println(iban.substring(CODE_GUICHET.get0(), CODE_GUICHET.get1()));
        System.err.println(iban.substring(NUMERO_COMPTE.get0(), NUMERO_COMPTE.get1()));
        if (iban.length() >= CLE_RIB.get1()) {
            System.err.println(iban.substring(CLE_RIB.get0(), CLE_RIB.get1()));
        }
    }
}

