/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import com.ibm.icu.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class FichePayeHeureSupTotalProvider
implements SpreadSheetCellValueProvider {
    private boolean cumul = false;

    public FichePayeHeureSupTotalProvider(boolean c) {
        this.cumul = c;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        BigDecimal total = BigDecimal.ZERO;
        SQLRowAccessor rowVar = context.getRow().getForeign("ID_VARIABLE_SALARIE");
        List<String> fieldHeures = Arrays.asList("HEURE_110", "HEURE_125", "HEURE_150", "HEURE_200");
        for (String field : fieldHeures) {
            if (this.cumul) {
                field = String.valueOf(field) + "_CUMUL_VAL";
            }
            total = total.add(new BigDecimal(rowVar.getFloat(field)));
        }
        return total;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("fichepaye.heure.sup.total", new FichePayeHeureSupTotalProvider(false));
        SpreadSheetCellValueProviderManager.put("fichepaye.heure.sup.cumul.total", new FichePayeHeureSupTotalProvider(true));
    }
}

