/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.AdresseClientProvider;
import org.openconcerto.sql.model.SQLRowAccessor;

public class AdresseFullClientValueProvider
extends AdresseClientProvider {
    private final int type;
    private final boolean withName;
    private final boolean noCountry;

    public AdresseFullClientValueProvider(int type, boolean withName, boolean noCountry) {
        this.type = type;
        this.withName = withName;
        this.noCountry = noCountry;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor r = this.getAdresse(context.getRow(), this.type);
        String result = "";
        if (this.withName) {
            result = String.valueOf(context.getRow().getForeign("ID_CLIENT").getString("NOM")) + "\n\n";
        }
        result = AdresseFullClientValueProvider.getFormattedAddress(r, result, !this.noCountry);
        return result;
    }

    public static String getFormattedAddress(SQLRowAccessor rAddress, String prefix) {
        return AdresseFullClientValueProvider.getFormattedAddress(rAddress, prefix, true);
    }

    public static String getFormattedAddress(SQLRowAccessor rAddress, String prefix, boolean withCountry) {
        boolean notEmptyRue;
        boolean notEmptyDest;
        boolean notEmptyLib;
        String result = prefix;
        boolean bl = notEmptyLib = AdresseFullClientValueProvider.getStringTrimmed(rAddress, "LIBELLE").length() > 0;
        if (notEmptyLib) {
            result = String.valueOf(AdresseFullClientValueProvider.getStringTrimmed(rAddress, "LIBELLE")) + "\n";
        }
        boolean bl2 = notEmptyDest = AdresseFullClientValueProvider.getStringTrimmed(rAddress, "DEST").length() > 0;
        if (notEmptyDest) {
            result = String.valueOf(AdresseFullClientValueProvider.getStringTrimmed(rAddress, "DEST")) + "\n";
        }
        boolean bl3 = notEmptyRue = AdresseFullClientValueProvider.getStringTrimmed(rAddress, "RUE").length() > 0;
        if (notEmptyRue) {
            result = String.valueOf(result) + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "RUE") + "\n";
        }
        result = String.valueOf(result) + (notEmptyDest && notEmptyLib && notEmptyLib ? "\n" + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "CODE_POSTAL") : AdresseFullClientValueProvider.getStringTrimmed(rAddress, "CODE_POSTAL"));
        result = String.valueOf(result) + " ";
        if (rAddress.getTable().contains("DISTRICT")) {
            result = String.valueOf(result) + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "DISTRICT") + " ";
        }
        result = String.valueOf(result) + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "VILLE");
        if (rAddress.getBoolean("HAS_CEDEX").booleanValue()) {
            result = String.valueOf(result) + " Cedex";
            String cedex = AdresseFullClientValueProvider.getStringTrimmed(rAddress, "CEDEX");
            if (cedex.length() > 0) {
                result = String.valueOf(result) + " " + cedex;
            }
        }
        if (rAddress.getTable().contains("PROVINCE")) {
            String province = AdresseFullClientValueProvider.getStringTrimmed(rAddress, "PROVINCE");
            boolean department = rAddress.getTable().contains("DEPARTEMENT");
            if (province.length() > 0 || department && AdresseFullClientValueProvider.getStringTrimmed(rAddress, "DEPARTEMENT").length() > 0) {
                result = String.valueOf(result) + "\n";
            }
            if (province.length() > 0) {
                result = String.valueOf(result) + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "PROVINCE") + " ";
            }
            if (department && AdresseFullClientValueProvider.getStringTrimmed(rAddress, "DEPARTEMENT").length() > 0) {
                result = String.valueOf(result) + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "DEPARTEMENT");
            }
        }
        if (withCountry && AdresseFullClientValueProvider.getStringTrimmed(rAddress, "PAYS").length() > 0) {
            result = String.valueOf(result) + "\n" + AdresseFullClientValueProvider.getStringTrimmed(rAddress, "PAYS");
        }
        return result;
    }

    public static String getStringTrimmed(SQLRowAccessor r, String field) {
        String result = r.getString(field);
        if (result == null) {
            return "";
        }
        return result.trim();
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("address.customer.full", new AdresseFullClientValueProvider(ADRESSE_PRINCIPALE, false, false));
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.full", new AdresseFullClientValueProvider(ADRESSE_FACTURATION, false, false));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.full", new AdresseFullClientValueProvider(ADRESSE_LIVRAISON, false, false));
        SpreadSheetCellValueProviderManager.put("address.customer.full.nocountry", new AdresseFullClientValueProvider(ADRESSE_PRINCIPALE, false, true));
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.full.nocountry", new AdresseFullClientValueProvider(ADRESSE_FACTURATION, false, true));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.full.nocountry", new AdresseFullClientValueProvider(ADRESSE_LIVRAISON, false, true));
        SpreadSheetCellValueProviderManager.put("address.customer.full.withname", new AdresseFullClientValueProvider(ADRESSE_PRINCIPALE, true, false));
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.full.withname", new AdresseFullClientValueProvider(ADRESSE_FACTURATION, true, false));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.full.withname", new AdresseFullClientValueProvider(ADRESSE_LIVRAISON, true, false));
        SpreadSheetCellValueProviderManager.put("address.customer.full.withname.nocountry", new AdresseFullClientValueProvider(ADRESSE_PRINCIPALE, true, true));
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.full.withname.nocountry", new AdresseFullClientValueProvider(ADRESSE_FACTURATION, true, true));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.full.withname.nocountry", new AdresseFullClientValueProvider(ADRESSE_LIVRAISON, true, true));
    }
}

