/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.compta;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class ReportingAnalytiqueKDXmlSheet
extends AbstractListeSheetXml {
    public static final String TEMPLATE_ID = "KDAnalytique";
    public static final String TEMPLATE_PROPERTY_NAME = "Default";
    private Calendar c = Calendar.getInstance();
    private Date date = new Date();
    private final long MILLIS_IN_HOUR = 3600000L;

    public ReportingAnalytiqueKDXmlSheet(int mois, int year) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.mapAllSheetValues = new HashMap();
        this.c.set(5, 1);
        this.c.set(1, year);
        this.c.set(2, mois);
        this.c.set(11, 0);
        this.c.set(12, 0);
        this.c.set(13, 0);
        this.c.set(14, 1);
    }

    @Override
    protected String getStoragePathP() {
        return "Analytique";
    }

    @Override
    public String getName() {
        if (this.date == null) {
            this.date = new Date();
        }
        return TEMPLATE_ID + this.date;
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected void createListeValues() {
        this.listAllSheetValues = new HashMap();
        this.styleAllSheetValues = new HashMap();
        SQLTable tableAssoc = Configuration.getInstance().getDirectory().getElement("ASSOCIATION_ANALYTIQUE").getTable();
        SQLRowValues rowVals = new SQLRowValues(tableAssoc);
        rowVals.putNulls("MONTANT", "POURCENT");
        rowVals.putRowValues("ID_ECRITURE").putNulls("DEBIT", "CREDIT", "DATE", "COMPTE_NUMERO");
        rowVals.putRowValues("ID_POSTE_ANALYTIQUE").putNulls("NOM").putRowValues("ID_AXE_ANALYTIQUE").putNulls("NOM");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Calendar c = Calendar.getInstance();
                c.set(5, 1);
                c.set(2, 0);
                c.set(10, 0);
                c.set(12, 0);
                input.setWhere(new Where((FieldRef)input.getTable("ECRITURE").getField("DATE"), ">=", (Object)c.getTime()));
                return input;
            }
        });
        List<SQLRowValues> result = fetcher.fetch();
        ArrayList listValues = new ArrayList();
        for (SQLRowValues sqlRowValues : result) {
            HashMap<String, Object> mapSheetValue = new HashMap<String, Object>();
            SQLRowAccessor foreignEcr = sqlRowValues.getForeign("ID_ECRITURE");
            mapSheetValue.put("DATE", foreignEcr.getDate("DATE").getTime());
            mapSheetValue.put("DEBIT", foreignEcr.getLong("DEBIT"));
            mapSheetValue.put("CREDIT", foreignEcr.getLong("CREDIT"));
            mapSheetValue.put("COMPTE", foreignEcr.getString("COMPTE_NUMERO"));
            mapSheetValue.put("POURCENT", sqlRowValues.getObject("POURCENT"));
            mapSheetValue.put("MONTANT", sqlRowValues.getObject("MONTANT"));
            SQLRowAccessor foreignPoste = sqlRowValues.getForeign("ID_POSTE_ANALYTIQUE");
            mapSheetValue.put("POSTE", foreignPoste.getString("NOM"));
            mapSheetValue.put("AXE", foreignPoste.getForeign("ID_AXE_ANALYTIQUE").getString("NOM"));
            listValues.add(mapSheetValue);
        }
        this.listAllSheetValues.put(0, listValues);
    }
}

