/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.erp.generationDoc.SpreadSheetGenerator;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;

public class SpreadSheetGeneratorCompta
extends SpreadSheetGenerator {
    public SpreadSheetGeneratorCompta(SheetInterface sheet, String destFileName, boolean impr, boolean visu) {
        this(sheet, destFileName, impr, visu, true);
    }

    public SpreadSheetGeneratorCompta(SheetInterface sheet, String destFileName, boolean impr, boolean visu, boolean exportPDF) {
        super(sheet, destFileName, impr, visu, exportPDF);
        new Thread(this).start();
    }

    @Override
    protected File generateWithStyle() throws IOException {
        SpreadSheet ssheet = this.loadTemplate();
        if (ssheet == null) {
            return null;
        }
        Map<String, Map<Integer, String>> mapStyleDef = StyleSQLElement.getMapAllStyle();
        Sheet sheet = ssheet.getSheet(0);
        String s = sheet.getPrintRanges() == null ? "" : sheet.getPrintRanges().toString();
        String[] range = s.split(":");
        int i = 0;
        while (i < range.length) {
            String string = range[i];
            range[i] = string.subSequence(string.indexOf(46) + 1, string.length()).toString();
            ++i;
        }
        int colEnd = -1;
        int rowEnd = -1;
        if (range.length > 1) {
            Point resolveHint = sheet.resolveHint(range[1]);
            colEnd = resolveHint.x;
            rowEnd = resolveHint.y;
        }
        this.searchStyle(sheet, mapStyleDef, colEnd, rowEnd);
        if (colEnd > 0) {
            System.err.println("Set Column Count to :: " + (colEnd + 1));
            sheet.setColumnCount(colEnd + 1);
        }
        if (this.nbPage < 1) {
            throw new IllegalArgumentException("invalid page count : " + this.nbPage);
        }
        sheet.duplicateFirstRows(this.nbRowsPerPage, this.nbPage - 1);
        Object printRangeObj = sheet.getPrintRanges();
        if (printRangeObj != null) {
            String[] range2 = printRangeObj.toString().split(":");
            int i2 = 0;
            while (i2 < range2.length) {
                String string = range2[i2];
                range2[i2] = string.subSequence(string.indexOf(46) + 1, string.length()).toString();
                ++i2;
            }
            if (range2.length > 1) {
                int end = sheet.resolveHint((String)range2[1]).y + 1;
                int rowEndNew = end * this.nbPage;
                String sNew = s.replaceAll(String.valueOf(end), String.valueOf(rowEndNew));
                sheet.setPrintRanges(sNew);
                System.err.println("SpreadSheetGenerator ******  Replace print ranges; Old:" + end + "--" + s + " New:" + rowEndNew + "--" + sNew);
            }
        } else {
            sheet.removePrintRanges();
        }
        this.fill(sheet, mapStyleDef);
        return this.save(ssheet);
    }
}

