/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DFontTextDrawer;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DFontTextDrawerDefaultFonts;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.util.Matrix;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.renderer.HyperLink;
import org.jopendocument.renderer.ODTRenderContext;
import org.jopendocument.renderer.ODTRenderer;
import org.openconcerto.erp.generationDoc.PDFAttachment;
import org.openconcerto.erp.preferences.GenerationDocGlobalPreferencePanel;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public class SheetUtils {
    public static File convertToOldFile(DBRoot root, String fileName, File pathDest, File fDest) {
        return SheetUtils.convertToOldFile(root, fileName, pathDest, fDest, ".ods");
    }

    public static File convertToOldFile(DBRoot root, String fileName, File pathDest, File fDest, String extension) {
        return SheetUtils.convertToOldFile(root, fileName, pathDest, fDest, extension, true);
    }

    public static File convertToOldFile(DBRoot root, String fileName, File pathDest, File fDest, String extension, boolean move) {
        SQLPreferences prefs = new SQLPreferences(root);
        if (prefs.getBoolean(GenerationDocGlobalPreferencePanel.HISTORIQUE, true) && fDest.exists()) {
            int i = 0;
            String destName = fileName;
            File pathOld = new File(pathDest, "Historique");
            pathOld.mkdirs();
            while (fDest.exists()) {
                destName = String.valueOf(fileName) + "_" + i;
                fDest = new File(pathOld, String.valueOf(destName) + extension);
                ++i;
            }
            File fTmp = new File(pathDest, String.valueOf(fileName) + extension);
            if (move) {
                if (!fTmp.renameTo(fDest)) {
                    final File finalFile = fDest;
                    System.err.println("Unable to rename:" + fTmp.getAbsolutePath());
                    System.err.println("To:" + fDest.getAbsolutePath());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                JOptionPane.showMessageDialog(null, "Le fichier " + finalFile.getCanonicalPath() + " n'a pu \u00eatre cr\u00e9\u00e9. \n Impossible de d\u00e9placer le fichier existant dans l'historique.\n V\u00e9rifier que le document n'est pas d\u00e9j\u00e0 ouvert.");
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    return fTmp;
                }
            } else {
                try {
                    FileUtils.copyFile(fTmp, fDest);
                }
                catch (IOException exn) {
                    ExceptionHandler.handle("Une erreur est survenue lors de la copie du fichier.", exn);
                }
            }
            fDest = new File(pathDest, String.valueOf(fileName) + extension);
        } else if (fDest.exists()) {
            System.err.println("Suppression du fichier " + fDest.getAbsolutePath());
            boolean delete = fDest.delete();
            if (!delete) {
                System.err.println("Impossible de supprimer " + fDest.getAbsolutePath());
            }
        }
        return fDest;
    }

    public static List<File> getHistorique(final String fileName, File pathDest) {
        File pathOld = new File(pathDest, "Historique");
        File[] files = pathOld.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(fileName);
            }
        });
        ArrayList<File> result = new ArrayList<File>();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                result.add(files[i]);
                ++i;
            }
        }
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    public static void convert2PDF(OpenDocument doc, File pdfFileToCreate) throws Exception {
        SheetUtils.convert2PDF(doc, pdfFileToCreate, Collections.emptyList());
    }

    public static void convert2PDF(OpenDocument doc, File pdfFileToCreate, List<PDFAttachment> attachments) throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
        System.out.println("SheetUtils convert2PDF " + doc.getLoadedFile().getAbsolutePath() + " -> " + pdfFileToCreate.getAbsolutePath());
        try {
            PDDocument document = new PDDocument();
            PDDocumentInformation info = new PDDocumentInformation();
            info.setCreator("OpenConcerto");
            info.setProducer("OpenConcerto");
            info.setCreationDate(Calendar.getInstance());
            info.setModificationDate(Calendar.getInstance());
            document.setDocumentInformation(info);
            PDEmbeddedFilesNameTreeNode efTree = new PDEmbeddedFilesNameTreeNode();
            HashMap<String, PDComplexFileSpecification> efMap = new HashMap<String, PDComplexFileSpecification>();
            for (PDFAttachment att : attachments) {
                PDComplexFileSpecification fs = new PDComplexFileSpecification();
                fs.setFile(att.getFileName());
                ByteArrayInputStream is = new ByteArrayInputStream(att.getBytes());
                PDEmbeddedFile ef = new PDEmbeddedFile(document, (InputStream)is);
                ef.setSubtype(att.getMimetype());
                ef.setSize(att.getBytes().length);
                ef.setCreationDate((Calendar)new GregorianCalendar());
                fs.setEmbeddedFile(ef);
                efMap.put(att.getName(), fs);
            }
            efTree.setNames(efMap);
            PDDocumentNameDictionary names = new PDDocumentNameDictionary(document.getDocumentCatalog());
            names.setEmbeddedFiles(efTree);
            document.getDocumentCatalog().setNames(names);
            PdfBoxGraphics2DFontTextDrawerDefaultFonts fontTextDrawer = new PdfBoxGraphics2DFontTextDrawerDefaultFonts();
            File dir = new File("Fonts");
            if (dir.exists()) {
                System.out.println("Using fonts dir : " + dir.getAbsolutePath());
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int ef = 0;
                while (ef < n) {
                    File f = fileArray[ef];
                    if (f.isFile() && f.getName().toLowerCase().endsWith(".ttf")) {
                        System.out.println("Registering font : " + f.getAbsolutePath());
                        fontTextDrawer.registerFont(f);
                    }
                    ++ef;
                }
            } else {
                System.out.println("No custom fonts dir found : " + dir.getAbsolutePath());
            }
            ODTRenderer renderer = new ODTRenderer(doc);
            renderer.setIgnoreMargins(false);
            renderer.setResizeFactor(100.0);
            renderer.setPaintMaxResolution(true);
            PDRectangle pageSize = PDRectangle.A4;
            double widthFactor = renderer.getPrintWidth() / (double)pageSize.getWidth();
            double heightFactor = renderer.getPrintHeight() / (double)pageSize.getHeight();
            int resizeFactor = (int)Math.ceil(Math.max(widthFactor, heightFactor));
            renderer.setResizeFactor((double)resizeFactor);
            int i = 0;
            while (i < renderer.getPrintedPagesNumber()) {
                PDPage page = new PDPage(pageSize);
                document.addPage(page);
                PdfBoxGraphics2D g2 = new PdfBoxGraphics2D(document, pageSize.getWidth(), pageSize.getHeight());
                g2.setFontTextDrawer((IPdfBoxGraphics2DFontTextDrawer)fontTextDrawer);
                double hMargin = (double)(pageSize.getWidth() - (float)renderer.getPageWidthInPixel()) / 2.0;
                g2.translate(hMargin, 0.0);
                renderer.setCurrentPage(i);
                ODTRenderContext context = new ODTRenderContext((Graphics2D)g2);
                renderer.render(context);
                g2.dispose();
                if (context.getHyperLinks() != null) {
                    for (HyperLink link : context.getHyperLinks()) {
                        PDAnnotationLink alink = new PDAnnotationLink();
                        PDActionURI actionURI = new PDActionURI();
                        actionURI.setURI(link.getHyperLink());
                        alink.setAction((PDAction)actionURI);
                        PDRectangle pdRectangle = new PDRectangle();
                        pdRectangle.setLowerLeftX((float)hMargin + (float)link.getX());
                        float y1 = pageSize.getHeight() - (float)link.getY();
                        float y2 = pageSize.getHeight() - (float)(link.getY() + link.getHeight());
                        pdRectangle.setLowerLeftY(y2);
                        pdRectangle.setUpperRightX((float)((int)hMargin + link.getX() + link.getWidth()));
                        pdRectangle.setUpperRightY(y1);
                        PDBorderStyleDictionary borderULine = new PDBorderStyleDictionary();
                        borderULine.setStyle("D");
                        borderULine.setWidth(0.0f);
                        alink.setBorderStyle(borderULine);
                        alink.setHighlightMode("N");
                        alink.setRectangle(pdRectangle);
                        page.getAnnotations().add(alink);
                    }
                }
                PDFormXObject xform = g2.getXFormObject();
                Matrix matrix = new Matrix();
                matrix.translate(0.0f, 0.0f);
                PDPageContentStream contentStream = new PDPageContentStream(document, page);
                contentStream.transform(matrix);
                contentStream.drawForm(xform);
                contentStream.close();
                ++i;
            }
            document.save(pdfFileToCreate);
            document.close();
        }
        catch (Exception originalExn) {
            ExceptionHandler.handle("Impossible de cr\u00e9er le PDF " + pdfFileToCreate.getAbsolutePath(), originalExn);
        }
    }

    static File getFileWithExtension(File file, String extension) {
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        String name = file.getName();
        int i = name.lastIndexOf(".");
        name = String.valueOf(name.substring(0, i)) + extension;
        File f = new File(file.getParent(), name);
        return f;
    }

    public static void main(String[] args) throws Exception {
        OpenDocument doc = new OpenDocument(new File("../ODSViewer/documents/C2303416_0210042_DUPRAT_Biogaz.ods"));
        File file = new File("out.pdf");
        SheetUtils.convert2PDF(doc, file);
        Desktop.getDesktop().open(file);
    }
}

