/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom2.Element;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;

public class OOXMLTableElement {
    private List<SQLRow> row;
    private int firstLine;
    private int endPageLine;
    private int endLine;
    private int filterId;
    private List<String> listBlankLineStyle;
    private boolean typeStyleWhere;
    private SQLElement elt;
    private String foreignTableWhere;
    private String typeWhere;
    private String fieldWhere;
    private Element tableau;
    private OOXMLCache cache;

    public OOXMLTableElement(Element tableau, SQLRow row, OOXMLCache cache) {
        String fieldAttribute;
        this.tableau = tableau;
        this.cache = cache;
        this.foreignTableWhere = tableau.getAttributeValue("tableForeignWhere");
        this.fieldWhere = tableau.getAttributeValue("fieldWhere");
        if (this.fieldWhere != null && row.getTable().contains(this.fieldWhere)) {
            this.filterId = row.getInt(this.fieldWhere);
        }
        if ((fieldAttribute = tableau.getAttributeValue("field")) != null && fieldAttribute.trim().length() > 0) {
            if (fieldAttribute.contains(",")) {
                List<String> l = SQLRow.toList(fieldAttribute);
                this.row = new ArrayList<SQLRow>();
                for (String string : l) {
                    this.row.add(row.getForeignRow(string));
                }
            } else {
                this.row = Arrays.asList(row.getForeignRow(fieldAttribute));
            }
        } else {
            this.row = Arrays.asList(row);
        }
        this.firstLine = Integer.valueOf(tableau.getAttributeValue("firstLine"));
        this.endPageLine = Integer.valueOf(tableau.getAttributeValue("endPageLine"));
        this.endLine = Integer.valueOf(tableau.getAttributeValue("endLine"));
        this.elt = Configuration.getInstance().getDirectory().getElement(tableau.getAttributeValue("table"));
        this.typeWhere = tableau.getAttributeValue("typeWhere");
        String blankLineBeforeStyle = tableau.getAttributeValue("blankLineBeforeStyle");
        this.listBlankLineStyle = new ArrayList<String>();
        if (blankLineBeforeStyle != null) {
            this.listBlankLineStyle = SQLRow.toList(blankLineBeforeStyle.trim());
        }
        this.typeStyleWhere = this.typeWhere == null ? false : this.typeWhere.equalsIgnoreCase("Style");
    }

    public List<? extends SQLRowAccessor> getRows() {
        String foreignTableName = this.tableau.getAttributeValue("table");
        SQLTable tableElt = null;
        if (!this.row.isEmpty()) {
            SQLTable tableRow = this.row.get(0).getTable();
            tableElt = tableRow.getDBRoot().contains(foreignTableName) ? tableRow.getDBRoot().getTable(foreignTableName) : Configuration.getInstance().getRoot().findTable(foreignTableName);
        }
        if (tableElt != null) {
            return this.cache.getReferentRows(this.row, tableElt, this.tableau.getAttributeValue("groupBy"), this.tableau.getAttributeValue("orderBy"), Boolean.valueOf(this.tableau.getAttributeValue("expandNomenclature")), this.tableau.getAttributeValue("foreignField"), Boolean.valueOf(this.tableau.getAttributeValue("excludeZeroQty")));
        }
        System.err.println("OOXMLTableElement.getRows() Table " + tableElt + " is null!");
        return new ArrayList();
    }

    public int getFirstLine() {
        return this.firstLine;
    }

    public int getFilterId() {
        return this.filterId;
    }

    public int getEndPageLine() {
        return this.endPageLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public List<String> getListBlankLineStyle() {
        return this.listBlankLineStyle;
    }

    public SQLElement getSQLElement() {
        return this.elt;
    }

    public String getForeignTableWhere() {
        return this.foreignTableWhere;
    }

    public List<SQLRow> getRow() {
        return this.row;
    }

    public Element getTableau() {
        return this.tableau;
    }

    public String getTypeWhere() {
        return this.typeWhere;
    }

    public boolean getTypeStyleWhere() {
        return this.typeStyleWhere;
    }

    public String getFieldWhere() {
        return this.fieldWhere;
    }
}

