/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.util.List;
import org.jdom2.Element;
import org.openconcerto.erp.core.edm.Attachment;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.StringUtils;

public class OOXMLLink {
    private final String url;
    private String text;
    private String link;
    private String fieldPathEDM;
    private String edmProvider;
    private final SQLRowAccessor row;

    public OOXMLLink(Element e, SQLRowAccessor row) {
        this.row = row;
        this.url = e.getAttributeValue("url");
        this.link = e.getAttributeValue("link", "");
        this.text = e.getAttributeValue("text", this.link);
        this.fieldPathEDM = e.getAttributeValue("fieldPathEDM");
        this.edmProvider = e.getAttributeValue("edmProvider");
        this.fetchDataFromEDM();
    }

    private void fetchDataFromEDM() {
        if (this.url.startsWith("edm://")) {
            Path p = new Path(this.row.getTable());
            SQLRow r = this.row.asRow();
            String sourceTableName = r.getTable().getName();
            int sourceID = r.getID();
            if (this.fieldPathEDM == null || this.fieldPathEDM.isEmpty() || this.fieldPathEDM.equalsIgnoreCase(".")) {
                SQLRow rowToEdm = r;
            } else if (this.fieldPathEDM != null && this.fieldPathEDM.equalsIgnoreCase("EDM_PROVIDER")) {
                SpreadSheetCellValueProvider provider = SpreadSheetCellValueProviderManager.get(this.edmProvider);
                SQLRow rowToEdm = (SQLRow)provider.getValue(new SpreadSheetCellValueContext(r));
                if (rowToEdm == null) {
                    return;
                }
                sourceTableName = rowToEdm.getTable().getName();
                sourceID = rowToEdm.getID();
            } else {
                List<String> fields = StringUtils.fastSplit(this.fieldPathEDM, '.');
                if (fields.size() == 1) {
                    sourceTableName = r.getTable().getForeignTable(fields.get(0)).getName();
                    sourceID = r.getForeignID(fields.get(0));
                } else {
                    for (String f : fields) {
                        p = (Path)p.add(p.getLast().getField(f));
                    }
                    SQLRow rowToEdm = r.getDistantRow(p);
                    sourceTableName = rowToEdm.getTable().getName();
                    sourceID = rowToEdm.getID();
                }
            }
            SQLTable tableAttachment = this.row.getTable().getTable("ATTACHMENT");
            SQLRowValues rowVals = new SQLRowValues(tableAttachment);
            rowVals.putNulls(tableAttachment.getFieldsName());
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
            Where where = new Where((FieldRef)tableAttachment.getField("SOURCE_TABLE"), "=", (Object)sourceTableName);
            where = where.and(new Where((FieldRef)tableAttachment.getField("SOURCE_ID"), "=", sourceID));
            where = where.and(new Where((FieldRef)tableAttachment.getField("NAME"), "=", (Object)this.url.replaceAll("edm://", "")));
            List<SQLRowValues> rAttachments = fetcher.fetch(where);
            if (!rAttachments.isEmpty()) {
                SQLRowValues rowValsAttachment = rAttachments.get(0);
                Attachment a = new Attachment(rowValsAttachment);
                this.link = a.getFileName();
                if (this.text.isEmpty()) {
                    this.text = a.getName();
                }
            }
        } else {
            this.link = this.url;
            if (this.text.isEmpty()) {
                this.text = this.url;
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public String getLink() {
        return this.link;
    }
}

