/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.generationDoc.DocumentGenerator;

public class DocumentGeneratorManager {
    private static DocumentGeneratorManager instance = new DocumentGeneratorManager();
    private Map<String, DocumentGenerator> generators = new HashMap<String, DocumentGenerator>();
    private DocumentGenerator defautGenerator;

    public static DocumentGeneratorManager getInstance() {
        return instance;
    }

    public void add(String templateId, DocumentGenerator generator) {
        this.generators.put(templateId, generator);
    }

    public void remove(DocumentGenerator generator) {
        Set<String> keys = this.generators.keySet();
        for (String key : keys) {
            if (!this.generators.get(key).equals(generator)) continue;
            this.generators.remove(key);
        }
    }

    public void setDefaultGenerator(DocumentGenerator generator) {
        this.defautGenerator = generator;
    }

    public DocumentGenerator getGenerator(String templateId) {
        DocumentGenerator generator = this.generators.get(templateId);
        if (generator == null) {
            generator = this.defautGenerator;
        }
        return generator;
    }

    public void dump() {
        System.out.println(this.getClass().getCanonicalName());
        System.out.println("Default generator:" + this.defautGenerator);
        Set<String> ids = this.generators.keySet();
        for (String templateId : ids) {
            System.out.println("'" + templateId + "' : " + this.generators.get(templateId));
        }
    }
}

