/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import java.io.IOException;
import org.openconcerto.erp.generationDoc.AbstractLocalTemplateProvider;
import org.openconcerto.utils.FileUtils;

public class DefaultLocalTemplateProvider
extends AbstractLocalTemplateProvider {
    private static final String[] EXTS = new String[]{".ods", ".odsp", ".xml"};
    private static final String LOCAL = "local_";
    private File baseDirectory = new File("Configuration/Template/Default");

    public void setBaseDirectory(File dir) {
        this.baseDirectory = dir;
    }

    @Override
    public File getTemplateFromLocalFile(String templateIdWithExtension, String language, String type) {
        File file = this.getLocalFile(templateIdWithExtension, language, type);
        if (file != null && !file.exists()) {
            file = this.getFile(templateIdWithExtension, language, type);
        }
        return file;
    }

    private File getLocalFile(String templateIdWithExtension, String language, String type) {
        String localPath = templateIdWithExtension;
        if (type != null && (localPath = DefaultLocalTemplateProvider.insertBeforeExtenstion(localPath, type)) == null) {
            return null;
        }
        localPath = language != null && language.trim().length() > 0 ? String.valueOf(language) + File.separatorChar + LOCAL + localPath : LOCAL + localPath;
        File file = new File(this.baseDirectory, localPath);
        return file;
    }

    private File getFile(String templateIdWithExtension, String language, String type) {
        File file;
        String path = templateIdWithExtension;
        if (type != null && (path = DefaultLocalTemplateProvider.insertBeforeExtenstion(path, type)) == null) {
            return null;
        }
        if (language != null && language.trim().length() > 0) {
            path = String.valueOf(language) + File.separatorChar + path;
        }
        if (!(file = new File(this.baseDirectory, path)).exists()) {
            file = new File("Configuration/Template/Default", path);
        }
        return file;
    }

    @Override
    public String getTemplatePath(String templateId, String language, String type) {
        String path = "Configuration/Template/Default";
        if (type != null && (path = DefaultLocalTemplateProvider.insertBeforeExtenstion(path, type)) == null) {
            return null;
        }
        if (language != null) {
            path = String.valueOf(language) + '/' + path;
        }
        return path;
    }

    @Override
    public boolean isSynced(String templateId, String language, String type) {
        return !this.getLocalFile(String.valueOf(templateId) + ".ods", language, type).exists();
    }

    @Override
    public void unSync(String templateId, String language, String type) {
        int i = 0;
        while (i < EXTS.length) {
            String ext = EXTS[i];
            File from = this.getFile(String.valueOf(templateId) + ext, language, type);
            File to = this.getLocalFile(String.valueOf(templateId) + ext, language, type);
            try {
                File parentDir;
                if (from != null && to != null && from.exists() && !to.exists() && (parentDir = to.getParentFile()) != null) {
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    FileUtils.copyFile(from, to);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Copie impossible", e);
            }
            ++i;
        }
    }

    @Override
    public void sync(String templateId, String language, String type) {
        int i = 0;
        while (i < EXTS.length) {
            String ext = EXTS[i];
            File from = this.getLocalFile(String.valueOf(templateId) + ext, language, type);
            File to = this.getFile(String.valueOf(templateId) + ext, language, type);
            try {
                if (from.exists()) {
                    FileUtils.copyFile(from, to);
                    this.ensureDelete(from);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Synchronisation impossible", e);
            }
            ++i;
        }
    }

    @Override
    public void restore(String templateId, String language, String type) {
        int i = 0;
        while (i < EXTS.length) {
            String ext = EXTS[i];
            File local = this.getLocalFile(String.valueOf(templateId) + ext, language, type);
            if (local != null && local.exists()) {
                local.delete();
                this.ensureDelete(local);
            }
            ++i;
        }
    }
}

