/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openconcerto.erp.generationDoc.TemplateProvider;

public abstract class AbstractLocalTemplateProvider
implements TemplateProvider {
    @Override
    public InputStream getTemplate(String templateId, String language, String type) {
        if (templateId == null) {
            throw new NullPointerException("null templateId");
        }
        File file = this.getFileTemplate(templateId, language, type);
        return file == null ? null : this.getInputStream(file);
    }

    private FileInputStream getInputStream(File f) {
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: no file:" + f.getAbsolutePath());
            e.printStackTrace();
            return null;
        }
    }

    public File getFileTemplate(String templateId, String language, String type) {
        if (templateId == null) {
            throw new NullPointerException("null templateId");
        }
        File templateFile1 = this.getTemplateFromLocalFile(templateId, language, type);
        if (templateFile1 != null && templateFile1.exists() && !templateFile1.isDirectory()) {
            return templateFile1;
        }
        File templateFile2 = this.getTemplateFromLocalFile(String.valueOf(templateId) + ".ods", language, type);
        if (templateFile2 != null && templateFile2.exists()) {
            return templateFile2;
        }
        File templateFile3 = this.getTemplateFromLocalFile(String.valueOf(templateId) + ".odt", language, type);
        if (templateFile3 != null && templateFile3.exists()) {
            return templateFile3;
        }
        String files = "";
        if (templateFile1 != null) {
            files = String.valueOf(files) + "'" + templateFile1.getAbsolutePath() + "' ";
        }
        if (templateFile2 != null) {
            files = String.valueOf(files) + "'" + templateFile2.getAbsolutePath() + "' ";
        }
        if (templateFile3 != null) {
            files = String.valueOf(files) + "'" + templateFile3.getAbsolutePath() + "'";
        }
        System.err.println("AbstractLocalTemplateProvider.getFileTemplate() failed for id:" + templateId + " language:" + language + " type:" + type + " files:" + files);
        return null;
    }

    @Override
    public InputStream getTemplatePrintConfiguration(String templateId, String language, String type) {
        if (templateId == null) {
            throw new NullPointerException("null templateId");
        }
        File file = this.getFileTemplatePrintConfiguration(templateId, language, type);
        return this.getInputStream(file);
    }

    public File getFileTemplatePrintConfiguration(String templateId, String language, String type) {
        if (templateId == null) {
            throw new NullPointerException("null templateId");
        }
        File file = this.getTemplateFromLocalFile(String.valueOf(templateId) + ".odsp", language, type);
        return file;
    }

    @Override
    public InputStream getTemplateConfiguration(String templateId, String language, String type) {
        if (templateId == null) {
            throw new NullPointerException("null templateId");
        }
        File file = this.getFileTemplateConfiguration(templateId, language, type);
        if (!file.exists()) {
            return null;
        }
        return this.getInputStream(file);
    }

    public File getFileTemplateConfiguration(String templateId, String language, String type) {
        if (templateId == null) {
            throw new NullPointerException("null templateId");
        }
        File file = this.getTemplateFromLocalFile(String.valueOf(templateId) + ".xml", language, type);
        return file;
    }

    protected abstract File getTemplateFromLocalFile(String var1, String var2, String var3);

    @Override
    public abstract String getTemplatePath(String var1, String var2, String var3);

    public static String insertBeforeExtenstion(String fileName, String text) {
        if (fileName == null) {
            throw new NullPointerException("null fileName");
        }
        if (text == null) {
            throw new NullPointerException("null text");
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        if (index == 0) {
            return String.valueOf(fileName) + text;
        }
        String name = fileName.substring(0, index);
        String ext = fileName.substring(index);
        return String.valueOf(name) + text + ext;
    }

    void ensureDelete(File f) {
        int i = 0;
        while (i < 2) {
            if (f.delete()) {
                return;
            }
            JOptionPane.showMessageDialog(new JFrame(), "Fichier " + f.getAbsolutePath() + " v\u00e9rrouill\u00e9.\nMerci de fermer tout programme pouvant y acc\u00e9der (OpenOffice).");
            ++i;
        }
        f.deleteOnExit();
    }
}

