/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.element.objet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;

public class ClasseCompte {
    private int id;
    private String nom;
    private String typeNumeroCompte;
    private static List<ClasseCompte> liste;

    public static void loadClasseCompte(ComptaPropsConfiguration conf) {
        DBRoot base = conf.getRootSociete();
        SQLTable classeCompteTable = base.getTable("CLASSE_COMPTE");
        SQLSelect selClasse = new SQLSelect();
        selClasse.addSelect(classeCompteTable.getField("ID"));
        selClasse.addSelect(classeCompteTable.getField("NOM"));
        selClasse.addSelect(classeCompteTable.getField("TYPE_NUMERO_COMPTE"));
        selClasse.addRawOrder("\"CLASSE_COMPTE\".\"TYPE_NUMERO_COMPTE\"");
        String reqClasse = selClasse.asString();
        System.err.println(reqClasse);
        List obClasse = base.getDBSystemRoot().getDataSource().execute(reqClasse);
        liste = new ArrayList<ClasseCompte>();
        for (Map map : obClasse) {
            liste.add(new ClasseCompte(Integer.parseInt(map.get("ID").toString()), map.get("NOM").toString(), map.get("TYPE_NUMERO_COMPTE").toString()));
        }
    }

    public static List<ClasseCompte> getClasseCompte() {
        return liste;
    }

    public ClasseCompte(int id, String nom, String typeNumeroCompte) {
        this.id = id;
        this.nom = nom;
        this.typeNumeroCompte = typeNumeroCompte;
    }

    public int getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public String getTypeNumeroCompte() {
        return this.typeNumeroCompte;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void setTypeNumeroCompte(String type) {
        this.typeNumeroCompte = type;
    }

    public String toString() {
        return "ID : " + this.id + " nom : " + this.nom + " type numero de compte : " + this.typeNumeroCompte;
    }
}

