/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.report;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.core.supplychain.stock.report.SQLRowValuesTreeNode;
import org.openconcerto.sql.model.SQLRowValues;

public class SQLRowValuesTree {
    List<SQLRowValuesTreeNode> children = new ArrayList<SQLRowValuesTreeNode>();

    public SQLRowValuesTree(List<SQLRowValues> all, String fieldName) {
        HashMap<Number, SQLRowValuesTreeNode> map = new HashMap<Number, SQLRowValuesTreeNode>(all.size());
        for (SQLRowValues r : all) {
            SQLRowValuesTreeNode node = new SQLRowValuesTreeNode(r);
            map.put(r.getIDNumber(), node);
        }
        for (SQLRowValues r : all) {
            Number foreignIDNumber = r.getForeignIDNumber(fieldName);
            SQLRowValuesTreeNode node = (SQLRowValuesTreeNode)map.get(r.getIDNumber());
            SQLRowValuesTreeNode sqlRowValuesTreeNode = (SQLRowValuesTreeNode)map.get(foreignIDNumber);
            if (sqlRowValuesTreeNode != null) {
                sqlRowValuesTreeNode.addChild(node);
                continue;
            }
            this.children.add(node);
        }
    }

    public List<SQLRowValuesTreeNode> getChildren() {
        return this.children;
    }

    public void dump(PrintStream prt) {
        for (SQLRowValuesTreeNode n : this.children) {
            n.dump(0, prt);
        }
    }
}

