/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.openconcerto.erp.core.supplychain.stock.element.BatchNode;
import org.openconcerto.erp.core.supplychain.stock.element.StockNode;
import org.openconcerto.erp.core.supplychain.stock.element.StockRootNode;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.ui.table.AbstractTreeTableModel;
import org.openconcerto.ui.table.TreeTableModel;

public class StockTreeModel
extends AbstractTreeTableModel {
    static final SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");

    public StockTreeModel(Object root) {
        super(root);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof StockRootNode) {
            return ((StockRootNode)parent).getChild(index);
        }
        if (parent instanceof StockNode) {
            return ((StockNode)parent).getLot(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof StockRootNode) {
            int size = ((StockRootNode)parent).getSize();
            return size;
        }
        if (parent instanceof StockNode) {
            int size = ((StockNode)parent).getLotSize();
            return size;
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof StockRootNode) {
            return false;
        }
        if (node instanceof StockNode) {
            return ((StockNode)node).getLotSize() == 0;
        }
        return true;
    }

    @Override
    public int getColumnCount() {
        if (((StockRootNode)this.getRoot()).hasBatch()) {
            return 6;
        }
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "D\u00e9p\u00f4t";
        }
        if (column >= 1 && column < 5) {
            return ((StockRootNode)this.getRoot()).getLabelFor(column);
        }
        if (column == 5) {
            return "DLC/DLUO";
        }
        return "";
    }

    @Override
    public Class getColumnClass(int column) {
        if (column == 0) {
            return TreeTableModel.class;
        }
        if (column > 0 && column < 5) {
            return Float.class;
        }
        if (column == 5) {
            return Date.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (node instanceof StockRootNode) {
            return null;
        }
        if (node instanceof StockNode) {
            StockNode n = (StockNode)node;
            if (column >= 5) {
                return null;
            }
            StockRootNode root = (StockRootNode)this.getRoot();
            FieldPath fieldPath = root.getFieldPath(column);
            return n.getValueAt(fieldPath, column);
        }
        if (node instanceof BatchNode) {
            BatchNode rLot = (BatchNode)node;
            if (column == 4) {
                return Float.valueOf(rLot.getValues().getBigDecimal("QUANTITE").floatValue());
            }
            if (column == 5) {
                Calendar c1 = rLot.getValues().getDate("DLC");
                Calendar c2 = rLot.getValues().getDate("DUO");
                if (c1 == null && c2 != null) {
                    return c2.getTime();
                }
                if (c2 == null && c1 != null) {
                    return c1.getTime();
                }
                if (c1 != null && c2 != null) {
                    if (c1.before(c2)) {
                        return c1.getTime();
                    }
                    return c2.getTime();
                }
                return null;
            }
        }
        return null;
    }

    public void load(SQLRowAccessor article) {
        ((StockRootNode)this.getRoot()).load(article);
        this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, new int[1], new Object[0]);
    }
}

