/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.InventaireFromEtatStockImporter;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;

public class ImportInventairePanel
extends JPanel {
    public ImportInventairePanel(final SQLElement depotElt) {
        super(new GridBagLayout());
        final SQLRequestComboBox boxDepot = new SQLRequestComboBox(false);
        boxDepot.uiInit(depotElt.createComboRequest());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JLabel labelCom = new JLabel("D\u00e9p\u00f4t ");
        this.add((Component)labelCom, c);
        ++c.gridx;
        this.add((Component)boxDepot, c);
        JButton buttonValid = new JButton(new AbstractAction("Valider"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow row = boxDepot.getSelectedRow();
                if (row != null && !row.isUndefined()) {
                    SQLRow rowDepot = boxDepot.getSelectedRow();
                } else {
                    SQLRow rowDepot = depotElt.getTable().getRow(DepotStockSQLElement.DEFAULT_ID);
                }
                ((Window)SwingUtilities.getRoot(ImportInventairePanel.this)).dispose();
                Frame frame = SwingThreadUtils.getAncestorOrSelf(Frame.class, (Component)e.getSource());
                FileDialog fd = new FileDialog(frame, "Import Inventaire", 0);
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    final File f = new File(fd.getDirectory(), fd.getFile());
                    if (!f.exists()) {
                        JOptionPane.showMessageDialog(null, "Le ficher selectionn\u00e9 n'existe pas", "Erreur", 0);
                    } else if (f.isDirectory()) {
                        JOptionPane.showMessageDialog(null, "Le fichier selectionn\u00e9 n'est pas valide", "Erreur", 0);
                    } else {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                final InventaireFromEtatStockImporter impoter = new InventaireFromEtatStockImporter(depotElt.getDirectory().getElement("ARTICLE"));
                                try {
                                    SQLUtils.executeAtomic(depotElt.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

                                        @Override
                                        public Object handle(SQLDataSource ds) throws SQLException, IOException {
                                            impoter.importArticles(f, depotElt.getTable().getDBRoot());
                                            return null;
                                        }
                                    });
                                }
                                catch (Exception e1) {
                                    ExceptionHandler.handle("Erreur lors de l'importation", e1);
                                }
                            }
                        }).start();
                    }
                }
            }
        });
        ++c.gridx;
        this.add((Component)buttonValid, c);
    }
}

