/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.erp.core.sales.invoice.report.EtatStockInventaireXmlSheet;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.EtatStockCreationPanel;
import org.openconcerto.erp.core.supplychain.stock.element.EtatStockGroup;
import org.openconcerto.erp.core.supplychain.stock.element.EtatStockSnapshotCreator;
import org.openconcerto.erp.core.supplychain.stock.element.EtatStockTable;
import org.openconcerto.erp.core.supplychain.stock.element.InventaireFromEtatStockImporter;
import org.openconcerto.erp.core.supplychain.stock.report.StockReportPDF;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public class EtatStockSQLElement
extends ComptaSQLConfElement {
    public EtatStockSQLElement() {
        super("ETAT_STOCK");
        this.setDefaultGroup(new EtatStockGroup());
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("Cr\u00e9er un \u00e9tat de stock"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelFrame frame = new PanelFrame(new EtatStockCreationPanel(EtatStockSQLElement.this.getDirectory().getElement(DepotStockSQLElement.class)), "Cr\u00e9ation \u00e9tat de stock");
                FrameUtil.showPacked(frame);
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate(0, Integer.MAX_VALUE));
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Import Inventaire"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = SwingThreadUtils.getAncestorOrSelf(Frame.class, (Component)e.getSource());
                FileDialog fd = new FileDialog(frame, "Import Inventaire", 0);
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    final File f = new File(fd.getDirectory(), fd.getFile());
                    if (!f.exists()) {
                        JOptionPane.showMessageDialog(null, "Le ficher selectionn\u00e9 n'existe pas", "Erreur", 0);
                    } else if (f.isDirectory()) {
                        JOptionPane.showMessageDialog(null, "Le fichier selectionn\u00e9 n'est pas valide", "Erreur", 0);
                    } else {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                final InventaireFromEtatStockImporter impoter = new InventaireFromEtatStockImporter(EtatStockSQLElement.this.getDirectory().getElement("ARTICLE"));
                                try {
                                    SQLUtils.executeAtomic(EtatStockSQLElement.this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

                                        @Override
                                        public Object handle(SQLDataSource ds) throws SQLException, IOException {
                                            impoter.importArticles(f, EtatStockSQLElement.this.getTable().getDBRoot());
                                            return null;
                                        }
                                    });
                                }
                                catch (Exception e1) {
                                    ExceptionHandler.handle("Erreur lors de l'importation", e1);
                                }
                            }
                        }).start();
                    }
                }
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate(0, Integer.MAX_VALUE));
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Export d'\u00e9tat pour inventaire"){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtatStockInventaireXmlSheet sheet = new EtatStockInventaireXmlSheet(EtatStockSQLElement.this.getDirectory(), SQLRow.getIDs(IListe.get(e).getSelectedRowAccessors()));
                try {
                    sheet.createDocument();
                    sheet.showPrintAndExport(true, false, false, false, false, Collections.emptyList());
                }
                catch (Exception e1) {
                    ExceptionHandler.handle("Erreur lors de la cr\u00e9ation de l'inventaire", e1);
                }
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("G\u00e9n\u00e9rer tous les \u00e9tats de stock"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLSelect sel = new SQLSelect();
                sel.addSelectStar(EtatStockSQLElement.this.getTable().getForeignTable("ID_DEPOT_STOCK"));
                List<SQLRow> rowsDepot = SQLRowListRSH.execute(sel);
                HashSet<Number> idsEtat = new HashSet<Number>();
                for (SQLRow rowDepot : rowsDepot) {
                    Date d;
                    EtatStockSnapshotCreator creator = new EtatStockSnapshotCreator(rowDepot, d = new Date(), EtatStockSQLElement.this.getTable().getDBRoot(), false);
                    int etat = creator.create();
                    if (etat == -1) continue;
                    idsEtat.add(etat);
                }
                if (!idsEtat.isEmpty()) {
                    EtatStockInventaireXmlSheet sheet = new EtatStockInventaireXmlSheet(EtatStockSQLElement.this.getDirectory(), idsEtat);
                    try {
                        sheet.createDocument();
                        sheet.showPrintAndExport(true, false, false, false, false, Collections.emptyList());
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle("Erreur lors de la cr\u00e9ation de l'inventaire", e1);
                    }
                }
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate(0, Integer.MAX_VALUE));
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Voir les articles"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLElement element = EtatStockSQLElement.this.getDirectory().getElement("ETAT_STOCK_ELEMENT");
                SQLTableModelSourceOnline source = element.createTableSource(new Where((FieldRef)element.getTable().getField("ID_ETAT_STOCK"), "=", IListe.get(e).getSelectedId()));
                ListeViewPanel panel = new ListeViewPanel(element, new IListe(source));
                IListFrame frame = new IListFrame(panel);
                FrameUtil.show(frame);
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Inventaire chiffr\u00e9"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow r = IListe.get(e).getSelectedRow().fetchNewRow();
                try {
                    String companyName = ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getString("NOM");
                    Calendar date = r.getDate("DATE");
                    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
                    StockReportPDF pdf = new StockReportPDF(companyName, df.format(date.getTime()));
                    pdf.addStockDepot(r);
                    File f = new File("out.pdf");
                    pdf.savePDF(f);
                    FileUtils.openFile(f);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle("Erreur", ex);
                }
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>(3);
        l.add("DATE");
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        boolean hasDeclinaison = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false);
        if (hasDeclinaison) {
            l.add("ID_DEPOT_STOCK");
        }
        l.add("MONTANT_HA");
        l.add("INVENTAIRE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>(2);
        l.add("DATE");
        l.add("MONTANT_HA");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new GroupSQLComponent(this){

            @Override
            public JComponent createEditor(String id) {
                if (id.equals("supplychain.stock.state.items")) {
                    return new EtatStockTable((JTextField)this.getEditor("MONTANT_HA"));
                }
                return super.createEditor(id);
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                EtatStockTable table = (EtatStockTable)this.getEditor("supplychain.stock.state.items");
                if (r != null) {
                    table.insertFrom("ID_ETAT_STOCK", r.getID());
                }
            }

            @Override
            public void update() {
                super.update();
                EtatStockTable table = (EtatStockTable)this.getEditor("supplychain.stock.state.items");
                table.updateField("ID_ETAT_STOCK", this.getSelectedID());
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".state";
    }
}

