/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openconcerto.erp.core.sales.product.model.PriceByQty;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.Tuple3;

public class EtatStockFromInventoryFileCreator {
    private static String FAMILLE = "Famille";
    private static String CODE = "Code";
    private static String NOM = "Nom";
    private static String TAILLE = "Taille";
    private static String COULEUR = "Couleur";
    private static String QTE = "Qt\u00e9 r\u00e9elle relev\u00e9e";
    private final Map<String, Integer> mapCouleur = new HashMap<String, Integer>();
    private final Map<String, Integer> mapTaille = new HashMap<String, Integer>();
    private final DBRoot root;
    private final SQLElement artElt;
    private final Map<String, SQLRowAccessor> mapArticle = new HashMap<String, SQLRowAccessor>();
    private final Map<Tuple3<String, String, String>, SQLRowAccessor> mapDeclArticle = new HashMap<Tuple3<String, String, String>, SQLRowAccessor>();

    public EtatStockFromInventoryFileCreator(SQLElement artElt) {
        this.artElt = artElt;
        this.root = artElt.getTable().getDBRoot();
    }

    public void importArticles(File file, Date d) throws IOException, SQLException {
        SQLTable table = this.root.findTable("ARTICLE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(table.getDBRoot().getTable("ARTICLE_DECLINAISON_COULEUR").getKey());
        sel.addSelect(table.getDBRoot().getTable("ARTICLE_DECLINAISON_COULEUR").getField("NOM"));
        List<SQLRow> l = SQLRowListRSH.execute(sel);
        for (SQLRow sqlRow : l) {
            this.mapCouleur.put(sqlRow.getString("NOM").trim(), sqlRow.getID());
        }
        sel = new SQLSelect();
        sel.addSelect(table.getDBRoot().getTable("ARTICLE_DECLINAISON_TAILLE").getKey());
        sel.addSelect(table.getDBRoot().getTable("ARTICLE_DECLINAISON_TAILLE").getField("NOM"));
        l = SQLRowListRSH.execute(sel);
        for (SQLRow sqlRow : l) {
            this.mapTaille.put(sqlRow.getString("NOM").trim(), sqlRow.getID());
        }
        this.fillArticles();
        HashMap<String, Integer> columnMapping = new HashMap<String, Integer>();
        columnMapping.put(CODE, null);
        columnMapping.put(NOM, null);
        columnMapping.put(TAILLE, null);
        columnMapping.put(FAMILLE, null);
        columnMapping.put(COULEUR, null);
        columnMapping.put(QTE, null);
        DataImporter importer = new DataImporter(table);
        importer.setSkipFirstLine(false);
        ArrayTableModel m = importer.createModelFrom(file);
        List line = m.getLineValuesAt(0);
        int i = 0;
        while (i < line.size()) {
            Object e = line.get(i);
            if (e != null) {
                for (Object key : columnMapping.keySet()) {
                    if (!e.toString().equalsIgnoreCase((String)key)) continue;
                    columnMapping.put((String)key, i);
                }
            }
            ++i;
        }
        String msg = "Colonnes import\u00e9es : \n";
        SQLPreferences prefs = SQLPreferences.getMemCached(table.getDBRoot());
        boolean hasDeclinaison = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false);
        List<String> required = hasDeclinaison ? Arrays.asList(CODE, QTE, TAILLE, COULEUR) : Arrays.asList(CODE, QTE);
        for (Map.Entry entry : columnMapping.entrySet()) {
            if (entry.getValue() != null) {
                msg = String.valueOf(msg) + (String)entry.getKey() + " : " + this.getColumnName((Integer)entry.getValue()) + "\n";
                continue;
            }
            if (required.contains(entry.getKey())) {
                JOptionPane.showMessageDialog(null, "Aucune colonne " + (String)entry.getKey() + " trouv\u00e9e, import annul\u00e9!\nCette colonne est obligatoire.");
                return;
            }
            msg = String.valueOf(msg) + (String)entry.getKey() + " : non import\u00e9e\n";
        }
        int n = JOptionPane.showConfirmDialog(null, msg = String.valueOf(msg) + "\nVoulez vous continuer ?");
        if (n == 0) {
            DataImporter importer2 = new DataImporter(table){

                protected void customizeRowValuesToFetch(SQLRowValues vals) {
                    vals.putRowValues("ID_STOCK").putNulls("ID", "QTE_REEL", "QTE_TH");
                }
            };
            importer2.setSkipFirstLine(true);
            ArrayTableModel m2 = importer2.createModelFrom(file);
            SQLRowValues rowValsEtatStock = new SQLRowValues(table.getTable("ETAT_STOCK"));
            rowValsEtatStock.put("DATE", d);
            SQLRow etatStock = rowValsEtatStock.commit();
            BigDecimal total = BigDecimal.ZERO;
            int i2 = 0;
            while (i2 < m2.getRowCount()) {
                SQLRowAccessor match;
                List o = m2.getLineValuesAt(i2);
                String code = o.get((Integer)columnMapping.get(CODE)).toString();
                if (code.trim().length() == 0) break;
                String stringQty = o.get((Integer)columnMapping.get(QTE)).toString();
                Integer qty = stringQty.trim().length() == 0 ? 0 : Integer.valueOf(stringQty);
                String couleur = "";
                if (columnMapping.get(COULEUR) != null) {
                    couleur = o.get((Integer)columnMapping.get(COULEUR)).toString();
                }
                String taille = "";
                if (columnMapping.get(TAILLE) != null) {
                    taille = o.get((Integer)columnMapping.get(TAILLE)).toString();
                }
                if ((match = this.findArticle(code, couleur, taille)) != null) {
                    SQLRowValues stockValues = new SQLRowValues(table.getTable("ETAT_STOCK_ELEMENT"));
                    BigDecimal qtyB = new BigDecimal(qty);
                    stockValues.put("QTE", qtyB);
                    stockValues.put("NOM", match.getString("NOM"));
                    stockValues.put("CODE", match.getString("CODE"));
                    stockValues.put("ID_ARTICLE", match.getID());
                    BigDecimal prc = this.getPRC(match, qty, d);
                    stockValues.put("PA", prc);
                    BigDecimal totalElt = prc.multiply(qtyB);
                    stockValues.put("T_PA", totalElt);
                    stockValues.put("ID_ETAT_STOCK", etatStock.getID());
                    stockValues.commit();
                    total = total.add(totalElt);
                } else {
                    System.err.println("Aucun article correspondant au code " + code);
                }
                ++i2;
            }
            etatStock.createEmptyUpdateRow().put("MONTANT_HA", total).commit();
        }
    }

    public BigDecimal getPRC(SQLRowAccessor rowVals, int qty, Date d) {
        if (rowVals.getTable().getDBRoot().contains("ARTICLE_PRIX_REVIENT")) {
            SQLTable table = rowVals.getTable().getDBRoot().getTable("ARTICLE_PRIX_REVIENT");
            Collection prcs = rowVals.asRow().getReferentRows(table);
            BigDecimal result = null;
            ArrayList<PriceByQty> prices = new ArrayList<PriceByQty>();
            for (SQLRow row : prcs) {
                Calendar date = Calendar.getInstance();
                date.set(5, 1);
                date.set(2, 1);
                date.set(1, 2001);
                if (row.getObject("DATE") != null) {
                    date = row.getDate("DATE");
                }
                prices.add(new PriceByQty(row.getLong("QTE"), row.getBigDecimal("PRIX"), date.getTime()));
            }
            result = PriceByQty.getPriceForQty(qty, prices, d);
            if (result == null) {
                result = BigDecimal.ZERO;
            }
            return result;
        }
        return rowVals.getBigDecimal("PA_HT");
    }

    private void fillArticles() throws SQLException {
        SQLTable table = Configuration.getInstance().getRoot().findTable("ARTICLE");
        SQLRowValues graph = new SQLRowValues(table);
        graph.put("ID", null);
        graph.put("CODE", null);
        graph.put("SYNC_ID", null);
        graph.put("NOM", null);
        graph.put("PA_HT", null);
        graph.putRowValues("ID_STOCK").putNulls("ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE");
        graph.putRowValues("ID_ARTICLE_DECLINAISON_COULEUR").putNulls("ID", "NOM");
        graph.putRowValues("ID_ARTICLE_DECLINAISON_TAILLE").putNulls("ID", "NOM");
        SQLTable tableArtElt = table.getTable("ARTICLE_ELEMENT");
        SQLRowValues artElt = new SQLRowValues(tableArtElt);
        artElt.put("ID", null);
        artElt.put("QTE", null);
        artElt.put("QTE_UNITAIRE", null);
        artElt.put("ID_ARTICLE_PARENT", (Object)graph);
        SQLRowValues putRowValues = artElt.putRowValues("ID_ARTICLE");
        putRowValues.putNulls("ID", "CODE", "NOM").putRowValues("ID_STOCK").putNulls("QTE_TH", "QTE_REEL", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE");
        putRowValues.putRowValues("ID_ARTICLE_DECLINAISON_TAILLE").putNulls("ID", "NOM");
        putRowValues.putRowValues("ID_ARTICLE_DECLINAISON_COULEUR").putNulls("ID", "NOM");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(graph);
        List<SQLRowValues> results = fetcher.fetch();
        for (SQLRowValues sqlRowValues : results) {
            SQLRowAccessor taille;
            Collection referentRows = sqlRowValues.getReferentRows(tableArtElt.getField("ID_ARTICLE_PARENT"));
            if (referentRows.size() != 0) continue;
            SQLRowAccessor couleur = sqlRowValues.getObject("ID_ARTICLE_DECLINAISON_COULEUR") == null ? null : sqlRowValues.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_COULEUR");
            SQLRowAccessor sQLRowAccessor = taille = sqlRowValues.getObject("ID_ARTICLE_DECLINAISON_TAILLE") == null ? null : sqlRowValues.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_TAILLE");
            if (couleur == null && taille == null) {
                this.mapArticle.put(sqlRowValues.getString("CODE"), sqlRowValues);
                continue;
            }
            if (couleur == null) {
                this.mapDeclArticle.put(Tuple3.create(sqlRowValues.getString("CODE"), null, taille.getString("NOM")), sqlRowValues);
                continue;
            }
            if (taille == null) {
                this.mapDeclArticle.put(Tuple3.create(sqlRowValues.getString("CODE"), couleur.getString("NOM"), null), sqlRowValues);
                continue;
            }
            this.mapDeclArticle.put(Tuple3.create(sqlRowValues.getString("CODE"), couleur.getString("NOM"), taille.getString("NOM")), sqlRowValues);
        }
    }

    private SQLRowAccessor findArticle(String code, String couleur, String taille) throws SQLException {
        SQLRowAccessor sqlRowAccessor;
        SQLRowValues rowVals;
        if (!this.mapCouleur.containsKey(couleur)) {
            rowVals = new SQLRowValues(this.root.getTable("ARTICLE_DECLINAISON_COULEUR"));
            rowVals.put("NOM", couleur);
            this.mapCouleur.put(couleur, rowVals.commit().getID());
        }
        if (!this.mapTaille.containsKey(taille)) {
            rowVals = new SQLRowValues(this.root.getTable("ARTICLE_DECLINAISON_TAILLE"));
            rowVals.put("NOM", taille);
            this.mapTaille.put(taille, rowVals.commit().getID());
        }
        if (!(couleur != null && couleur.trim().length() != 0 || taille != null && taille.trim().length() != 0)) {
            sqlRowAccessor = this.mapArticle.get(code);
        } else if (couleur == null || couleur.trim().length() == 0) {
            sqlRowAccessor = this.mapDeclArticle.get(Tuple3.create(code, null, taille.trim()));
            if (sqlRowAccessor == null) {
                sqlRowAccessor = this.cloneFromArticle(this.mapArticle.get(code), null, this.mapTaille.get(taille.trim()));
                this.mapDeclArticle.put(Tuple3.create(code, null, taille.trim()), sqlRowAccessor);
            }
        } else if (taille == null || taille.trim().length() == 0) {
            sqlRowAccessor = this.mapDeclArticle.get(Tuple3.create(code, couleur.trim(), null));
            if (sqlRowAccessor == null) {
                sqlRowAccessor = this.cloneFromArticle(this.mapArticle.get(code), this.mapCouleur.get(couleur.trim()), null);
                this.mapDeclArticle.put(Tuple3.create(code, couleur.trim(), null), sqlRowAccessor);
            }
        } else {
            sqlRowAccessor = this.mapDeclArticle.get(Tuple3.create(code, couleur.trim(), taille.trim()));
            if (sqlRowAccessor == null && this.mapArticle.get(code) != null) {
                sqlRowAccessor = this.cloneFromArticle(this.mapArticle.get(code), this.mapCouleur.get(couleur.trim()), this.mapTaille.get(taille.trim()));
                this.mapDeclArticle.put(Tuple3.create(code, couleur.trim(), taille.trim()), sqlRowAccessor);
            }
        }
        return sqlRowAccessor;
    }

    public SQLRow cloneFromArticle(SQLRowAccessor rArt, Integer idCouleur, Integer idTaille) throws SQLException {
        if (rArt == null) {
            return null;
        }
        SQLRowValues copy = this.artElt.createCopy(rArt.getID());
        if (idCouleur != null) {
            copy.put("ID_ARTICLE_DECLINAISON_COULEUR", idCouleur);
        }
        if (idTaille != null) {
            copy.put("ID_ARTICLE_DECLINAISON_TAILLE", idTaille);
        }
        return copy.commit();
    }

    private String getColumnName(int columnNumber) {
        int dividend = columnNumber;
        String columnName = "";
        while (dividend >= 0) {
            int modulo = dividend % 26;
            columnName = String.valueOf(String.valueOf((char)(65 + modulo))) + columnName;
            if ((dividend = (dividend - modulo) / 26) <= 0) break;
            --dividend;
        }
        return columnName;
    }
}

