/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class ComposedItemStockUpdater {
    private final List<StockItem> itemsUpdated;
    private final DBRoot root;

    public ComposedItemStockUpdater(DBRoot root, List<StockItem> itemsUpdated) {
        this.itemsUpdated = itemsUpdated;
        this.root = root;
    }

    public void update() throws SQLException {
        List<StockItem> items = this.getAllComposedItemToUpdate();
        this.updateNomenclature(items);
    }

    public void updateNomenclature(List<StockItem> items) throws SQLException {
        this.getAllChildren(items);
        ArrayList<StockItem> removedBadItem = new ArrayList<StockItem>();
        for (StockItem stockItem : items) {
            if (stockItem.updateQtyFromChildren()) continue;
            removedBadItem.add(stockItem);
        }
        items.removeAll(removedBadItem);
        SQLTable stockTable = this.root.getTable("STOCK");
        ArrayList<String> requests = new ArrayList<String>();
        for (StockItem stockItem : items) {
            if (stockItem.isStockInit()) {
                UpdateBuilder update = new UpdateBuilder(stockTable);
                update.setWhere(new Where((FieldRef)stockTable.getKey(), "=", stockItem.stock.getID()));
                update.setObject("QTE_REEL", (Object)stockItem.getRealQty());
                update.setObject("QTE_TH", (Object)stockItem.getVirtualQty());
                update.setObject("QTE_LIV_ATTENTE", (Object)stockItem.getDeliverQty());
                update.setObject("QTE_RECEPT_ATTENTE", (Object)stockItem.getReceiptQty());
                requests.add(update.asString());
                continue;
            }
            SQLRowValues rowVals = new SQLRowValues(stockTable);
            rowVals.put("QTE_REEL", stockItem.getRealQty());
            rowVals.put("QTE_TH", stockItem.getVirtualQty());
            rowVals.put("QTE_LIV_ATTENTE", stockItem.getDeliverQty());
            rowVals.put("QTE_RECEPT_ATTENTE", stockItem.getReceiptQty());
            rowVals.put("ID_ARTICLE", stockItem.getArticle().getID());
            rowVals.put("ID_DEPOT_STOCK", stockItem.stock.getForeignID("ID_DEPOT_STOCK"));
            rowVals.commit();
            if (stockItem.getArticle().getForeignID("ID_DEPOT_STOCK") != stockItem.stock.getForeignID("ID_DEPOT_STOCK")) continue;
            SQLRowValues rowValsArt = stockItem.getArticle().createEmptyUpdateRow();
            rowValsArt.put("ID_STOCK", (Object)rowVals);
            rowValsArt.commit();
        }
        ArrayList<Object> handlers = new ArrayList<Object>(requests.size());
        for (String s : requests) {
            handlers.add(null);
        }
        SQLUtils.executeMultiple(stockTable.getDBSystemRoot(), requests, handlers);
        stockTable.fire(new SQLTableEvent(stockTable, -1, SQLTableEvent.Mode.ROW_UPDATED));
    }

    private void getAllChildren(List<StockItem> items) {
        SQLTable tableArticle = this.root.getTable("ARTICLE");
        int undefDepot = tableArticle.getTable("DEPOT_STOCK").getUndefinedID();
        SQLRowValues rowValsArt = new SQLRowValues(tableArticle);
        rowValsArt.put(tableArticle.getKey().getName(), null);
        SQLRowValues rowValsStock = new SQLRowValues(this.root.getTable("STOCK"));
        rowValsStock.put("QTE_REEL", null);
        rowValsStock.put("QTE_TH", null);
        rowValsStock.put("QTE_RECEPT_ATTENTE", null);
        rowValsStock.put("QTE_LIV_ATTENTE", null);
        rowValsStock.put("ID_DEPOT_STOCK", null);
        rowValsStock.put("ID_ARTICLE", (Object)rowValsArt);
        final SQLTable tableArticleElt = this.root.getTable("ARTICLE_ELEMENT");
        SQLRowValues rowValsArtItem = new SQLRowValues(tableArticleElt);
        rowValsArtItem.put("ID_ARTICLE", (Object)rowValsArt);
        rowValsArtItem.put("QTE", null);
        rowValsArtItem.put("QTE_UNITAIRE", null);
        rowValsArtItem.put("ID_ARTICLE_PARENT", null);
        final ArrayList<Integer> ids = new ArrayList<Integer>();
        HashMap<Tuple2<Integer, Integer>, StockItem> mapItem = new HashMap<Tuple2<Integer, Integer>, StockItem>();
        for (StockItem stockItem : items) {
            int id = stockItem.getArticle().getID();
            ids.add(id);
            if (stockItem.stock.getForeignID("ID_DEPOT_STOCK") == undefDepot) continue;
            mapItem.put(Tuple2.create(id, stockItem.stock.getForeignID("ID_DEPOT_STOCK")), stockItem);
        }
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsArtItem);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where(tableArticleElt.getField("ID_ARTICLE_PARENT"), ids);
                input.setWhere(w);
                return input;
            }
        });
        List<SQLRowValues> values = fetcher.fetch();
        for (SQLRowValues sqlRowValues : values) {
            StockItem stockItem;
            SQLRowAccessor article = sqlRowValues.getForeign("ID_ARTICLE");
            SQLRowAccessor articleParent = sqlRowValues.getForeign("ID_ARTICLE_PARENT");
            if (article == null || article.isUndefined()) continue;
            Collection<? extends SQLRowAccessor> referentStockRows = article.getReferentRows(this.root.getTable("STOCK"));
            if (referentStockRows.size() == 0) {
                SQLRowValues sQLRowValues = new SQLRowValues(article.getTable().getTable("STOCK"));
                sQLRowValues.put("ID_ARTICLE", article.getID());
                sQLRowValues.put("ID_DEPOT_STOCK", DepotStockSQLElement.DEFAULT_ID);
                try {
                    SQLRow rowStock = sQLRowValues.commit();
                    article.createEmptyUpdateRow().put("ID_STOCK", rowStock.getID()).commit();
                    System.err.println("NO DEPOT STOCK FOR ITEM " + articleParent.getID() + " -- PARENT " + articleParent.getID());
                    stockItem = (StockItem)mapItem.get(Tuple2.create(articleParent.getID(), DepotStockSQLElement.DEFAULT_ID));
                    if (stockItem != null) {
                        stockItem.addItemComponent(new StockItemComponent(new StockItem(article, rowStock), sqlRowValues.getBigDecimal("QTE_UNITAIRE"), sqlRowValues.getInt("QTE")));
                    } else {
                        System.err.println("Unable to find stock of item ARTICLE " + articleParent.getID() + " DEPOT " + DepotStockSQLElement.DEFAULT_ID);
                    }
                }
                catch (SQLException e) {
                    ExceptionHandler.handle("Erreur lors de l'initialisation du stock de l'article", e);
                }
            }
            for (SQLRowAccessor sQLRowAccessor : referentStockRows) {
                stockItem = (StockItem)mapItem.get(Tuple2.create(articleParent.getID(), sQLRowAccessor.getForeignID("ID_DEPOT_STOCK")));
                if (stockItem != null) {
                    stockItem.addItemComponent(new StockItemComponent(new StockItem(article, sQLRowAccessor), sqlRowValues.getBigDecimal("QTE_UNITAIRE"), sqlRowValues.getInt("QTE")));
                    continue;
                }
                if (sQLRowAccessor.getForeignID("ID_DEPOT_STOCK") == sQLRowAccessor.getTable().getForeignTable("ID_DEPOT_STOCK").getUndefinedID()) {
                    stockItem = (StockItem)mapItem.get(Tuple2.create(articleParent.getID(), DepotStockSQLElement.DEFAULT_ID));
                    stockItem.addItemComponent(new StockItemComponent(new StockItem(article, sQLRowAccessor), sqlRowValues.getBigDecimal("QTE_UNITAIRE"), sqlRowValues.getInt("QTE")));
                    continue;
                }
                System.err.println("Unable to find stock of item ARTICLE " + articleParent.getID() + " DEPOT " + sQLRowAccessor.getForeignID("ID_DEPOT_STOCK"));
            }
        }
    }

    private List<StockItem> getAllComposedItemToUpdate() {
        HashSet<Integer> ids = new HashSet<Integer>(this.itemsUpdated.size());
        for (StockItem stockItem : this.itemsUpdated) {
            ids.add(stockItem.getArticle().getID());
        }
        List<SQLRowValues> list = this.getComposedItemToUpdate(ids);
        int size = list.size();
        HashMap<Integer, SQLRowValues> result = new HashMap<Integer, SQLRowValues>(ids.size());
        for (SQLRowValues sqlRowValues : list) {
            result.put(sqlRowValues.getID(), sqlRowValues);
        }
        while (size > 0) {
            List<SQLRowValues> l = this.getComposedItemToUpdate(ids);
            for (SQLRowValues sqlRowValues : l) {
                result.put(sqlRowValues.getID(), sqlRowValues);
            }
            size = l.size();
            if (size <= 0) continue;
            ids.clear();
            for (SQLRowValues r : l) {
                ids.add(r.getForeignID("ID_ARTICLE"));
            }
        }
        ArrayList<StockItem> items = new ArrayList<StockItem>(result.size());
        for (SQLRowValues rowVals : result.values()) {
            StockItem item = new StockItem(rowVals.getForeign("ID_ARTICLE"), rowVals);
            items.add(item);
        }
        return items;
    }

    private List<SQLRowValues> getComposedItemToUpdate(final Set<Integer> ids) {
        SQLTable tableArticle = this.root.getTable("ARTICLE");
        SQLRowValues rowValsArt = new SQLRowValues(tableArticle);
        rowValsArt.put(tableArticle.getKey().getName(), null);
        SQLRowValues rowValsStock = new SQLRowValues(this.root.getTable("STOCK"));
        rowValsStock.put("QTE_REEL", null);
        rowValsStock.put("QTE_TH", null);
        rowValsStock.put("QTE_RECEPT_ATTENTE", null);
        rowValsStock.put("QTE_LIV_ATTENTE", null);
        rowValsStock.put("ID_ARTICLE", (Object)rowValsArt);
        rowValsStock.put("ID_DEPOT_STOCK", null);
        final SQLTable tableArticleElt = this.root.getTable("ARTICLE_ELEMENT");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsStock);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                SQLSelectJoin joinFromField = input.addJoin("RIGHT", tableArticleElt, new Where((FieldRef)tableArticleElt.getField("ID_ARTICLE_PARENT"), "=", input.getTable("STOCK").getField("ID_ARTICLE")));
                Where w = new Where(joinFromField.getJoinedTable().getField("ID_ARTICLE"), ids);
                joinFromField.setWhere(w);
                input.clearOrder();
                input.setDistinct(true);
                return input;
            }
        });
        return fetcher.fetch();
    }
}

