/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import org.openconcerto.erp.core.supplychain.stock.element.StockTreeModel;
import org.openconcerto.sql.model.SQLRowValues;

class BatchNode {
    private final SQLRowValues sqlRowValues;
    private String str;

    public BatchNode(SQLRowValues sqlRowValues) {
        this.sqlRowValues = sqlRowValues;
        StringBuilder b = new StringBuilder();
        if (!sqlRowValues.getString("NUMERO_LOT").isEmpty()) {
            b.append(sqlRowValues.getString("NUMERO_LOT"));
        }
        if (!sqlRowValues.getString("NUMERO_SERIE").isEmpty()) {
            b.append(sqlRowValues.getString("NUMERO_SERIE"));
            b.append(" ");
        }
        if (sqlRowValues.getDate("DLC") != null) {
            b.append(" DLC: ");
            b.append(StockTreeModel.df.format(sqlRowValues.getDate("DLC").getTime()));
            b.append(" ");
        }
        if (sqlRowValues.getDate("DLUO") != null) {
            b.append(" DLUO: ");
            b.append(StockTreeModel.df.format(sqlRowValues.getDate("DLUO").getTime()));
            b.append(" ");
        }
        this.str = b.toString().trim();
    }

    public String toString() {
        return this.str;
    }

    public SQLRowValues getValues() {
        return this.sqlRowValues;
    }
}

