/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.receipt.ui;

import java.awt.Component;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import org.openconcerto.ui.EnhancedTable;
import org.openconcerto.ui.TextAreaTableCellEditor;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SerialAreaEditor
extends TextAreaTableCellEditor {
    private int row = 0;
    final int col = 0;

    public SerialAreaEditor(final EnhancedTable table) {
        super(table);
        this.getTextArea().getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                String t = SerialAreaEditor.this.getTextArea().getText();
                if (t.trim().length() > 0) {
                    List<String> fastSplitTrimmed = StringUtils.fastSplitTrimmed(t, '\n');
                    int qte = 0;
                    for (String string : fastSplitTrimmed) {
                        if (string.length() <= 0) continue;
                        ++qte;
                    }
                    if (qte == 0) {
                        qte = 1;
                    }
                    table.setValueAt(new BigDecimal(qte), SerialAreaEditor.this.row, 0);
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
        this.row = rowIndex;
        return super.getTableCellEditorComponent(table, value, isSelected, rowIndex, vColIndex);
    }
}

