/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.product.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.product.ui.FamilleArticlePanel;
import org.openconcerto.erp.panel.ITreeSelection;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.PanelFrame;

public class ListeDesArticlesFournisseurAction
extends CreateFrameAbstractAction {
    private PanelFrame panelFrame;
    String title = "Liste des articles fournisseurs";
    private final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE_FOURNISSEUR");
    private final SQLTable sqlTableFamilleArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("FAMILLE_ARTICLE_FOURNISSEUR");

    public ListeDesArticlesFournisseurAction() {
        this.putValue("Name", this.title);
    }

    public JFrame createFrame() {
        final FamilleArticlePanel panelFam = new FamilleArticlePanel(Configuration.getInstance().getDirectory().getElement("FAMILLE_ARTICLE_FOURNISSEUR"));
        SQLElement elt = Configuration.getInstance().getDirectory().getElement(this.sqlTableArticle);
        SQLTableModelSourceOnline createTableSource = elt.createTableSource(this.getWhere(panelFam));
        IListe liste = new IListe(createTableSource);
        final ListeAddPanel panel = new ListeAddPanel(elt, liste);
        JSplitPane pane = new JSplitPane(1, new JScrollPane(panelFam), panel);
        JPanel panelAll = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panelAll.add((Component)pane, c);
        ITreeSelection tree = panelFam.getFamilleTree();
        tree.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                panel.getListe().getRequest().setWhere(ListeDesArticlesFournisseurAction.this.getWhere(panelFam));
            }
        });
        panel.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ListeDesArticlesFournisseurAction.this.setTitle(panel);
            }
        });
        panel.getListe().addListenerOnModel(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().equals("loading") || evt.getPropertyName().equals("searching")) {
                    ListeDesArticlesFournisseurAction.this.setTitle(panel);
                }
            }
        });
        panelFam.getCheckObsolete().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.getListe().getRequest().setWhere(ListeDesArticlesFournisseurAction.this.getWhere(panelFam));
            }
        });
        this.panelFrame = new PanelFrame(panelAll, this.title);
        return this.panelFrame;
    }

    protected void setTitle(ListeAddPanel panel) {
        String title = this.title;
        if (panel.getListe().getModel().isLoading()) {
            title = String.valueOf(title) + ", chargement en cours";
        }
        if (panel.getListe().getModel().isSearching()) {
            title = String.valueOf(title) + ", recherche en cours";
        }
        this.panelFrame.setTitle(title);
    }

    public Where getWhere(FamilleArticlePanel panel) {
        int id = panel.getFamilleTree().getSelectedID();
        Where w = null;
        if (panel.getCheckObsolete().isSelected()) {
            w = new Where((FieldRef)this.sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        }
        if (id > 1) {
            SQLRow row = this.sqlTableFamilleArticle.getRow(id);
            Where w2 = new Where((FieldRef)this.sqlTableArticle.getField("ID_FAMILLE_ARTICLE_FOURNISSEUR"), "=", this.sqlTableFamilleArticle.getKey());
            String code = String.valueOf(row.getString("CODE")) + ".%";
            Where w3 = new Where((FieldRef)this.sqlTableFamilleArticle.getField("CODE"), "LIKE", (Object)code);
            w2 = w2.and(w3.or(new Where((FieldRef)this.sqlTableFamilleArticle.getKey(), "=", id)));
            w = w != null ? w.and(w2) : w2;
        }
        return w;
    }
}

