/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.ui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.utils.i18n.TranslationManager;

public enum EtatCommandeFournisseur {
    BROUILLON(1, "supplychain.order.state.waiting", Color.RED),
    EN_ATTENTE(2, "supplychain.order.state.running", Color.WHITE),
    EN_RECEPTION(3, "supplychain.order.state.toReceipt", Color.BLUE),
    RECEPTION_PARTIEL(4, "supplychain.supplychain.state.receipt.partial", Color.ORANGE),
    RECEPTIONNEE(5, "supplychain.order.state.receipt", Color.GREEN),
    LITIGE(6, "supplychain.order.state.block", Color.RED),
    ANNULEE(7, "supplychain.order.state.cancelled", Color.GRAY);

    private final int id;
    private final String translationID;
    private final Color color;
    private static final Map<Integer, EtatCommandeFournisseur> idToEnum;

    static {
        idToEnum = new HashMap<Integer, EtatCommandeFournisseur>();
        EtatCommandeFournisseur[] etatCommandeFournisseurArray = EtatCommandeFournisseur.values();
        int n = etatCommandeFournisseurArray.length;
        int n2 = 0;
        while (n2 < n) {
            EtatCommandeFournisseur e = etatCommandeFournisseurArray[n2];
            idToEnum.put(e.getId(), e);
            ++n2;
        }
    }

    private EtatCommandeFournisseur(int id, String translationID, Color color) {
        this.id = id;
        this.translationID = translationID;
        this.color = color;
    }

    public int getId() {
        return this.id;
    }

    public String getTranslationID() {
        return this.translationID;
    }

    public String getTranslation() {
        String translationForItem = TranslationManager.getInstance().getTranslationForItem(this.translationID);
        return translationForItem == null || translationForItem.trim().length() == 0 ? this.translationID : translationForItem;
    }

    public static EtatCommandeFournisseur fromID(int id) {
        return idToEnum.get(id);
    }

    public String toString() {
        return this.getTranslation();
    }

    public Color getColor() {
        return this.color;
    }
}

