/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.table;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import org.openconcerto.erp.core.sales.order.ui.TypeFactureCommandeCellRenderer;
import org.openconcerto.erp.core.sales.order.ui.TypeFactureCommandeTableCellEditor;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.PercentTableCellRenderer;
import org.openconcerto.ui.table.TimestampTableCellEditor;
import org.openconcerto.ui.table.XTableColumnModel;

public class FacturationCommandeTable
extends JPanel {
    private RowValuesTable table;
    private RowValuesTableModel model;
    private SQLComponent comp;
    public static Map<String, Boolean> map = new HashMap<String, Boolean>();

    protected Map<String, Boolean> getCustomVisibilityMap() {
        return map;
    }

    public FacturationCommandeTable(SQLComponent comp) {
        this.comp = comp;
        this.init();
        this.uiInit();
    }

    protected void init() {
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        SQLTableElement tableElementTF = new SQLTableElement(e.getTable().getField("TYPE_FACTURE"), Integer.class, new TypeFactureCommandeTableCellEditor());
        tableElementTF.setRenderer(new TypeFactureCommandeCellRenderer());
        list.add(tableElementTF);
        SQLTableElement pourcent = new SQLTableElement(e.getTable().getField("POURCENT"), BigDecimal.class);
        pourcent.setRenderer(new PercentTableCellRenderer());
        list.add(pourcent);
        SQLTableElement type = new SQLTableElement(e.getTable().getField("ID_TYPE_REGLEMENT"));
        list.add(type);
        SQLTableElement ajours = new SQLTableElement(e.getTable().getField("AJOURS"));
        list.add(ajours);
        SQLTableElement finM = new SQLTableElement(e.getTable().getField("FIN_MOIS"));
        list.add(finM);
        SQLTableElement comptant = new SQLTableElement(e.getTable().getField("COMPTANT"));
        list.add(comptant);
        SQLTableElement date = new SQLTableElement(e.getTable().getField("DATE_PREVISIONNELLE"), Date.class, new TimestampTableCellEditor(false){

            @Override
            public Object getCellEditorValue() {
                Object o = super.getCellEditorValue();
                Date d = null;
                if (o != null) {
                    d = new Date(((Timestamp)o).getTime());
                }
                return d;
            }
        });
        list.add(date);
        SQLRowValues defautRow = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"), false, defautRow);
        this.table = new RowValuesTable(this.model, null, true);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        Map<String, Boolean> mapCustom = this.getCustomVisibilityMap();
        if (mapCustom != null) {
            for (String string : mapCustom.keySet()) {
                this.setColumnVisible(this.model.getColumnForField(string), mapCustom.get(string));
            }
        }
    }

    protected void setColumnVisible(int col, boolean visible) {
        if (col >= 0) {
            XTableColumnModel columnModel = this.table.getColumnModel();
            columnModel.setColumnVisible(columnModel.getColumnByModelIndex(col), visible);
        }
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        this.add((Component)new JLabel("Ajouter un terme"), c);
        final ElementComboBox boxCat = new ElementComboBox();
        SQLElement element = this.getSQLElement();
        ComboSQLRequest req = element.getComboRequest(true);
        req.setWhere(new Where((FieldRef)element.getTable().getField("CHOICE"), "=", (Object)Boolean.TRUE));
        boxCat.init(element, req);
        ++c.gridx;
        this.add((Component)boxCat, c);
        c.fill = 0;
        ++c.gridx;
        JButton buttonAjouter = new JButton("Ajouter");
        buttonAjouter.setOpaque(false);
        this.add((Component)buttonAjouter, c);
        c.gridwidth = 0;
        buttonAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow rowCat = boxCat.getSelectedRow();
                if (rowCat == null || rowCat.isUndefined()) {
                    return;
                }
                SQLTable table2 = FacturationCommandeTable.this.getSQLElement().getTable();
                SQLRowValues rowVals = new SQLRowValues(table2);
                if (table2.getName().equals("FACTURATION_COMMANDE_CLIENT") && FacturationCommandeTable.this.comp != null && FacturationCommandeTable.this.comp.getSelectedID() > 1) {
                    rowVals.put("ID_COMMANDE_CLIENT", FacturationCommandeTable.this.comp.getSelectedID());
                }
                rowVals.put("NOM", rowCat.getObject("NOM"));
                rowVals.put("ID_TYPE_REGLEMENT", rowCat.getObject("ID_TYPE_REGLEMENT"));
                rowVals.put("AJOURS", rowCat.getObject("AJOURS"));
                rowVals.put("COMPTANT", rowCat.getObject("COMPTANT"));
                rowVals.put("FIN_MOIS", rowCat.getObject("FIN_MOIS"));
                rowVals.put("MONTANT", rowCat.getObject("MONTANT"));
                rowVals.put("POURCENT", rowCat.getObject("POURCENT"));
                rowVals.put("TYPE_FACTURE", rowCat.getObject("TYPE_FACTURE"));
                FacturationCommandeTable.this.getModel().addRow(rowVals);
            }
        });
        ++c.gridy;
        c.gridx = 0;
        RowValuesTableControlPanel control = new RowValuesTableControlPanel(this.table);
        control.setOpaque(false);
        this.add((Component)control, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        JScrollPane comp = new JScrollPane(this.table);
        comp.setVerticalScrollBarPolicy(22);
        this.add((Component)comp, c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
    }

    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("FACTURATION_COMMANDE_CLIENT");
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public RowValuesTable getRowValuesTable() {
        return this.table;
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public void refreshTable() {
        this.table.repaint();
    }
}

