/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.element;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.FrameUtil;

public class CommandeElementSQLElement
extends ComptaSQLConfElement {
    public CommandeElementSQLElement() {
        super("COMMANDE_ELEMENT", "un element de commande", "\u00e9l\u00e9ments de commande");
        RowAction.PredicateRowAction rowActionCmd = new RowAction.PredicateRowAction(new AbstractAction("Modifier la commande associ\u00e9e"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues selectedRow = IListe.get(e).getSelectedRow();
                EditFrame f = new EditFrame(CommandeElementSQLElement.this.getForeignElement("ID_COMMANDE"), EditPanel.EditMode.MODIFICATION);
                f.getSQLComponent().select(selectedRow.getForeignID("ID_COMMANDE"));
                FrameUtil.showPacked(f);
            }
        }, true);
        rowActionCmd.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(rowActionCmd);
        if (this.getTable().getForeignTable("ID_USER_COMMON_CREATE").getRow(UserManager.getUserID()).getBoolean("ADMIN").booleanValue()) {
            RowAction.PredicateRowAction rowActionA = new RowAction.PredicateRowAction(new AbstractAction("Forcer la r\u00e9ception"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommandeElementSQLElement.this.updateForceLivrer(e, Boolean.TRUE);
                }
            }, true);
            rowActionA.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
            this.getRowActions().add(rowActionA);
            RowAction.PredicateRowAction rowActionC = new RowAction.PredicateRowAction(new AbstractAction("Annuler forcer la r\u00e9ception"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommandeElementSQLElement.this.updateForceLivrer(e, Boolean.FALSE);
                }
            }, true);
            rowActionC.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
            this.getRowActions().add(rowActionC);
        }
    }

    private void updateForceLivrer(ActionEvent e, Boolean state) {
        List<SQLRowValues> selectedRows = IListe.get(e).getSelectedRows();
        HashSet<Integer> ids = new HashSet<Integer>();
        for (SQLRowValues sqlRowValues : selectedRows) {
            ids.add(sqlRowValues.getID());
        }
        UpdateBuilder build = new UpdateBuilder(this.getTable());
        build.setObject("RECU_FORCED", (Object)state);
        build.setWhere(new Where(this.getTable().getKey(), ids));
        this.getTable().getDBSystemRoot().getDataSource().execute(build.asString());
        IListe.get(e).getModel().updateAll();
    }

    @Override
    protected String getParentFFName() {
        return "ID_COMMANDE";
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_STYLE");
        l.add("CODE");
        l.add("NOM");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false)) {
            for (String fieldName : this.getTable().getFieldsName()) {
                if (!fieldName.startsWith("ID_ARTICLE_DECLINAISON_")) continue;
                l.add(fieldName);
            }
        }
        l.add("ID_COMMANDE");
        l.add("ID_ARTICLE");
        l.add("PA_HT");
        l.add("PV_HT");
        l.add("T_PA_HT");
        l.add("T_PV_HT");
        l.add("ID_TAXE");
        l.add("QTE");
        l.add("QTE_UNITAIRE");
        l.add("QTE_RECUE");
        l.add("POIDS");
        l.add("RECU_FORCED");
        l.add("RECU");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("PA_HT");
        l.add("PV_HT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new UISQLComponent(this){

            @Override
            public void addViews() {
                this.addRequiredSQLObject(new JTextField(), "NOM", "left");
                this.addRequiredSQLObject(new JTextField(), "CODE", "right");
                this.addSQLObject(new ElementComboBox(), "ID_STYLE", "left");
                this.addRequiredSQLObject(new DeviseField(), "PA_HT", "left");
                this.addSQLObject(new DeviseField(), "PV_HT", "right");
                this.addSQLObject(new JTextField(), "POIDS", "left");
                this.addSQLObject(new ElementComboBox(), "ID_TAXE", "right");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".item";
    }
}

