/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.shipment.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureItemSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.utils.ListMap;

public class BonDeLivraisonItemSQLElement
extends ComptaSQLConfElement {
    public BonDeLivraisonItemSQLElement() {
        super("BON_DE_LIVRAISON_ELEMENT", "un element de bon de livraison", "\u00e9l\u00e9ments de bon de livraison");
    }

    @Override
    protected void ffInited() {
        super.ffInited();
        this.setAction("ID_COMMANDE_CLIENT_ELEMENT", SQLElement.ReferenceAction.RESTRICT);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_BON_DE_LIVRAISON");
        l.add("CODE");
        l.add("NOM");
        l.add("PA_HT");
        l.add("PV_HT");
        l.add("QTE");
        l.add("QTE_LIVREE");
        l.add("QTE_A_LIVRER");
        l.add("ID_TAXE");
        l.add("POIDS");
        l.add("T_PA_HT");
        l.add("T_PV_HT");
        l.add("T_PV_TTC");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("PV_HT");
        l.add("QTE");
        return l;
    }

    @Override
    protected String getParentFFName() {
        return "ID_BON_DE_LIVRAISON";
    }

    @Override
    public ListMap<String, String> getShowAs() {
        ListMap<String, String> res = new ListMap<String, String>();
        res.putCollection("ID_BON_DE_LIVRAISON", "NUMERO", "DATE");
        return res;
    }

    @Override
    public SQLComponent createComponent() {
        return new UISQLComponent(this){

            @Override
            public void addViews() {
                this.addRequiredSQLObject(new JTextField(), "NOM", "left");
                this.addRequiredSQLObject(new JTextField(), "CODE", "right");
                this.addSQLObject(new ElementComboBox(), "ID_BON_DE_LIVRAISON", "left");
                this.addRequiredSQLObject(new DeviseField(), "PV_HT", "left");
                this.addSQLObject(new JTextField(), "QTE", "right");
                this.addSQLObject(new JTextField(), "POIDS", "left");
                this.addSQLObject(new ElementComboBox(), "ID_TAXE", "right");
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                SQLRow rowBon = this.getTable().getRow(id);
                SQLRow rowFact = this.getTable().getBase().getTable("BON_DE_LIVRAISON_ELEMENT").getRow(rowBon.getInt("ID_BON_DE_LIVRAISON_ELEMENT"));
                int qteLivree = rowFact.getInt("QTE_LIVREE") + rowFact.getInt("QTE_LIVREE");
                SQLRowValues rowVals = new SQLRowValues(this.getDirectory().getElement(SaisieVenteFactureItemSQLElement.class).getTable());
                rowVals.put("QTE_LIVREE", new Integer(qteLivree));
                try {
                    rowVals.update(rowFact.getID());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return id;
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".item";
    }
}

