/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.element;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.DOMBuilder;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.quote.component.DevisSQLComponent;
import org.openconcerto.erp.core.sales.quote.element.DevisItemSQLElement;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.core.sales.quote.ui.QuoteEditGroup;
import org.openconcerto.erp.core.sales.shipment.component.BonDeLivraisonSQLComponent;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.ui.light.CustomRowEditor;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.light.ActivationOnSelectionControler;
import org.openconcerto.ui.light.ColumnSpec;
import org.openconcerto.ui.light.ColumnsSpec;
import org.openconcerto.ui.light.LightController;
import org.openconcerto.ui.light.LightUIButtonUnmanaged;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.ui.light.LightUITable;
import org.openconcerto.ui.light.LightUITextField;
import org.openconcerto.ui.light.Row;
import org.openconcerto.ui.light.RowSelectionSpec;
import org.openconcerto.ui.light.TableContent;
import org.openconcerto.ui.light.TableSpec;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.ui.StringWithId;

public class DevisSQLElement
extends ComptaSQLConfElement {
    public static final String TABLENAME = "DEVIS";
    public static final String FACTURE_TAG_RIGHT = "TAG_FACTURE_DEVIS";
    private final Set<String> requiredNames = new HashSet<String>();

    public DevisSQLElement() {
        super(TABLENAME);
        this.getRowActions().addAll(this.getDevisRowActions());
        QuoteEditGroup group = new QuoteEditGroup();
        GlobalMapper.getInstance().map("sales.quote", group);
        this.setDefaultGroup(group);
    }

    public Set<String> getRequiredNames() {
        return this.requiredNames;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("T_ACOMPTE");
        s.add("MONTANT_INTERFEL_HT");
        return s;
    }

    private List<RowAction> getDevisRowActions() {
        RowAction.PredicateRowAction actionClient;
        ArrayList<RowAction> rowsActions = new ArrayList<RowAction>();
        RowAction factureAction = this.getDevis2FactureAction();
        rowsActions.add(factureAction);
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.ACOMPTE_DEVIS, false)) {
            actionClient = new RowAction.PredicateRowAction(new AbstractAction("Saisir un acompte"){
                EditFrame edit;

                @Override
                public void actionPerformed(ActionEvent e) {
                    final SQLElement eltEncaisser = Configuration.getInstance().getDirectory().getElement(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ENCAISSER_MONTANT"));
                    if (this.edit == null) {
                        this.edit = new EditFrame(eltEncaisser, EditPanel.EditMode.CREATION);
                    }
                    final SQLRowValues selRow = IListe.get(e).getSelectedRow();
                    SQLRowValues rowVals = new SQLRowValues(eltEncaisser.getTable());
                    rowVals.put("ACOMPTE", true);
                    rowVals.put("NOM", "Acompte devis " + selRow.getString("NUMERO"));
                    rowVals.put("ID_CLIENT", selRow.getForeignID("ID_CLIENT"));
                    rowVals.put("ID_DEVIS", ((SQLRowAccessor)selRow).getID());
                    SQLRowValues rowValsElt = new SQLRowValues(eltEncaisser.getTable().getTable("ENCAISSER_MONTANT_ELEMENT"));
                    rowValsElt.put("MONTANT_A_REGLER", selRow.getLong("T_TTC"));
                    rowValsElt.put("DATE", ((SQLRowAccessor)selRow).getObject("DATE"));
                    rowValsElt.put("ID_ENCAISSER_MONTANT", (Object)rowVals);
                    this.edit.getSQLComponent().select(rowVals);
                    this.edit.setVisible(true);
                    this.edit.addEditPanelListener(new EditPanelListener(){

                        @Override
                        public void modified() {
                        }

                        @Override
                        public void inserted(int id) {
                            SQLRow rowE = eltEncaisser.getTable().getRow(id);
                            String up = "UPDATE " + selRow.getTable().getSQLName().quote() + " set \"T_ACOMPTE\"=(SELECT COALESCE(SUM(\"MONTANT\"),0) from " + rowE.getTable().getSQLName().quote() + " where \"ARCHIVE\"=0 and \"ID_DEVIS\"=" + selRow.getID() + ") where \"ID_DEVIS\"=" + selRow.getID();
                            eltEncaisser.getTable().getDBSystemRoot().getDataSource().execute(up);
                        }

                        @Override
                        public void deleted() {
                        }

                        @Override
                        public void cancelled() {
                        }
                    });
                }
            }, false);
            actionClient.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
            rowsActions.add(actionClient);
        }
        actionClient = new RowAction.PredicateRowAction(new AbstractAction("D\u00e9tails client"){
            EditFrame edit;
            private SQLElement eltClient;
            {
                this.eltClient = Configuration.getInstance().getDirectory().getElement(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.edit == null) {
                    this.edit = new EditFrame(this.eltClient, EditPanel.EditMode.MODIFICATION);
                }
                this.edit.selectionId(IListe.get(e).getSelectedRow().getForeignID("ID_CLIENT"));
                this.edit.setVisible(true);
            }
        }, false);
        actionClient.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        rowsActions.add(actionClient);
        RowAction actionTransfertCmd = this.getDevis2CmdFournAction();
        rowsActions.add(actionTransfertCmd);
        RowAction commandeAction = this.getDevis2CmdCliAction();
        rowsActions.add(commandeAction);
        RowAction blAction = this.getDevis2BlAction();
        rowsActions.add(blAction);
        RowAction accepteEtCmdAction = this.getAcceptAndCmdClientAction();
        rowsActions.add(accepteEtCmdAction);
        RowAction accepteAction = this.getAcceptAction();
        rowsActions.add(accepteAction);
        RowAction refuseAction = this.getRefuseAction();
        rowsActions.add(refuseAction);
        RowAction cloneAction = this.getCloneAction();
        rowsActions.add(cloneAction);
        MouseSheetXmlListeListener mouseSheetXmlListeListener = new MouseSheetXmlListeListener((SQLElement)this, DevisXmlSheet.class);
        mouseSheetXmlListeListener.setGenerateHeader(true);
        mouseSheetXmlListeListener.setShowHeader(true);
        rowsActions.addAll(mouseSheetXmlListeListener.getRowActions());
        return rowsActions;
    }

    public RowAction getDevis2BlAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLRowValues> copySelectedRows = IListe.get(e).getSelectedRows();
                DevisSQLElement.this.transfertDevis(copySelectedRows, "BON_DE_LIVRAISON");
            }
        }, true, "sales.quote.create.customer.delivery"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getForeignID("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public static void davBrowse(String s) throws Exception {
        boolean windows = System.getProperty("os.name").startsWith("Windows");
        if (windows) {
            Desktop.getDesktop().browse(new URI(s));
        } else {
            String[] cmdarray = new String[]{"xdg-open", s};
            int res = Runtime.getRuntime().exec(cmdarray).waitFor();
            if (res != 0) {
                throw new IOException("error (" + res + ") executing " + Arrays.asList(cmdarray));
            }
        }
    }

    public RowAction getCloneAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues selectedRow = IListe.get(e).getSelectedRow();
                SQLElement eltFact = Configuration.getInstance().getDirectory().getElement(DevisSQLElement.TABLENAME);
                EditFrame editFrame = new EditFrame(eltFact, EditPanel.CREATION);
                ((DevisSQLComponent)editFrame.getSQLComponent()).loadDevisExistant(((SQLRowAccessor)selectedRow).getID());
                editFrame.setVisible(true);
            }
        }, true, "sales.quote.clone"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1;
            }
        };
    }

    public RowAction getRefuseAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues rowVals = IListe.get(e).getSelectedRow().asRow().createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 3);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }, false, "sales.quote.refuse"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getForeignID("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    public RowAction getAcceptAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get(e).getSelectedRow().asRow();
                SQLRowValues rowVals = selectedRow.createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 4);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }, false, "sales.quote.accept"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                int int1;
                return selection != null && selection.size() == 1 && (int1 = selection.get(0).getForeignID("ID_ETAT_DEVIS")) != 3 && int1 != 4;
            }
        };
    }

    public RowAction getDevis2FactureAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransfertBaseSQLComponent.openTransfertFrame(IListe.get(e).getSelectedRows(), "SAISIE_VENTE_FACTURE");
            }
        }, true, "sales.quote.create.invoice"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                boolean b = selection.size() > 0;
                for (SQLRowAccessor sQLRowAccessor : selection) {
                    b &= sQLRowAccessor.getForeignID("ID_ETAT_DEVIS") == 4;
                }
                return b;
            }
        };
    }

    public RowAction getDevis2CmdFournAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SQLRow selectedRow = IListe.get(e).fetchSelectedRow();
                ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        DevisSQLElement.this.transfertCommande(selectedRow);
                    }
                });
            }
        }, false, "sales.quote.create.supplier.order"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getForeignID("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public RowAction getDevis2CmdCliAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLRowValues> copySelectedRows = IListe.get(e).getSelectedRows();
                DevisSQLElement.this.transfertCommandeClient(copySelectedRows);
            }
        }, true, "sales.quote.create.customer.order"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getForeignID("ID_ETAT_DEVIS") == 4;
            }
        };
    }

    public RowAction getAcceptAndCmdClientAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow selectedRow = IListe.get(e).fetchSelectedRow();
                SQLRowValues rowVals = selectedRow.createEmptyUpdateRow();
                rowVals.put("ID_ETAT_DEVIS", 4);
                try {
                    rowVals.update();
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("Erreur la de la mise \u00e0 jour de l'\u00e9tat du devis!", e1);
                }
                DevisSQLElement.this.transfertCommandeClient(IListe.get(e).getSelectedRows());
            }
        }, false, "sales.quote.accept.create.customer.order"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1 && selection.get(0).getForeignID("ID_ETAT_DEVIS") == 2;
            }
        };
    }

    public void transfertDevis(final List<SQLRowValues> copySelectedRows, final String destTable) {
        SwingWorker<Boolean, Object> worker = new SwingWorker<Boolean, Object>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                final SQLTable tableTransfert = DevisSQLElement.this.getTable().getTable("TR_DEVIS");
                SQLRowValues rowVals = new SQLRowValues(tableTransfert);
                rowVals.put("ID_DEVIS", (Object)new SQLRowValues(DevisSQLElement.this.getTable()).put("NUMERO", null));
                rowVals.put("ID_" + destTable, null);
                rowVals.put("ID", null);
                final ArrayList<Integer> lID = new ArrayList<Integer>();
                for (SQLRowValues sqlRowValues : copySelectedRows) {
                    lID.add(sqlRowValues.getID());
                }
                SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(rowVals);
                fetch.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        Where w = new Where(tableTransfert.getField("ID_DEVIS"), lID);
                        w = w.and(new Where((FieldRef)tableTransfert.getField("ID_" + destTable), "IS NOT", (Object)null));
                        input.setWhere(w);
                        return input;
                    }
                });
                List<SQLRowValues> rows = fetch.fetch();
                if (rows != null && rows.size() > 0) {
                    String numero = "";
                    for (SQLRowValues sqlRow : rows) {
                        numero = String.valueOf(numero) + sqlRow.getForeign("ID_DEVIS").getString("NUMERO") + " ,";
                    }
                    numero = numero.substring(0, numero.length() - 2);
                    String label = "Attention ";
                    label = rows.size() > 1 ? String.valueOf(label) + " les devis " + numero + " ont d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9!" : String.valueOf(label) + " le devis " + numero + " a d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9!";
                    int ans = JOptionPane.showConfirmDialog(null, label = String.valueOf(label) + "\n Voulez vous continuer?", "Transfert devis", 0);
                    if (ans == 1) {
                        return Boolean.FALSE;
                    }
                }
                return Boolean.TRUE;
            }

            @Override
            protected void done() {
                try {
                    Boolean b = (Boolean)this.get();
                    if (b != null && b.booleanValue()) {
                        EditFrame frame = TransfertBaseSQLComponent.openTransfertFrame(copySelectedRows, destTable);
                        if (destTable.equalsIgnoreCase("BON_DE_LIVRAISON")) {
                            BonDeLivraisonSQLComponent comp = (BonDeLivraisonSQLComponent)frame.getSQLComponent();
                            final SQLTable tableElt = comp.getElement().getTable().getTable("BON_DE_LIVRAISON_ELEMENT");
                            SQLRowValues rowVals = new SQLRowValues(tableElt);
                            rowVals.put("QTE_UNITAIRE", null);
                            rowVals.put("QTE", null);
                            rowVals.put("QTE_LIVREE", null);
                            rowVals.put("ID_ARTICLE", null);
                            rowVals.put("PV_HT", null);
                            rowVals.put("ID_DEVIS_ELEMENT", null);
                            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
                            fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                                @Override
                                public SQLSelect transformChecked(SQLSelect input) {
                                    ArrayList<Integer> ids = new ArrayList<Integer>(copySelectedRows.size());
                                    for (SQLRowValues sqlRowValues : copySelectedRows) {
                                        ids.add(sqlRowValues.getID());
                                    }
                                    SQLSelectJoin joinBR = input.addJoin("RIGHT", tableElt.getTable("BON_DE_LIVRAISON_ELEMENT").getField("ID_BON_DE_LIVRAISON"));
                                    SQLSelectJoin joinTR = input.addBackwardJoin("RIGHT", tableElt.getTable("TR_DEVIS").getField("ID_BON_DE_LIVRAISON"), joinBR.getJoinedTable().getAlias());
                                    joinTR.setWhere(new Where(joinTR.getJoinedTable().getField("ID_DEVIS"), ids));
                                    System.err.println(input.asString());
                                    return input;
                                }
                            });
                            comp.loadQuantity(fetcher.fetch(), "DEVIS_ELEMENT");
                        }
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Erreur lors du transfert des devis!", e);
                }
                super.done();
            }
        };
        worker.execute();
    }

    public void transfertCommandeClient(List<SQLRowValues> copySelectedRows) {
        this.transfertDevis(copySelectedRows, "COMMANDE_CLIENT");
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>(1);
        l.add("NUMERO");
        return l;
    }

    private void transfertCommande(final SQLRow row) {
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                DevisItemSQLElement elt = (DevisItemSQLElement)Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
                SQLTable tableCmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT").getTable();
                SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
                Collection rows = row.getReferentRows(elt.getTable());
                ListMap<SQLRow, SQLRowValues> map = new ListMap<SQLRow, SQLRowValues>();
                SQLRow rowDeviseF = null;
                for (SQLRow sqlRow : rows) {
                    SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
                    for (SQLField field : eltArticle.getTable().getFields()) {
                        if (!sqlRow.getTable().getFieldsName().contains(field.getName())) continue;
                        rowArticle.put(field.getName(), sqlRow.getObject(field.getName()));
                    }
                    int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
                    SQLRow rowArticleFind = eltArticle.getTable().getRow(idArticle);
                    if (rowArticleFind == null) continue;
                    SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
                    SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticleFind));
                    rowValsElt.put("ID_STYLE", sqlRow.getObject("ID_STYLE"));
                    rowValsElt.put("QTE", sqlRow.getObject("QTE"));
                    rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
                    rowValsElt.put("T_PA_HT", ((BigDecimal)rowValsElt.getObject("PA_HT")).multiply(new BigDecimal(rowValsElt.getInt("QTE"), DecimalUtils.HIGH_PRECISION)));
                    rowValsElt.put("T_PA_TTC", ((BigDecimal)rowValsElt.getObject("T_PA_HT")).multiply(BigDecimal.valueOf((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0), DecimalUtils.HIGH_PRECISION));
                    rowDeviseF = sqlRow.getForeignRow("ID_DEVISE");
                    SQLRow rowDeviseHA = rowArticleFind.getForeignRow("ID_DEVISE_HA");
                    BigDecimal qte = new BigDecimal(rowValsElt.getInt("QTE"));
                    if (rowDeviseF != null && !rowDeviseF.isUndefined()) {
                        if (rowDeviseF.getID() == rowDeviseHA.getID()) {
                            rowValsElt.put("PA_DEVISE", rowArticleFind.getObject("PA_DEVISE"));
                            rowValsElt.put("PA_DEVISE_T", ((BigDecimal)rowArticleFind.getObject("PA_DEVISE")).multiply(qte, DecimalUtils.HIGH_PRECISION));
                            rowValsElt.put("ID_DEVISE", rowDeviseF.getID());
                        } else {
                            BigDecimal taux = (BigDecimal)rowDeviseF.getObject("TAUX");
                            rowValsElt.put("PA_DEVISE", taux.multiply((BigDecimal)rowValsElt.getObject("PA_HT")));
                            rowValsElt.put("PA_DEVISE_T", ((BigDecimal)rowValsElt.getObject("PA_DEVISE")).multiply(qte, DecimalUtils.HIGH_PRECISION));
                            rowValsElt.put("ID_DEVISE", rowDeviseF.getID());
                        }
                    }
                    map.add(rowArticleFind.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
                }
                MouvementStockSQLElement.createCommandeF(map, rowDeviseF);
            }
        });
    }

    @Override
    protected List<String> getListFields() {
        SQLPreferences prefs;
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("OBJET");
        l.add("ID_COMMERCIAL");
        if (UserRightsManager.getCurrentUserRights().haveRight("CORPS_VOIR_PRIX_ACHAT")) {
            l.add("T_HA");
        }
        l.add("T_HT");
        l.add("T_TTC");
        if (this.getTable().contains("TRANSFORMATION")) {
            l.add("TRANSFORMATION");
        }
        if ((prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot())).getBoolean(GestionCommercialeGlobalPreferencePanel.ACOMPTE_DEVIS, false)) {
            l.add("T_ACOMPTE");
        }
        l.add("INFOS");
        if (this.getTable().contains("DUNNING_DATE")) {
            l.add("DUNNING_DATE");
        }
        return l;
    }

    @Override
    protected synchronized void _initTableSource(SQLTableModelSource table) {
        super._initTableSource(table);
        this.addCommercialFilter(table, this.getTable().getField("ID_COMMERCIAL"));
        BaseSQLTableModelColumn colAdrLiv = new BaseSQLTableModelColumn("Adresse de livraison", String.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor rowAd = null;
                if (!r.isForeignEmpty("ID_ADRESSE_LIVRAISON")) {
                    rowAd = r.getForeign("ID_ADRESSE_LIVRAISON");
                } else if (!r.isForeignEmpty("ID_CLIENT")) {
                    rowAd = r.getForeign("ID_CLIENT").getObject("ID_ADRESSE_L") != null && !r.getForeign("ID_CLIENT").isForeignEmpty("ID_ADRESSE_L") ? r.getForeign("ID_CLIENT").getForeign("ID_ADRESSE_L") : r.getForeign("ID_CLIENT").getForeign("ID_ADRESSE");
                }
                String lib = rowAd == null ? "" : String.valueOf(rowAd.getString("LIBELLE")) + " " + rowAd.getString("VILLE");
                return lib;
            }

            @Override
            public Set<FieldPath> getPaths() {
                SQLTable devisTable = DevisSQLElement.this.getTable();
                Path p = new Path(devisTable);
                p = (Path)p.add(devisTable.getField("ID_CLIENT"));
                p = (Path)p.add(p.getLast().getField("ID_ADRESSE_L"));
                Path p2 = new Path(devisTable);
                p2 = (Path)p2.add(devisTable.getField("ID_CLIENT"));
                p2 = (Path)p2.add(p2.getLast().getField("ID_ADRESSE"));
                Path p3 = new Path(devisTable);
                p3 = (Path)p3.add(devisTable.getField("ID_ADRESSE_LIVRAISON"));
                return CollectionUtils.createSet(new FieldPath(p, "LIBELLE"), new FieldPath(p, "VILLE"), new FieldPath(p2, "LIBELLE"), new FieldPath(p2, "VILLE"), new FieldPath(p3, "LIBELLE"), new FieldPath(p3, "VILLE"));
            }
        };
        table.getColumns().add(3, colAdrLiv);
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, "NUMERO");
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addToGraphToFetch("ID_ETAT_DEVIS");
    }

    @Override
    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        if (this.getTable().contains("ID_ADRESSE")) {
            links.get("ID_ADRESSE").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
        if (this.getTable().contains("ID_ADRESSE_LIVRAISON")) {
            links.get("ID_ADRESSE_LIVRAISON").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
    }

    @Override
    public SQLComponent createComponent() {
        return new DevisSQLComponent(this);
    }

    public void transfertFacture(int devisID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SaisieVenteFactureSQLComponent comp = (SaisieVenteFactureSQLComponent)editFactureFrame.getSQLComponent();
        comp.setDefaults();
        comp.loadDevis(devisID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
    }

    @Override
    public List<CustomRowEditor> getCustomRowEditors(final Configuration configuration, String sessionToken) {
        List<CustomRowEditor> map = super.getCustomRowEditors(configuration, sessionToken);
        map.add(new CustomRowEditor("sales.quote.items.list"){

            @Override
            public LightUIElement createUIElement() {
                ColumnSpec c1 = new ColumnSpec("sales.quote.item.style", StringWithId.class, "Style", new StringWithId(2L, "Normal"), true, new LightUIComboBox("sales.quote.item.style"));
                ColumnSpec c2 = new ColumnSpec("sales.quote.item.code", String.class, "Code", "", true, new LightUITextField("sales.quote.item.code"));
                ColumnSpec c3 = new ColumnSpec("sales.quote.item.label", String.class, "Nom", "", true, new LightUITextField("sales.quote.item.name"));
                ColumnSpec c4 = new ColumnSpec("sales.quote.item.description", String.class, "Descriptif", "", true, new LightUITextField("sales.quote.item.description"));
                ColumnSpec c5 = new ColumnSpec("sales.quote.item.purchase.unit.price", BigDecimal.class, "P.U. Achat HT", new BigDecimal(0), true, new LightUITextField("sales.quote.item.purchase.unit.price"));
                ColumnSpec c6 = new ColumnSpec("sales.quote.item.sales.unit.price", BigDecimal.class, "P.U. Vente HT", new BigDecimal(0), true, new LightUITextField("sales.quote.item.sales.unit.price"));
                ColumnSpec c7 = new ColumnSpec("sales.quote.item.quantity", Integer.class, "Quantit\u00e9", new BigDecimal(1), true, new LightUITextField("sales.quote.item.quantity"));
                ArrayList<ColumnSpec> columnsSpec = new ArrayList<ColumnSpec>(7);
                columnsSpec.add(c1);
                columnsSpec.add(c2);
                columnsSpec.add(c3);
                columnsSpec.add(c4);
                columnsSpec.add(c5);
                columnsSpec.add(c6);
                columnsSpec.add(c7);
                ArrayList<String> possibleColumnIds = new ArrayList<String>(columnsSpec.size());
                for (ColumnSpec c : columnsSpec) {
                    possibleColumnIds.add(c.getId());
                }
                String lId = "sales.quote.items";
                long userId = UserManager.getUserID();
                Document columnsPrefs = null;
                try {
                    DOMBuilder in = new DOMBuilder();
                    org.w3c.dom.Document w3cDoc = Configuration.getInstance().getXMLConf(userId, "sales.quote.items");
                    if (w3cDoc != null) {
                        columnsPrefs = in.build(w3cDoc);
                    }
                    if (columnsPrefs == null) {
                        throw new IllegalStateException("Columns Prefs is null");
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("DevisSQLElement getItemsCustomEditorProvider - Failed to get ColumnPrefs for descriptor sales.quote.items and for user " + userId + "\n" + ex.getMessage());
                }
                Element rootElement = columnsPrefs.getRootElement();
                if (!rootElement.getName().equals("list")) {
                    throw new IllegalArgumentException("invalid xml, roots node list expected but " + rootElement.getName() + " found");
                }
                List<Element> xmlColumns = rootElement.getChildren();
                int columnsCount = columnsSpec.size();
                if (xmlColumns.size() != columnsCount) {
                    throw new IllegalArgumentException("incorrect columns count in xml");
                }
                int i = 0;
                while (i < columnsCount) {
                    ColumnSpec columnSpec = (ColumnSpec)columnsSpec.get(i);
                    String columnId = columnSpec.getId();
                    boolean find = false;
                    int j = 0;
                    while (j < columnsCount) {
                        Element xmlColumn = xmlColumns.get(j);
                        String xmlColumnId = xmlColumn.getAttribute("id").getValue();
                        if (xmlColumnId.equals(columnId)) {
                            if (!xmlColumn.getName().equals("column")) {
                                throw new IllegalArgumentException("ColumnSpec setPrefs - Invalid xml, element node column expected but " + xmlColumn.getName() + " found");
                            }
                            if (xmlColumn.getAttribute("width") == null || xmlColumn.getAttribute("min-width") == null || xmlColumn.getAttribute("max-width") == null) {
                                throw new IllegalArgumentException("ColumnSpec setPrefs - Invalid column node for " + columnId + ", it must have attribute width, min-width, max-width");
                            }
                            int width = Integer.parseInt(xmlColumn.getAttribute("width").getValue());
                            int maxWidth = Integer.parseInt(xmlColumn.getAttribute("max-width").getValue());
                            int minWidth = Integer.parseInt(xmlColumn.getAttribute("min-width").getValue());
                            columnSpec.setPrefs(width, maxWidth, minWidth);
                            if (i != j) {
                                ColumnSpec swap = (ColumnSpec)columnsSpec.get(i);
                                columnsSpec.set(i, (ColumnSpec)columnsSpec.get(j));
                                columnsSpec.set(j, swap);
                            }
                            find = true;
                            break;
                        }
                        ++j;
                    }
                    if (!find) {
                        throw new IllegalArgumentException("xml contain unknow column: " + columnId);
                    }
                    ++i;
                }
                ColumnsSpec cSpec = new ColumnsSpec("sales.quote.items", columnsSpec, possibleColumnIds, null);
                cSpec.setAllowMove(true);
                cSpec.setAllowResize(true);
                RowSelectionSpec selectionSpec = new RowSelectionSpec(this.getItemId());
                TableSpec tSpec = new TableSpec(this.getItemId(), selectionSpec, cSpec);
                tSpec.setColumns(cSpec);
                String id = this.getItemId();
                LightUITable eList = new LightUITable(id);
                eList.setTableSpec(tSpec);
                LightUIPanel panel = new LightUIPanel("sales.quote.items.list");
                panel.setGridWidth(1);
                panel.setFillWidth(true);
                LightUILine toolbarLine = new LightUILine();
                LightUIButtonUnmanaged b1 = new LightUIButtonUnmanaged("up");
                b1.setIcon("up.png");
                panel.addControler(new ActivationOnSelectionControler(id, b1.getId()));
                panel.addControler(new LightController("up", id, b1.getId()));
                toolbarLine.addChild(b1);
                LightUIButtonUnmanaged b2 = new LightUIButtonUnmanaged("down");
                b2.setIcon("down.png");
                panel.addControler(new ActivationOnSelectionControler(id, b2.getId()));
                panel.addControler(new LightController("down", id, b2.getId()));
                toolbarLine.addChild(b2);
                LightUIButtonUnmanaged addButton = new LightUIButtonUnmanaged("add", "Ajouter une ligne");
                panel.addControler(new LightController("addDefault", id, addButton.getId()));
                toolbarLine.addChild(addButton);
                LightUIButtonUnmanaged insertButton = new LightUIButtonUnmanaged("insert", "Ins\u00e9rer une ligne");
                panel.addControler(new LightController("insertDefault", id, insertButton.getId()));
                toolbarLine.addChild(insertButton);
                LightUIButtonUnmanaged copyButton = new LightUIButtonUnmanaged("copy", "Dupliquer");
                panel.addControler(new ActivationOnSelectionControler(id, copyButton.getId()));
                panel.addControler(new LightController("copy", id, copyButton.getId()));
                toolbarLine.addChild(copyButton);
                LightUIButtonUnmanaged removeButton = new LightUIButtonUnmanaged("remove", "Supprimer");
                panel.addControler(new ActivationOnSelectionControler(id, removeButton.getId()));
                panel.addControler(new LightController("remove", id, removeButton.getId()));
                toolbarLine.addChild(removeButton);
                panel.addChild(toolbarLine);
                LightUILine listLine = new LightUILine();
                listLine.setWeightY(1);
                listLine.setFillHeight(true);
                listLine.addChild(eList);
                panel.addChild(listLine);
                return panel;
            }

            @Override
            public void fillFrom(LightUIElement uiElement, SQLRowAccessor sqlRow) {
                LightUIPanel p = (LightUIPanel)uiElement;
                LightUITable ltable = p.getFirstChild(LightUITable.class);
                TableSpec tSpec = ltable.getTableSpec();
                ColumnsSpec columnsSpec = tSpec.getColumns();
                SQLElement elem = configuration.getDirectory().getElement("DEVIS_ELEMENT");
                SQLTable table = elem.getTable();
                ArrayList<String> fieldsToFetch = new ArrayList<String>();
                for (ColumnSpec cs : columnsSpec.getColumns()) {
                    String colId = cs.getId();
                    SQLField f = configuration.getFieldMapper().getSQLFieldForItem(colId);
                    if (f != null) {
                        fieldsToFetch.add(f.getName());
                        continue;
                    }
                    throw new IllegalStateException("No field in " + table + " for column id " + colId);
                }
                Where where = new Where((FieldRef)table.getField("ID_DEVIS"), "=", sqlRow.getID());
                ListSQLRequest req = elem.createListRequest(fieldsToFetch, where, configuration.getShowAs());
                List<SQLRowValues> fetchedRows = req.getValues();
                ArrayList<Row> rows = new ArrayList<Row>();
                for (SQLRowValues vals : fetchedRows) {
                    Row r = new Row(vals.getID(), columnsSpec.getColumns().size());
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (ColumnSpec cs : columnsSpec.getColumns()) {
                        String colId = cs.getId();
                        SQLField f = configuration.getFieldMapper().getSQLFieldForItem(colId);
                        if (f != null) {
                            Object object = vals.getObject(f.getName());
                            if (object instanceof SQLRowValues) {
                                SQLRowValues sqlRowValues = (SQLRowValues)object;
                                long rowId = sqlRowValues.getIDNumber().longValue();
                                List<SQLField> fieldsToExpand = configuration.getShowAs().getFieldExpand(sqlRowValues.getTable());
                                StringBuilder b = new StringBuilder();
                                for (SQLField sqlField : fieldsToExpand) {
                                    b.append(sqlRowValues.getObject(sqlField.getName()).toString());
                                    b.append(' ');
                                }
                                object = new StringWithId(rowId, b.toString().trim());
                            }
                            values.add(object);
                            continue;
                        }
                        throw new IllegalStateException("No field in " + table + " for column id " + colId);
                    }
                    r.setValues(values);
                    rows.add(r);
                }
                TableContent tableContent = new TableContent();
                tableContent.setRows(rows);
                tSpec.setContent(tableContent);
            }

            @Override
            public void store(LightUIElement uiElement, SQLRowValues row) {
            }
        });
        return map;
    }

    @Override
    protected String createCode() {
        return "sales.quote";
    }

    public static enum Month {
        JANVIER("01", "Janvier"),
        FEVRIER("02", "F\u00e9vrier"),
        MARS("03", "Mars"),
        AVRIL("04", "Avril"),
        MAI("05", "Mai"),
        JUIN("06", "Juin"),
        JUILLET("07", "Juillet"),
        AOUT("08", "Ao\u00fbt"),
        SEPTEMBRE("09", "Septembre"),
        OCTOBRE("10", "Octobre"),
        NOVEMBRE("11", "Novembre"),
        DECEMBRE("12", "D\u00e9cembre");

        private String number;
        private String name;

        private Month(String number, String name) {
            this.number = number;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getNumber() {
            return this.number;
        }

        public String getPath() {
            return String.valueOf(this.getNumber()) + "-" + this.getName();
        }
    }
}

