/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.FamilleArticlePanel;
import org.openconcerto.erp.panel.ITreeSelection;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Tuple2;

public class ListeDesArticlesFrame
extends JFrame {
    private static final String TITLE = "Liste des articles";
    private final SQLTable sqlTableArticle;
    private final SQLTable sqlTableFamilleArticle;

    public ListeDesArticlesFrame(SQLElementDirectory dir) {
        IListe liste;
        SQLTableModelSourceOnline withDeclSrc;
        ReferenceArticleSQLElement elt = dir.getElement(ReferenceArticleSQLElement.class);
        SQLElement articleFamilyElt = elt.getForeignElement("ID_FAMILLE_ARTICLE");
        FamilleArticlePanel panelFam = new FamilleArticlePanel(articleFamilyElt);
        this.sqlTableArticle = elt.getTable();
        this.sqlTableFamilleArticle = articleFamilyElt.getTable();
        SQLPreferences prefs = SQLPreferences.getMemCached(elt.getTable().getDBRoot());
        boolean hasDeclinaison = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false);
        final File normalConfig = IListPanel.getConfigFile(elt, ListeAddPanel.class, "normal");
        final File virtualConfig = IListPanel.getConfigFile(elt, ListeAddPanel.class, "virtual");
        final SQLTableModelSourceOnline noDeclSrc = this.getTableSource(elt, null);
        if (hasDeclinaison) {
            ArrayList<String> fieldsDecl = new ArrayList<String>();
            for (String fieldName : elt.getTable().getFieldsName()) {
                if (!fieldName.startsWith("ID_ARTICLE_DECLINAISON_")) continue;
                fieldsDecl.add(fieldName);
            }
            withDeclSrc = this.getTableSource(elt, fieldsDecl);
            liste = new IListe(withDeclSrc, normalConfig);
        } else {
            withDeclSrc = null;
            liste = new IListe(noDeclSrc, virtualConfig);
        }
        final ListeAddPanel panel = new ListeAddPanel(elt, liste){

            @Override
            protected void handleAction(final JButton source, final ActionEvent evt) {
                if (source == this.buttonEffacer && this.getListe().fetchSelectedRow() != null) {
                    JPanel panel = new JPanel();
                    DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                    c.gridwidth = 2;
                    panel.add((Component)new JLabel("Voulez vous supprimer ou rendre obsol\u00e9te?"), c);
                    JButton buttonObs = new JButton("Obsol\u00e8te");
                    JButton buttonSuppr = new JButton("Supprimer");
                    ++c.gridy;
                    panel.add((Component)buttonObs, c);
                    ++c.gridx;
                    panel.add((Component)buttonSuppr, c);
                    final PanelFrame frame = new PanelFrame(panel, "Suppression d'article");
                    buttonObs.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            List<SQLRowAccessor> rowVals = liste.getSelectedRowAccessors();
                            UpdateBuilder build = new UpdateBuilder(ListeDesArticlesFrame.this.sqlTableArticle);
                            build.setObject("OBSOLETE", (Object)Boolean.TRUE);
                            ArrayList<Integer> ids = new ArrayList<Integer>();
                            for (SQLRowAccessor sqlRowValues : rowVals) {
                                ids.add(sqlRowValues.getID());
                            }
                            build.setWhere(Where.inValues(ListeDesArticlesFrame.this.sqlTableArticle.getKey(), ids));
                            ListeDesArticlesFrame.this.sqlTableArticle.getDBSystemRoot().getDataSource().execute(build.asString());
                            frame.dispose();
                        }
                    });
                    buttonSuppr.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            frame.dispose();
                            this.SuperHandleAction(source, evt);
                        }
                    });
                    frame.pack();
                    frame.setResizable(false);
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            }

            public void SuperHandleAction(JButton source, ActionEvent evt) {
                super.handleAction(source, evt);
            }
        };
        final JRadioButton radioNormal = new JRadioButton("Normal");
        JRadioButton radioVirtuel = new JRadioButton("Virtuel");
        final Consumer<ListSQLRequest> updateWhere = req -> req.putWhere(this.getClass(), this.getWhere(panelFam, radioVirtuel.isSelected()));
        updateWhere.accept(panel.getListe().getRequest());
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.gridy = 4;
        c2.anchor = 13;
        c2.weightx = 0.0;
        c2.fill = 0;
        if (hasDeclinaison) {
            JPanel panelMode = new JPanel(new GridBagLayout());
            DefaultGridBagConstraints cMode = new DefaultGridBagConstraints();
            cMode.gridy = 4;
            cMode.anchor = 13;
            cMode.weightx = 0.0;
            cMode.fill = 0;
            ButtonGroup groupButton = new ButtonGroup();
            groupButton.add(radioNormal);
            groupButton.add(radioVirtuel);
            radioNormal.setSelected(true);
            panelMode.add((Component)radioNormal, cMode);
            ++cMode.gridx;
            panelMode.add((Component)radioVirtuel, cMode);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        boolean normal = radioNormal.isSelected();
                        SQLTableModelSourceOnline src = normal ? withDeclSrc : noDeclSrc;
                        updateWhere.accept(src.getReq());
                        try {
                            panel.getListe().saveTableState();
                        }
                        catch (IOException e1) {
                            Log.get().log(Level.WARNING, "Couldn't save table state", e1);
                        }
                        panel.getListe().setConfigFile(null);
                        panel.getListe().setSource(src);
                        panel.getListe().setConfigFile(normal ? normalConfig : virtualConfig);
                    }
                }
            };
            radioNormal.addItemListener(itemListener);
            radioVirtuel.addItemListener(itemListener);
            ++c2.gridy;
            panelMode.setBorder(BorderFactory.createTitledBorder("Vue"));
            panel.add((Component)panelMode, c2);
        }
        SQLTableModelColumn colStock = null;
        for (SQLTableModelColumn col : panel.getListe().getSource().getColumns()) {
            if (!col.getName().equalsIgnoreCase("Valeur HT du stock")) continue;
            colStock = col;
        }
        if (colStock != null) {
            ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> fields = new ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>>(1);
            fields.add(Tuple2.create(colStock, IListTotalPanel.Type.SOMME));
            IListTotalPanel total = new IListTotalPanel(panel.getListe(), fields, null, "Total");
            ++c2.gridy;
            panel.add((Component)total, c2);
        }
        JSplitPane pane = new JSplitPane(1, new JScrollPane(panelFam), panel);
        JPanel panelAll = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panelAll.add((Component)pane, c);
        ITreeSelection tree = panelFam.getFamilleTree();
        tree.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                updateWhere.accept(panel.getListe().getRequest());
            }
        });
        this.setTitle(TITLE);
        panel.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ListeDesArticlesFrame.this.setTitle(panel);
            }
        });
        panel.getListe().addListenerOnModel(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().equals("loading") || evt.getPropertyName().equals("searching")) {
                    ListeDesArticlesFrame.this.setTitle(panel);
                }
            }
        });
        panelFam.getCheckObsolete().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSQLRequest request = panel.getListe().getRequest();
                updateWhere.accept(request);
            }
        });
        this.setContentPane(panelAll);
    }

    protected void setTitle(ListeAddPanel panel) {
        String title = TITLE;
        if (panel.getListe().getModel().isLoading()) {
            title = String.valueOf(title) + ", chargement en cours";
        }
        if (panel.getListe().getModel().isSearching()) {
            title = String.valueOf(title) + ", recherche en cours";
        }
        this.setTitle(title);
    }

    private SQLTableModelSourceOnline getTableSource(final SQLElement elt, List<String> fields) {
        SQLTableModelSourceOnline createTableSource = elt.createTableSource();
        if (fields != null && !fields.isEmpty()) {
            for (String fieldName : fields) {
                Path p = (Path)new Path(elt.getTable()).addForeignField(fieldName);
                FieldPath fieldPath = new FieldPath(p, "NOM");
                createTableSource.getColumns().add(new SQLTableModelColumnPath(fieldPath, null, elt.getDirectory()));
            }
        }
        if (!elt.getTable().getDBRoot().contains("ARTICLE_PRIX_REVIENT")) {
            BaseSQLTableModelColumn colStock = new BaseSQLTableModelColumn("Valeur HT du stock", BigDecimal.class){

                @Override
                protected Object show_(SQLRowAccessor r) {
                    SQLRowAccessor stock = r.getForeign("ID_STOCK");
                    if (stock == null || stock.isUndefined()) {
                        return BigDecimal.ZERO;
                    }
                    float qte = stock.getFloat("QTE_REEL");
                    BigDecimal ha = r.getBigDecimal("PA_HT");
                    BigDecimal total = ha.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION);
                    if (total.signum() == 1) {
                        return total;
                    }
                    return BigDecimal.ZERO;
                }

                @Override
                public Set<FieldPath> getPaths() {
                    SQLTable table = elt.getTable();
                    Path p = new Path(table);
                    Path p2 = (Path)new Path(table).addForeignField("ID_STOCK");
                    return CollectionUtils.createSet(new FieldPath(p, "PA_HT"), new FieldPath(p2, "QTE_REEL"));
                }
            };
            colStock.setRenderer(ComptaSQLConfElement.CURRENCY_RENDERER);
            createTableSource.getColumns().add(colStock);
        }
        return createTableSource;
    }

    public Where getWhere(FamilleArticlePanel panel, boolean virtuals) {
        int id = panel.getFamilleTree().getSelectedID();
        Where w = null;
        if (panel.getCheckObsolete().isSelected()) {
            w = new Where((FieldRef)this.sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
        }
        w = new Where((FieldRef)this.sqlTableArticle.getField("VIRTUEL"), "=", (Object)virtuals).and(w);
        if (id > 1) {
            HashSet<Integer> idsMatch = new HashSet<Integer>();
            idsMatch.add(id);
            this.fillChildren(idsMatch, CollectionUtils.createSet(id));
            Where w2 = new Where((FieldRef)this.sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", this.sqlTableFamilleArticle.getKey());
            w2 = w2.and(Where.inValues(this.sqlTableFamilleArticle.getKey(), idsMatch));
            w = w2.and(w);
        }
        return w;
    }

    private void fillChildren(Set<Integer> idsMatch, Set<Integer> father) {
        SQLRowValues rowVals = new SQLRowValues(this.sqlTableFamilleArticle);
        String keyFieldName = rowVals.getTable().getKey().getName();
        rowVals.put(keyFieldName, null);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        List<SQLRowValues> children = fetcher.fetch(Where.inValues(this.sqlTableFamilleArticle.getField("ID_FAMILLE_ARTICLE_PERE"), father));
        HashSet<Integer> childToCheck = new HashSet<Integer>();
        for (SQLRowValues child : children) {
            if (idsMatch.contains(child.getID())) continue;
            childToCheck.add(child.getID());
            idsMatch.add(child.getID());
        }
        if (!childToCheck.isEmpty()) {
            this.fillChildren(idsMatch, childToCheck);
        }
    }
}

