/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.openconcerto.erp.core.sales.product.model.PriceByQty;
import org.openconcerto.erp.core.sales.product.model.ProductHelper;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;

public class ProductComponent {
    private final SQLRowAccessor product;
    private final SQLRowAccessor source;
    private final SQLRowAccessor stock;
    private BigDecimal qty;
    private final ProductHelper helper;

    public ProductComponent(SQLRowAccessor product, BigDecimal qty, SQLRowAccessor source, SQLRowAccessor stock) {
        this.product = product;
        this.qty = qty;
        this.helper = new ProductHelper(product.getTable().getDBRoot());
        this.source = source;
        this.stock = stock;
    }

    public SQLRowAccessor getProduct() {
        return this.product;
    }

    public SQLRowAccessor getSource() {
        return this.source;
    }

    public SQLRowAccessor getStock() {
        return this.stock;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public void addQty(BigDecimal b) {
        this.qty = this.qty.add(b);
    }

    public BigDecimal getPRC(Date d) {
        if (this.product.getTable().getDBRoot().contains("ARTICLE_PRIX_REVIENT")) {
            Calendar date;
            BigDecimal result = null;
            SQLTable table = this.product.getTable().getDBRoot().getTable("ARTICLE_PRIX_REVIENT");
            Collection prcs = this.product.asRow().getReferentRows(table);
            Date lastDate = null;
            ArrayList<PriceByQty> prices = new ArrayList<PriceByQty>();
            for (SQLRow row : prcs) {
                date = Calendar.getInstance();
                if (row.getObject("DATE") != null) {
                    date = row.getDate("DATE");
                    lastDate = date.getTime();
                }
                prices.add(new PriceByQty(row.getLong("QTE"), row.getBigDecimal("PRIX"), date.getTime()));
            }
            result = PriceByQty.getPriceForQty(this.qty.setScale(0, RoundingMode.HALF_UP).intValue(), prices, d);
            if (result == null) {
                result = PriceByQty.getPriceForQty(this.qty.setScale(0, RoundingMode.HALF_UP).intValue(), prices, lastDate);
            } else if (prices.size() > 0) {
                result = ((PriceByQty)prices.get(0)).getPrice();
            }
            if (result == null) {
                SQLTable tableATF = this.product.getTable().getDBRoot().getTable("ARTICLE_TARIF_FOURNISSEUR");
                Collection atfs = this.product.asRow().getReferentRows(tableATF);
                Date lastDateATF = null;
                ArrayList<PriceByQty> pricesATF = new ArrayList<PriceByQty>();
                for (SQLRow row : atfs) {
                    date = Calendar.getInstance();
                    if (row.getObject("DATE_PRIX") != null) {
                        date = row.getDate("DATE_PRIX");
                        lastDateATF = date.getTime();
                    }
                    pricesATF.add(new PriceByQty(row.getLong("QTE"), this.helper.getEnumPrice(row, ProductHelper.SupplierPriceField.COEF_TRANSPORT_SIEGE), date.getTime()));
                }
                result = PriceByQty.getPriceForQty(this.qty.setScale(0, RoundingMode.HALF_UP).intValue(), pricesATF, d);
                if (result == null && (result = PriceByQty.getPriceForQty(this.qty.setScale(0, RoundingMode.HALF_UP).intValue(), pricesATF, lastDateATF)) == null) {
                    result = BigDecimal.ZERO;
                }
            }
            return result;
        }
        return null;
    }

    public static ProductComponent createFromRowArticle(SQLRowAccessor rowArticle, BigDecimal qty, SQLRowAccessor rowValsSource) {
        SQLRowAccessor rowStock = ProductComponent.getStock(rowArticle, rowArticle, rowValsSource);
        return new ProductComponent(rowArticle, qty, rowValsSource, rowStock);
    }

    public static ProductComponent createFromRowArticle(SQLRowAccessor rowArticle, SQLRowAccessor rowValsSource) {
        return ProductComponent.createFromRowArticle(rowArticle, BigDecimal.ONE, rowValsSource);
    }

    public static ProductComponent createFrom(SQLRowAccessor rowVals) {
        return ProductComponent.createFrom(rowVals, 1, rowVals);
    }

    public static ProductComponent createFrom(SQLRowAccessor rowVals, SQLRowAccessor rowValsSource) {
        return ProductComponent.createFrom(rowVals, 1, rowValsSource);
    }

    public static ProductComponent createFrom(SQLRowAccessor rowVals, int qteMultiple, SQLRowAccessor rowValsSource) {
        if (rowVals.getForeign("ID_ARTICLE") == null || rowVals.isForeignEmpty("ID_ARTICLE")) {
            throw new IllegalArgumentException("Aucun article associ\u00e9 \u00e0 la row " + rowVals.getTable().getName() + " " + rowVals.getID());
        }
        int qteMult = rowVals.getTable().getName().equalsIgnoreCase("BON_DE_LIVRAISON_ELEMENT") ? rowVals.getInt("QTE_LIVREE") : rowVals.getInt("QTE");
        int qte = qteMult * qteMultiple;
        BigDecimal qteUV = rowVals.getBigDecimal("QTE_UNITAIRE");
        BigDecimal qteFinal = qteUV.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION);
        SQLRowAccessor rowStock = ProductComponent.getStock(rowVals.getForeign("ID_ARTICLE"), rowVals, rowValsSource);
        return new ProductComponent(rowVals.getForeign("ID_ARTICLE"), qteFinal, rowValsSource, rowStock);
    }

    private static SQLRowAccessor getStock(SQLRowAccessor rowValsProduct, SQLRowAccessor rowValsElt, SQLRowAccessor rowValsSource) {
        SQLTable tableAff;
        SQLRowAccessor rowStock = null;
        int idDepot = -1;
        if (rowValsProduct.getTable().getDBRoot().contains("AFFAIRE") && (tableAff = rowValsProduct.getTable().getTable("AFFAIRE")).contains("ID_DEPOT_STOCK")) {
            if (rowValsSource.getFields().contains("ID_DEPOT_STOCK") && !rowValsSource.isForeignEmpty("ID_DEPOT_STOCK")) {
                idDepot = rowValsSource.getForeignID("ID_DEPOT_STOCK");
            } else if (rowValsSource.getFields().contains("ID_AFFAIRE") && !rowValsSource.isForeignEmpty("ID_AFFAIRE")) {
                SQLRowAccessor rowAff = rowValsSource.getForeign("ID_AFFAIRE");
                if (rowAff.getFields().contains("ID_DEPOT_STOCK") && !rowAff.isForeignEmpty("ID_DEPOT_STOCK")) {
                    idDepot = rowAff.getForeignID("ID_DEPOT_STOCK");
                }
            } else {
                SQLRowAccessor rowAff;
                SQLRowAccessor parent;
                SQLField fieldParent = Configuration.getInstance().getDirectory().getElement(rowValsSource.getTable()).getParentForeignField();
                if (fieldParent != null && (parent = rowValsSource.getForeign(fieldParent.getName())).getFields().contains("ID_AFFAIRE") && !parent.isForeignEmpty("ID_AFFAIRE") && (rowAff = parent.getForeign("ID_AFFAIRE")).getFields().contains("ID_DEPOT_STOCK") && !rowAff.isForeignEmpty("ID_DEPOT_STOCK")) {
                    idDepot = rowAff.getForeignID("ID_DEPOT_STOCK");
                }
            }
        }
        if (idDepot == -1) {
            if (rowValsSource.getFields().contains("ID_DEPOT_STOCK") && !rowValsSource.isForeignEmpty("ID_DEPOT_STOCK")) {
                idDepot = rowValsSource.getForeignID("ID_DEPOT_STOCK");
            } else if (rowValsElt.getForeign("ID_DEPOT_STOCK") != null && !rowValsElt.isForeignEmpty("ID_DEPOT_STOCK")) {
                idDepot = rowValsElt.getForeignID("ID_DEPOT_STOCK");
            } else {
                idDepot = DepotStockSQLElement.DEFAULT_ID;
                try {
                    rowValsElt.createEmptyUpdateRow().put("ID_DEPOT_STOCK", idDepot).commit();
                }
                catch (SQLException e) {
                    ExceptionHandler.handle("Erreur lors de l'initialisation du stock!", e);
                }
            }
        }
        SQLTable stockTable = rowValsElt.getTable().getTable("STOCK");
        SQLRowValues putRowValuesStock = new SQLRowValues(stockTable);
        putRowValuesStock.putNulls(stockTable.getTable().getFieldsName());
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(putRowValuesStock);
        Where w = new Where((FieldRef)putRowValuesStock.getTable().getField("ID_DEPOT_STOCK"), "=", idDepot);
        Where w2 = new Where((FieldRef)putRowValuesStock.getTable().getField("ID_ARTICLE"), "=", rowValsProduct.getID());
        List<SQLRowValues> rowValsResult = fetch.fetch(w.and(w2));
        if (rowValsResult.size() == 0) {
            SQLRowValues rowValsStock = new SQLRowValues(stockTable);
            rowValsStock.put("ID_ARTICLE", rowValsProduct.getID());
            rowValsStock.put("ID_DEPOT_STOCK", idDepot);
            rowValsStock.put("QTE_TH", Float.valueOf(0.0f));
            rowValsStock.put("QTE_REEL", Float.valueOf(0.0f));
            rowValsStock.put("QTE_RECEPT_ATTENTE", Float.valueOf(0.0f));
            rowValsStock.put("QTE_LIV_ATTENTE", Float.valueOf(0.0f));
            try {
                rowStock = rowValsStock.insert();
                if (idDepot == DepotStockSQLElement.DEFAULT_ID) {
                    rowValsProduct.createEmptyUpdateRow().put("ID_STOCK", rowStock.getID()).commit();
                }
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors la cr\u00e9ation du stock!", e);
            }
        } else if (rowValsResult.size() == 1) {
            rowStock = (SQLRowAccessor)rowValsResult.iterator().next();
        } else if (rowValsResult.size() > 1) {
            throw new IllegalStateException("2 lignes de stocks pour le m\u00eame d\u00e9p\u00f4t! Article " + rowValsProduct.getID() + " Depot " + rowValsElt.getForeignID("ID_DEPOT_STOCK"));
        }
        return rowStock;
    }

    public static SQLRowAccessor findOrCreateStock(SQLRowAccessor article, SQLRowAccessor depot) {
        SQLRowAccessor rowStock = null;
        SQLTable stockTable = article.getTable().getTable("STOCK");
        SQLRowValues putRowValuesStock = new SQLRowValues(stockTable);
        putRowValuesStock.putNulls(stockTable.getTable().getFieldsName());
        SQLRowValuesListFetcher fetch = SQLRowValuesListFetcher.create(putRowValuesStock);
        Where w = new Where((FieldRef)putRowValuesStock.getTable().getField("ID_DEPOT_STOCK"), "=", depot.getID());
        Where w2 = new Where((FieldRef)putRowValuesStock.getTable().getField("ID_ARTICLE"), "=", article.getID());
        List<SQLRowValues> rowValsResult = fetch.fetch(w.and(w2));
        if (rowValsResult.size() == 0) {
            SQLRowValues rowValsStock = new SQLRowValues(stockTable);
            rowValsStock.put("ID_ARTICLE", article.getID());
            rowValsStock.put("ID_DEPOT_STOCK", depot.getID());
            rowValsStock.put("QTE_TH", Float.valueOf(0.0f));
            rowValsStock.put("QTE_REEL", Float.valueOf(0.0f));
            rowValsStock.put("QTE_RECEPT_ATTENTE", Float.valueOf(0.0f));
            rowValsStock.put("QTE_LIV_ATTENTE", Float.valueOf(0.0f));
            try {
                rowStock = rowValsStock.insert();
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors la cr\u00e9ation du stock!", e);
            }
        } else if (rowValsResult.size() == 1) {
            rowStock = (SQLRowAccessor)rowValsResult.iterator().next();
        } else if (rowValsResult.size() > 1) {
            throw new IllegalStateException("2 lignes de stocks pour le m\u00eame d\u00e9p\u00f4t! Article " + article.getID() + " Depot " + depot.getID());
        }
        return rowStock;
    }
}

