/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.CodeFournisseurItemTable;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ArticleCodeClientTable;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.element.SupplierPriceListTable;
import org.openconcerto.erp.core.sales.product.model.ProductHelper;
import org.openconcerto.erp.core.sales.product.ui.ArticleCategorieComptableTable;
import org.openconcerto.erp.core.sales.product.ui.ArticleDesignationTable;
import org.openconcerto.erp.core.sales.product.ui.ArticlePromotionTable;
import org.openconcerto.erp.core.sales.product.ui.ArticleTarifTable;
import org.openconcerto.erp.core.sales.product.ui.ProductItemListTable;
import org.openconcerto.erp.core.sales.product.ui.ProductQtyPriceListTable;
import org.openconcerto.erp.core.sales.product.ui.RowValuesTableEditionPanel;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ReferenceArticleSQLComponent
extends BaseSQLComponent {
    protected JTextField textPVHT;
    protected JTextField textPVTTC;
    protected JTextField textPAHT;
    protected JTextField textMetrique1VT;
    protected JTextField textMetrique1HA;
    private final JCheckBox boxService = new JCheckBox(this.getLabelFor("SERVICE"));
    private final JCheckBox checkObs = new JCheckBox(this.getLabelFor("OBSOLETE"));
    private JTextField textNom;
    private JTextField textCode;
    private JTextField textPoids;
    private JTextField textValMetrique1;
    private JTextField textValMetrique2;
    private JTextField textValMetrique3;
    private DocumentListener htDocListener;
    private DocumentListener ttcDocListener;
    private DocumentListener detailsListener;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener taxeListener;
    private final ElementComboBox comboSelTaxe = new ElementComboBox(false, 10);
    private final ElementComboBox comboSelModeVente = new ElementComboBox(false, 25);
    private JLabel labelMetriqueHA1 = new JLabel(this.getLabelFor("PRIX_METRIQUE_HA_1"), 4);
    private JLabel labelMetriqueVT1 = new JLabel(this.getLabelFor("PRIX_METRIQUE_VT_1"), 4);
    protected ArticleDesignationTable tableDes = new ArticleDesignationTable();
    protected ArticleCodeClientTable tableCodeClient = new ArticleCodeClientTable();
    protected ArticleTarifTable tableTarifVente = new ArticleTarifTable(this);
    protected ArticlePromotionTable tableTarifPromotionVente = new ArticlePromotionTable(this);
    protected final ArticleCategorieComptableTable tableCatComptable = new ArticleCategorieComptableTable();
    protected SupplierPriceListTable tableFourSec = new SupplierPriceListTable();
    protected ProductQtyPriceListTable tableTarifQteVente = new ProductQtyPriceListTable(this);
    protected ProductItemListTable tableBom;
    protected final JTextField textMarge = new JTextField(10);
    protected final JLabel labelMarge = new JLabel("%           ");
    protected ElementComboBox boxCR;
    protected JCheckBox boxMargeWithCR;
    protected List<ElementComboBox> boxesDeclinaison = new ArrayList<ElementComboBox>();
    protected DocumentListener pieceHAArticle = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            if (!ReferenceArticleSQLComponent.this.textPAHT.getText().equalsIgnoreCase(ReferenceArticleSQLComponent.this.textMetrique1HA.getText())) {
                ReferenceArticleSQLComponent.this.textMetrique1HA.setText(ReferenceArticleSQLComponent.this.textPAHT.getText());
            }
        }
    };
    protected DocumentListener pieceVTArticle = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            if (!ReferenceArticleSQLComponent.this.textPVHT.getText().equalsIgnoreCase(ReferenceArticleSQLComponent.this.textMetrique1VT.getText())) {
                ReferenceArticleSQLComponent.this.textMetrique1VT.setText(ReferenceArticleSQLComponent.this.textPVHT.getText());
            }
        }
    };
    protected DocumentListener listenerMargeTextMarge = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            ReferenceArticleSQLComponent.this.textPVHT.getDocument().removeDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
            ReferenceArticleSQLComponent.this.updateVtFromMarge();
            ReferenceArticleSQLComponent.this.textPVHT.getDocument().addDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
        }
    };
    protected DocumentListener listenerMargeTextVT = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            ReferenceArticleSQLComponent.this.textMarge.getDocument().removeDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextMarge);
            if (ReferenceArticleSQLComponent.this.textPVHT.getText().trim().length() > 0 && ReferenceArticleSQLComponent.this.textPAHT.getText().trim().length() > 0) {
                BigDecimal vt = StringUtils.getBigDecimalFromUserText(ReferenceArticleSQLComponent.this.textPVHT.getText());
                BigDecimal ha = StringUtils.getBigDecimalFromUserText(ReferenceArticleSQLComponent.this.textPAHT.getText());
                if (vt != null && ha != null && vt.signum() != 0 && ha.signum() != 0) {
                    SQLRow rowCR;
                    if (ReferenceArticleSQLComponent.this.boxMargeWithCR.isSelected() && ReferenceArticleSQLComponent.this.boxCR != null && (rowCR = ReferenceArticleSQLComponent.this.boxCR.getSelectedRow()) != null && !rowCR.isUndefined()) {
                        BigDecimal cr = rowCR.getBigDecimal("POURCENT");
                        ha = ha.multiply(cr.movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
                    }
                    BigDecimal margeHT = vt.subtract(ha);
                    BigDecimal value = DefaultNXProps.getInstance().getBooleanValue(TotalPanel.MARGE_MARQUE, false) ? (vt.compareTo(BigDecimal.ZERO) > 0 ? margeHT.divide(vt, DecimalUtils.HIGH_PRECISION).multiply(BigDecimal.valueOf(100L), DecimalUtils.HIGH_PRECISION) : BigDecimal.ZERO) : margeHT.divide(ha, DecimalUtils.HIGH_PRECISION).multiply(BigDecimal.valueOf(100L), DecimalUtils.HIGH_PRECISION);
                    if (value.compareTo(BigDecimal.ZERO) > 0) {
                        ReferenceArticleSQLComponent.this.textMarge.setText(value.setScale(6, RoundingMode.HALF_UP).toString());
                    } else {
                        ReferenceArticleSQLComponent.this.textMarge.setText("0");
                    }
                    ReferenceArticleSQLComponent.this.labelMarge.setText("% (" + StringUtils.leftAlign(margeHT.setScale(2, RoundingMode.HALF_UP).toString(), 9) + ")");
                }
            }
            ReferenceArticleSQLComponent.this.textMarge.getDocument().addDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextMarge);
        }
    };
    protected DocumentListener listenerMargeTextHA = new SimpleDocumentListener(){

        @Override
        public void update(DocumentEvent e) {
            ReferenceArticleSQLComponent.this.textPVHT.getDocument().removeDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
            ReferenceArticleSQLComponent.this.updateVtFromMarge();
            ReferenceArticleSQLComponent.this.textPVHT.getDocument().addDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
        }
    };
    protected SQLRowValues rowValuesDefaultCodeFournisseur;
    protected CodeFournisseurItemTable codeFournisseurTable;

    public void updateVtFromMarge() {
        BigDecimal ha;
        if (this.textPAHT.getText().trim().length() > 0 && (ha = StringUtils.getBigDecimalFromUserText(this.textPAHT.getText())) != null && this.textMarge.getText().trim().length() > 0) {
            BigDecimal vt;
            BigDecimal d;
            SQLRow rowCR;
            if (this.boxMargeWithCR.isSelected() && this.boxCR != null && (rowCR = this.boxCR.getSelectedRow()) != null && !rowCR.isUndefined()) {
                BigDecimal cr = rowCR.getBigDecimal("POURCENT");
                ha = ha.multiply(cr.movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
            }
            if ((d = StringUtils.getBigDecimalFromUserText(this.textMarge.getText())) == null) {
                d = BigDecimal.ZERO;
            }
            if (DefaultNXProps.getInstance().getBooleanValue(TotalPanel.MARGE_MARQUE, false)) {
                BigDecimal e = BigDecimal.ONE.subtract(d.divide(BigDecimal.valueOf(100L), DecimalUtils.HIGH_PRECISION));
                vt = e.signum() == 0 ? BigDecimal.ZERO : ha.divide(e, DecimalUtils.HIGH_PRECISION).setScale((int)this.getTable().getField("PV_HT").getType().getDecimalDigits(), RoundingMode.HALF_UP);
            } else {
                BigDecimal result = ha.multiply(d.divide(BigDecimal.valueOf(100L), DecimalUtils.HIGH_PRECISION).add(BigDecimal.ONE));
                vt = result.setScale((int)this.getTable().getField("PV_HT").getType().getDecimalDigits(), RoundingMode.HALF_UP);
                this.textPVHT.setText(vt.toString());
            }
            this.textPVHT.setText(vt.toString());
            BigDecimal margeHT = vt.subtract(ha);
            this.labelMarge.setText("% (" + StringUtils.leftAlign(margeHT.setScale(2, RoundingMode.HALF_UP).toString(), 9) + ")");
        }
    }

    public ReferenceArticleSQLComponent(SQLElement elt) {
        super(elt);
        if (elt.getTable().getDBRoot().contains("ARTICLE_ELEMENT")) {
            this.tableBom = new ProductItemListTable();
        }
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (r != null && r.getID() > this.getTable().getUndefinedID()) {
            this.checkObs.setVisible(true);
            this.tableTarifVente.setArticleValues(r);
            this.selectModeVente(r.getForeignID("ID_MODE_VENTE_ARTICLE"));
        } else if (r == null || !r.contains("CODE") || r.getString("CODE") == null || r.getString("CODE").trim().length() == 0) {
            this.getElement().getDirectory().getElement(NumerotationAutoSQLElement.class);
            this.textCode.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        }
        this.tableTarifVente.getRowValuesTable().insertFrom(r);
        this.tableTarifPromotionVente.getRowValuesTable().insertFrom(r);
        this.tableCatComptable.getRowValuesTable().insertFrom(r);
        this.tableFourSec.getRowValuesTable().insertFrom(r);
        this.tableTarifQteVente.getRowValuesTable().insertFrom(r);
        if (this.tableBom != null) {
            this.tableBom.getRowValuesTable().getRowValuesTableModel().insertFrom(r, this.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT"));
        }
        this.tableDes.getRowValuesTable().insertFrom(r);
        this.tableCodeClient.getRowValuesTable().insertFrom(r);
        if (this.codeFournisseurTable != null) {
            this.codeFournisseurTable.getModel().insertFrom(r);
        }
        for (ElementComboBox elementComboBox : this.boxesDeclinaison) {
            elementComboBox.setEnabled(r != null && r.getNonEmptyForeign("ID_ARTICLE_VIRTUEL_PERE") != null ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
        }
    }

    @Override
    public void addViews() {
        DefaultProps props;
        String modeVente;
        Boolean bModeVente;
        boolean modeVenteAvance;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.textPVHT = new JTextField(15);
        this.textPVTTC = new JTextField(15);
        this.textPAHT = new JTextField(15);
        this.textPVHT.getDocument().addDocumentListener(this.listenerMargeTextVT);
        this.textMetrique1HA = new JTextField(15);
        this.textMetrique1VT = new JTextField(15);
        this.textValMetrique1 = new JTextField(15);
        this.textValMetrique2 = new JTextField(15);
        this.textValMetrique3 = new JTextField(15);
        this.textCode = new JTextField();
        this.textNom = new JTextField();
        this.textPoids = new JTextField(6);
        JLabel codelabel = new JLabel(this.getLabelFor("CODE"));
        codelabel.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(codelabel);
        this.add((Component)codelabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        DefaultGridBagConstraints.lockMinimumSize(this.textCode);
        this.add((Component)this.textCode, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelFamille = new JLabel(this.getLabelFor("ID_FAMILLE_ARTICLE"));
        labelFamille.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(labelFamille);
        this.add((Component)labelFamille, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        ElementComboBox comboSelFamille = new ElementComboBox(false, 25);
        this.addSQLObject(comboSelFamille, "ID_FAMILLE_ARTICLE");
        DefaultGridBagConstraints.lockMinimumSize(comboSelFamille);
        this.add((Component)comboSelFamille, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
        labelNom.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(labelNom);
        this.add((Component)labelNom, c);
        ++c.gridx;
        c.weightx = 1.0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNom);
        this.add((Component)this.textNom, c);
        ++c.gridx;
        c.weightx = 0.0;
        JLabel labelCodeBarre = new JLabel(this.getLabelFor("CODE_BARRE"));
        labelCodeBarre.setHorizontalAlignment(4);
        DefaultGridBagConstraints.lockMinimumSize(labelCodeBarre);
        this.add((Component)labelCodeBarre, c);
        ++c.gridx;
        c.weightx = 1.0;
        JTextField fieldCodeBarre = new JTextField();
        DefaultGridBagConstraints.lockMinimumSize(fieldCodeBarre);
        this.add((Component)fieldCodeBarre, c);
        this.addView(fieldCodeBarre, "CODE_BARRE");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        ++c.gridy;
        final ElementComboBox boxUnite = new ElementComboBox();
        if (gestionUV) {
            c.gridx = 0;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("ID_UNITE_VENTE"), 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 0;
            DefaultGridBagConstraints.lockMinimumSize(boxUnite);
            this.add((Component)boxUnite, c);
            this.addView(boxUnite, "ID_UNITE_VENTE");
            c.fill = 2;
        }
        c.gridx = 2;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("SKU"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        JTextField fieldSKU = new JTextField();
        DefaultGridBagConstraints.lockMinimumSize(fieldSKU);
        this.add((Component)fieldSKU, c);
        this.addView(fieldSKU, "SKU");
        c.fill = 2;
        ++c.gridy;
        if (gestionUV) {
            c.gridx = 0;
            c.weightx = 0.0;
            this.add((Component)new JLabel(this.getLabelFor("QTE_UNITAIRE"), 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 0;
            final JTextField qte = new JTextField(10);
            qte.setEditable(false);
            this.add((Component)qte, c);
            this.addView(qte, "QTE_UNITAIRE", (Object)"required");
            boxUnite.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!boxUnite.isEmpty() && boxUnite.getSelectedId() == 2) {
                        qte.setText("1");
                        qte.setEditable(false);
                    } else {
                        qte.setEditable(true);
                    }
                }
            });
            c.fill = 2;
        }
        boolean bl = modeVenteAvance = (bModeVente = Boolean.valueOf(modeVente = (props = DefaultNXProps.getInstance()).getStringProperty("ArticleModeVenteAvance"))) == null || bModeVente != false;
        if (modeVenteAvance) {
            this.addModeVenteAvance(c);
        }
        this.getMontantPanel(c, props);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        JTabbedPane pane = new JTabbedPane();
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        pane.add("Tarifs de vente sp\u00e9ciaux", this.createTarifPanel());
        pane.add("Tarifs de vente par quantit\u00e9", this.createTarifQtePanel());
        pane.add("Tarifs promotionnels", this.createTarifPromotionPanel());
        if (this.tableBom != null) {
            pane.add("Nomenclature", this.createBOMpanel());
        }
        pane.add("Exportation", this.createExportationPanel());
        pane.add("Achat", this.createAchatPanel());
        pane.add("Stock", this.createStockPanel());
        pane.add("Descriptif", this.createDescriptifPanel());
        pane.add("D\u00e9signations multilingues", this.createDesignationPanel());
        pane.add("D\u00e9signations clients", this.createCodeClientPanel());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false)) {
            pane.add("D\u00e9clinaison", this.createDeclinaisonPanel());
        }
        pane.add("Comptabilit\u00e9", this.createComptaPanel());
        pane.add(this.getLabelFor("INFOS"), this.createInfosPanel());
        c.fill = 1;
        this.add((Component)pane, c);
        this.addSQLObject(this.textMetrique1HA, "PRIX_METRIQUE_HA_1");
        this.addSQLObject(this.textMetrique1VT, "PRIX_METRIQUE_VT_1");
        this.addSQLObject(this.textValMetrique1, "VALEUR_METRIQUE_1");
        this.addSQLObject(this.textValMetrique2, "VALEUR_METRIQUE_2");
        this.addSQLObject(this.textValMetrique3, "VALEUR_METRIQUE_3");
        this.addSQLObject(this.comboSelModeVente, "ID_MODE_VENTE_ARTICLE");
        this.addSQLObject(this.boxService, "SERVICE");
        this.addRequiredSQLObject(this.textNom, "NOM");
        this.addRequiredSQLObject(this.textCode, "CODE");
        this.addSQLObject(this.textPoids, "POIDS");
        this.comboSelTaxe.setButtonsVisible(false);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(ReferenceArticleSQLComponent.this.comboSelModeVente.getSelectedId());
                ReferenceArticleSQLComponent.this.selectModeVente(ReferenceArticleSQLComponent.this.comboSelModeVente.getSelectedId());
            }
        };
        this.setListenerModeVenteActive(true);
        this.comboSelModeVente.setValue(5);
    }

    protected Component createInfosPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel labelifco = new JLabel(this.getLabelFor("IFCO"));
        panel.add((Component)labelifco, c);
        c.weightx = 1.0;
        ++c.gridx;
        JTextField textIfco = new JTextField(40);
        panel.add((Component)textIfco, c);
        this.addView(textIfco, "IFCO");
        ++c.gridx;
        c.weightx = 0.0;
        JLabel labelTare = new JLabel(this.getLabelFor("TARE"));
        panel.add((Component)labelTare, c);
        c.weightx = 1.0;
        ++c.gridx;
        JTextField textTare = new JTextField(40);
        panel.add((Component)textTare, c);
        this.addView(textTare, "TARE");
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        JLabel labelOption = new JLabel(this.getLabelFor("OPTION"));
        c.fill = 1;
        panel.add((Component)labelOption, c);
        c.weightx = 1.0;
        ++c.gridx;
        JCheckBox boxOption = new JCheckBox();
        panel.add((Component)boxOption, c);
        this.addSQLObject(boxOption, "OPTION");
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        if (this.getTable().contains("POIDS_COLIS_NET")) {
            JLabel labelPdsColis = new JLabel(this.getLabelFor("POIDS_COLIS_NET"));
            panel.add((Component)labelPdsColis, c);
            c.weightx = 1.0;
            ++c.gridx;
            JTextField textPdsColis = new JTextField(40);
            panel.add((Component)textPdsColis, c);
            this.addView(textPdsColis, "POIDS_COLIS_NET");
            ++c.gridx;
        }
        JLabel labelMasque = new JLabel(this.getLabelFor("MASQUE_CAISSE"));
        c.fill = 1;
        panel.add((Component)labelMasque, c);
        c.weightx = 1.0;
        ++c.gridx;
        JCheckBox boxMasqueCaisse = new JCheckBox();
        panel.add((Component)boxMasqueCaisse, c);
        this.addSQLObject(boxMasqueCaisse, "MASQUE_CAISSE");
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        JLabel labelEco = new JLabel(this.getLabelFor("ID_ECO_CONTRIBUTION"));
        c.fill = 1;
        panel.add((Component)labelEco, c);
        c.weightx = 1.0;
        ++c.gridx;
        ElementComboBox box = new ElementComboBox();
        panel.add((Component)box, c);
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        JLabel labelTaxeCompl = new JLabel(this.getLabelFor("ID_TAXE_COMPLEMENTAIRE"));
        c.fill = 1;
        panel.add((Component)labelTaxeCompl, c);
        c.weightx = 1.0;
        ++c.gridx;
        ElementComboBox boxTaxeCompl = new ElementComboBox();
        panel.add((Component)boxTaxeCompl, c);
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        JLabel labelTaxeInterfel = new JLabel(this.getLabelFor("ID_TAXE_INTERFEL"));
        c.fill = 2;
        panel.add((Component)labelTaxeInterfel, c);
        c.weightx = 1.0;
        ++c.gridx;
        ElementComboBox boxTaxeInterfel = new ElementComboBox();
        panel.add((Component)boxTaxeInterfel, c);
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        JLabel labelMatiere = new JLabel(this.getLabelFor("MATIERE"));
        c.fill = 1;
        panel.add((Component)labelMatiere, c);
        c.weightx = 1.0;
        ++c.gridx;
        SQLTextCombo comboMatiere = new SQLTextCombo();
        panel.add((Component)comboMatiere, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        TitledSeparator sep = new TitledSeparator(this.getLabelFor("INFOS"));
        panel.add((Component)sep, c);
        ++c.gridy;
        c.weighty = 1.0;
        ITextArea infos = new ITextArea();
        c.fill = 1;
        panel.add((Component)infos, c);
        this.addSQLObject(infos, "INFOS");
        this.addSQLObject(comboMatiere, "MATIERE");
        this.addSQLObject(box, "ID_ECO_CONTRIBUTION");
        this.addSQLObject(boxTaxeCompl, "ID_TAXE_COMPLEMENTAIRE");
        this.addSQLObject(boxTaxeInterfel, "ID_TAXE_INTERFEL");
        return panel;
    }

    protected Component createDescriptifPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.checkObs.setOpaque(false);
        panel.add((Component)this.checkObs, c);
        this.checkObs.setVisible(false);
        this.addView(this.checkObs, "OBSOLETE");
        if (this.getTable().getFieldsName().contains("COLORIS")) {
            JTextField fieldColoris = new JTextField();
            ++c.gridy;
            c.fill = 2;
            c.weightx = 0.0;
            c.gridwidth = 1;
            panel.add((Component)new JLabel(this.getLabelFor("COLORIS")), c);
            c.weightx = 1.0;
            ++c.gridx;
            panel.add((Component)fieldColoris, c);
            this.addView(fieldColoris, "COLORIS");
        }
        JTextField fieldLongueur = new JTextField();
        ++c.gridy;
        c.fill = 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel(this.getLabelFor("LONGUEUR")), c);
        c.weightx = 1.0;
        ++c.gridx;
        panel.add((Component)fieldLongueur, c);
        this.addView(fieldLongueur, "LONGUEUR");
        JTextField fieldLargeur = new JTextField();
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel(this.getLabelFor("LARGEUR")), c);
        c.weightx = 1.0;
        ++c.gridx;
        panel.add((Component)fieldLargeur, c);
        this.addView(fieldLargeur, "LARGEUR");
        JTextField fieldHauteur = new JTextField();
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel(this.getLabelFor("HAUTEUR")), c);
        c.weightx = 1.0;
        ++c.gridx;
        panel.add((Component)fieldHauteur, c);
        this.addView(fieldHauteur, "HAUTEUR");
        ITextArea area = new ITextArea();
        JLabel sep = new JLabel("Descriptif complet");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 2;
        panel.add((Component)sep, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)area, c);
        this.addView(area, "DESCRIPTIF");
        return panel;
    }

    protected Component createDesignationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)new JLabel("Ajouter une d\u00e9signation "), c);
        final ElementComboBox boxDes = new ElementComboBox();
        boxDes.init(Configuration.getInstance().getDirectory().getElement("LANGUE"));
        ++c.gridx;
        panel.add((Component)boxDes, c);
        c.fill = 0;
        ++c.gridx;
        JButton buttonAjouterDes = new JButton("Ajouter");
        buttonAjouterDes.setOpaque(false);
        panel.add((Component)buttonAjouterDes, c);
        ++c.gridx;
        JButton buttonSupprimerDes = new JButton("Supprimer");
        buttonSupprimerDes.setOpaque(false);
        panel.add((Component)buttonSupprimerDes, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.tableDes.setOpaque(false);
        panel.add((Component)this.tableDes, c);
        buttonAjouterDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int id = boxDes.getSelectedId();
                if (id <= 1) {
                    return;
                }
                int nbRows = ReferenceArticleSQLComponent.this.tableDes.getModel().getRowCount();
                int i = 0;
                while (i < nbRows) {
                    SQLRowValues rowVals = ReferenceArticleSQLComponent.this.tableDes.getModel().getRowValuesAt(i);
                    int idLangue = Integer.parseInt(rowVals.getObject("ID_LANGUE").toString());
                    if (idLangue == id) {
                        JOptionPane.showMessageDialog(null, "Impossible d'ajouter.\nLa langue est d\u00e9j\u00e0 pr\u00e9sente dans la liste!");
                        return;
                    }
                    ++i;
                }
                SQLRowValues rowVals = new SQLRowValues(Configuration.getInstance().getBase().getTable("ARTICLE_DESIGNATION"));
                if (ReferenceArticleSQLComponent.this.getSelectedID() > 1) {
                    rowVals.put("ID_ARTICLE", ReferenceArticleSQLComponent.this.getSelectedID());
                }
                rowVals.put("ID_LANGUE", id);
                rowVals.put("NOM", "");
                ReferenceArticleSQLComponent.this.tableDes.getModel().addRow(rowVals);
            }
        });
        buttonSupprimerDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceArticleSQLComponent.this.tableDes.removeSelectedRow();
            }
        });
        return panel;
    }

    protected Component createCodeClientPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.tableCodeClient.setOpaque(false);
        panel.add((Component)this.tableCodeClient, c);
        return panel;
    }

    protected Component createDeclinaisonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weighty = 0.0;
        c.weightx = 0.0;
        panel.add((Component)new JLabel(this.getLabelFor("ID_ARTICLE_VIRTUEL_PERE")), c);
        ++c.gridx;
        c.weightx = 1.0;
        final ElementComboBox boxPere = new ElementComboBox();
        panel.add((Component)boxPere, c);
        ComboSQLRequest reqVir = this.getElement().createComboRequest();
        reqVir.setWhere(new Where((FieldRef)this.getElement().getTable().getField("VIRTUEL"), "=", (Object)Boolean.TRUE));
        boxPere.init(this.getElement(), reqVir);
        this.addView(boxPere, "ID_ARTICLE_VIRTUEL_PERE");
        c.gridx = 0;
        ++c.gridy;
        ArrayList<String> declFiels = new ArrayList<String>();
        for (String string : this.getTable().getFieldsName()) {
            if (!string.startsWith("ID_ARTICLE_DECLINAISON_")) continue;
            declFiels.add(string);
        }
        this.boxesDeclinaison.clear();
        for (String field : declFiels) {
            c.weightx = 0.0;
            if (c.gridx == 4) {
                c.gridx = 0;
                ++c.gridy;
            }
            panel.add((Component)new JLabel(this.getLabelFor(field)), c);
            ++c.gridx;
            c.weightx = 1.0;
            ElementComboBox box1 = new ElementComboBox();
            SQLElement declElement = this.getElement().getForeignElement(field);
            box1.init(declElement, declElement.createComboRequest());
            box1.setEnabled(InteractionMode.DISABLED);
            panel.add((Component)box1, c);
            this.addView(box1, field);
            this.boxesDeclinaison.add(box1);
            ++c.gridx;
        }
        boxPere.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                for (ElementComboBox elementComboBox : ReferenceArticleSQLComponent.this.boxesDeclinaison) {
                    elementComboBox.setEnabled(boxPere.getWantedID() != -1 ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                }
            }
        });
        return panel;
    }

    protected Component createStockPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        boolean gestionStockMin = prefs.getBoolean(GestionArticleGlobalPreferencePanel.WARNING_STOCK_MIN, true);
        c.gridx = 0;
        ++c.gridy;
        final JCheckBox boxStock = new JCheckBox(this.getLabelFor("GESTION_STOCK"));
        boxStock.setOpaque(false);
        panel.add((Component)boxStock, c);
        this.addView(boxStock, "GESTION_STOCK");
        final JTextField fieldQteMin = new JTextField();
        final JTextField fieldQteAchat = new JTextField();
        boxStock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fieldQteMin.setEnabled(boxStock.isSelected());
                fieldQteAchat.setEnabled(boxStock.isSelected());
            }
        });
        boolean visibleDepot = prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_MULTI_DEPOT, false);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        JLabel labelDepot = new JLabel(this.getLabelFor("ID_DEPOT_STOCK"));
        panel.add((Component)labelDepot, c);
        labelDepot.setVisible(visibleDepot);
        ++c.gridx;
        c.weightx = 1.0;
        ElementComboBox boxDepot = new ElementComboBox();
        panel.add((Component)boxDepot, c);
        boxDepot.setVisible(visibleDepot);
        this.addView(boxDepot, "ID_DEPOT_STOCK", (Object)"required");
        c.gridwidth = 1;
        if (gestionStockMin) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            panel.add((Component)new JLabel(this.getLabelFor("QTE_ACHAT")), c);
            ++c.gridx;
            c.weightx = 1.0;
            panel.add((Component)fieldQteAchat, c);
            this.addView(fieldQteAchat, "QTE_ACHAT");
        }
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 1.0;
        JCheckBox DLCrequis = new JCheckBox("DLC requis");
        DLCrequis.setOpaque(false);
        panel.add((Component)DLCrequis, c);
        this.addView(DLCrequis, "DLC_REQUIS");
        ++c.gridy;
        JCheckBox DLUOrequis = new JCheckBox("DLUO requis");
        DLUOrequis.setOpaque(false);
        panel.add((Component)DLUOrequis, c);
        this.addView(DLUOrequis, "DLUO_REQUIS");
        ++c.gridy;
        JCheckBox numeroLotRequis = new JCheckBox("n\u00b0 de lot requis");
        numeroLotRequis.setOpaque(false);
        panel.add((Component)numeroLotRequis, c);
        this.addView(numeroLotRequis, "NUMERO_LOT_REQUIS");
        ++c.gridy;
        JCheckBox numeroSerieRequis = new JCheckBox("n\u00b0 de s\u00e9rie requis");
        numeroSerieRequis.setOpaque(false);
        panel.add((Component)numeroSerieRequis, c);
        this.addView(numeroSerieRequis, "NUMERO_SERIE_REQUIS");
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        panel.add((Component)spacer, c);
        return panel;
    }

    protected Component createComptaPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        ISQLCompteSelector sel = new ISQLCompteSelector();
        c.fill = 1;
        panel.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE")), c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)sel, c);
        this.addView((JComponent)sel, "ID_COMPTE_PCE");
        c.gridwidth = 1;
        ++c.gridy;
        c.weighty = 0.0;
        c.gridx = 0;
        c.weightx = 0.0;
        ISQLCompteSelector selAchat = new ISQLCompteSelector();
        c.fill = 1;
        panel.add((Component)new JLabel(this.getLabelFor("ID_COMPTE_PCE_ACHAT")), c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)selAchat, c);
        this.addView((JComponent)selAchat, "ID_COMPTE_PCE_ACHAT");
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        panel.add((Component)this.createCategorieComptablePanel(), c);
        return panel;
    }

    protected Component createAchatPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel labelFournisseur = new JLabel(this.getLabelFor("ID_FOURNISSEUR"));
        labelFournisseur.setHorizontalAlignment(4);
        panel.add((Component)labelFournisseur, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        final ElementComboBox comboSelFournisseur = new ElementComboBox(false, 25);
        panel.add((Component)comboSelFournisseur, c);
        this.addView(comboSelFournisseur, "ID_FOURNISSEUR");
        SQLPreferences prefs = new SQLPreferences(ComptaPropsConfiguration.getInstanceCompta().getRootSociete());
        boolean supplierCode = prefs.getBoolean(GestionArticleGlobalPreferencePanel.SUPPLIER_PRODUCT_CODE, false);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        TitledSeparator sep = new TitledSeparator("Tarifs fournisseurs");
        panel.add((Component)sep, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)new JLabel("Ajouter le fournisseur "), c);
        final ElementComboBox boxF = new ElementComboBox();
        boxF.init(Configuration.getInstance().getDirectory().getElement("FOURNISSEUR"));
        ++c.gridx;
        panel.add((Component)boxF, c);
        c.fill = 0;
        ++c.gridx;
        JButton buttonAjouter = new JButton("Ajouter");
        buttonAjouter.setOpaque(false);
        panel.add((Component)buttonAjouter, c);
        ++c.gridx;
        JButton buttonSupprimer = new JButton("Supprimer");
        buttonSupprimer.setOpaque(false);
        panel.add((Component)buttonSupprimer, c);
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        this.tableFourSec.setOpaque(false);
        panel.add((Component)this.tableFourSec, c);
        buttonAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow rowCat = boxF.getSelectedRow();
                if (rowCat == null || rowCat.isUndefined()) {
                    return;
                }
                int nbRows = ReferenceArticleSQLComponent.this.tableFourSec.getModel().getRowCount();
                SQLRowValues rowVals = new SQLRowValues(Configuration.getInstance().getBase().getTable("ARTICLE_TARIF_FOURNISSEUR"));
                if (ReferenceArticleSQLComponent.this.getSelectedID() > 1) {
                    rowVals.put("ID_ARTICLE", ReferenceArticleSQLComponent.this.getSelectedID());
                }
                rowVals.put("ID_FOURNISSEUR", rowCat.getID());
                ReferenceArticleSQLComponent.this.tableFourSec.getModel().addRow(rowVals);
            }
        });
        buttonSupprimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceArticleSQLComponent.this.tableFourSec.removeSelectedRow();
            }
        });
        if (this.getTable().getSchema().contains("CODE_FOURNISSEUR") && supplierCode) {
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 0;
            TitledSeparator sepC = new TitledSeparator("Codes fournisseurs");
            panel.add((Component)sepC, c);
            this.rowValuesDefaultCodeFournisseur = new SQLRowValues(this.getTable().getTable("CODE_FOURNISSEUR"));
            this.codeFournisseurTable = new CodeFournisseurItemTable(this.rowValuesDefaultCodeFournisseur);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 0;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.fill = 1;
            panel.add((Component)this.codeFournisseurTable, c);
            comboSelFournisseur.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ReferenceArticleSQLComponent.this.rowValuesDefaultCodeFournisseur.put("ID_FOURNISSEUR", comboSelFournisseur.getSelectedId());
                }
            });
        }
        return panel;
    }

    protected JPanel createExportationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelCodeD = new JLabel(this.getLabelFor("CODE_DOUANIER"));
        labelCodeD.setHorizontalAlignment(4);
        panel.add((Component)labelCodeD, c);
        ++c.gridx;
        JTextField fieldCodeDouanier = new JTextField();
        c.weightx = 1.0;
        panel.add((Component)fieldCodeDouanier, c);
        this.addView(fieldCodeDouanier, "CODE_DOUANIER");
        ++c.gridx;
        c.weightx = 0.0;
        JLabel labelPays = new JLabel(this.getLabelFor("ID_PAYS"));
        labelPays.setHorizontalAlignment(4);
        panel.add((Component)labelPays, c);
        ++c.gridx;
        c.weightx = 1.0;
        ElementComboBox comboSelPays = new ElementComboBox(false);
        panel.add((Component)comboSelPays, c);
        this.addView(comboSelPays, "ID_PAYS");
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        panel.add((Component)spacer, c);
        return panel;
    }

    protected JPanel createTarifPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)new JLabel("Ajouter le tarif "), c);
        final ElementComboBox boxTarif = new ElementComboBox();
        boxTarif.init(Configuration.getInstance().getDirectory().getElement("TARIF"));
        ++c.gridx;
        panel.add((Component)boxTarif, c);
        c.fill = 0;
        ++c.gridx;
        JButton buttonAjouter = new JButton("Ajouter");
        buttonAjouter.setOpaque(false);
        panel.add((Component)buttonAjouter, c);
        ++c.gridx;
        JButton buttonSupprimer = new JButton("Supprimer");
        buttonSupprimer.setOpaque(false);
        panel.add((Component)buttonSupprimer, c);
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        this.tableTarifVente.setOpaque(false);
        panel.add((Component)this.tableTarifVente, c);
        buttonAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow rowTarif = boxTarif.getSelectedRow();
                if (rowTarif == null || rowTarif.isUndefined()) {
                    return;
                }
                SQLRowValues rowVals = new SQLRowValues(Configuration.getInstance().getBase().getTable("ARTICLE_TARIF"));
                if (ReferenceArticleSQLComponent.this.getSelectedID() > 1) {
                    rowVals.put("ID_ARTICLE", ReferenceArticleSQLComponent.this.getSelectedID());
                }
                rowVals.put("ID_TARIF", rowTarif.getID());
                rowVals.put("ID_DEVISE", rowTarif.getInt("ID_DEVISE"));
                rowVals.put("ID_TAXE", rowTarif.getInt("ID_TAXE"));
                rowVals.put("PRIX_METRIQUE_VT_1", BigDecimal.ZERO);
                rowVals.put("PV_HT", BigDecimal.ZERO);
                rowVals.put("PV_TTC", BigDecimal.ZERO);
                ReferenceArticleSQLComponent.this.tableTarifVente.getModel().addRow(rowVals);
            }
        });
        buttonSupprimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceArticleSQLComponent.this.tableTarifVente.removeSelectedRow();
            }
        });
        return panel;
    }

    protected JPanel createTarifPromotionPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)new JLabel("Ajouter la promotion"), c);
        final ElementComboBox boxTarif = new ElementComboBox();
        boxTarif.init(Configuration.getInstance().getDirectory().getElement("TARIF_PROMOTION"));
        ++c.gridx;
        panel.add((Component)boxTarif, c);
        c.fill = 0;
        ++c.gridx;
        JButton buttonAjouter = new JButton("Ajouter");
        buttonAjouter.setOpaque(false);
        panel.add((Component)buttonAjouter, c);
        ++c.gridx;
        JButton buttonSupprimer = new JButton("Supprimer");
        buttonSupprimer.setOpaque(false);
        panel.add((Component)buttonSupprimer, c);
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        this.tableTarifPromotionVente.setOpaque(false);
        panel.add((Component)this.tableTarifPromotionVente, c);
        buttonAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow rowTarif = boxTarif.getSelectedRow();
                if (rowTarif == null || rowTarif.isUndefined()) {
                    return;
                }
                SQLRowValues rowVals = new SQLRowValues(Configuration.getInstance().getBase().getTable("ARTICLE_TARIF_PROMOTION"));
                if (ReferenceArticleSQLComponent.this.getSelectedID() > 1) {
                    rowVals.put("ID_ARTICLE", ReferenceArticleSQLComponent.this.getSelectedID());
                }
                rowVals.put("ID_TARIF_PROMOTION", rowTarif.getID());
                rowVals.put("PRIX_METRIQUE_VT_1", BigDecimal.ZERO);
                rowVals.put("PV_HT", BigDecimal.ZERO);
                rowVals.put("PV_TTC", BigDecimal.ZERO);
                ReferenceArticleSQLComponent.this.tableTarifPromotionVente.getModel().addRow(rowVals);
            }
        });
        buttonSupprimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceArticleSQLComponent.this.tableTarifPromotionVente.removeSelectedRow();
            }
        });
        return panel;
    }

    protected JPanel createCategorieComptablePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)new JLabel("Ajouter la cat\u00e9gorie "), c);
        final ElementComboBox boxCat = new ElementComboBox();
        boxCat.init(Configuration.getInstance().getDirectory().getElement("CATEGORIE_COMPTABLE"));
        ++c.gridx;
        panel.add((Component)boxCat, c);
        c.fill = 0;
        ++c.gridx;
        JButton buttonAjouter = new JButton("Ajouter");
        buttonAjouter.setOpaque(false);
        panel.add((Component)buttonAjouter, c);
        ++c.gridx;
        JButton buttonSupprimer = new JButton("Supprimer");
        buttonSupprimer.setOpaque(false);
        panel.add((Component)buttonSupprimer, c);
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        this.tableCatComptable.setOpaque(false);
        panel.add((Component)this.tableCatComptable, c);
        buttonAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow rowCat = boxCat.getSelectedRow();
                if (rowCat == null || rowCat.isUndefined()) {
                    return;
                }
                int nbRows = ReferenceArticleSQLComponent.this.tableCatComptable.getModel().getRowCount();
                int i = 0;
                while (i < nbRows) {
                    SQLRowValues rowVals = ReferenceArticleSQLComponent.this.tableCatComptable.getModel().getRowValuesAt(i);
                    int idTarif = Integer.parseInt(rowVals.getObject("ID_CATEGORIE_COMPTABLE").toString());
                    if (idTarif == rowCat.getID()) {
                        JOptionPane.showMessageDialog(null, "Impossible d'ajouter.\nLa cat\u00e9gorie est d\u00e9j\u00e0 pr\u00e9sente dans la liste!");
                        return;
                    }
                    ++i;
                }
                SQLRowValues rowVals = new SQLRowValues(Configuration.getInstance().getBase().getTable("ARTICLE_CATEGORIE_COMPTABLE"));
                if (ReferenceArticleSQLComponent.this.getSelectedID() > 1) {
                    rowVals.put("ID_ARTICLE", ReferenceArticleSQLComponent.this.getSelectedID());
                }
                rowVals.put("ID_CATEGORIE_COMPTABLE", rowCat.getID());
                ReferenceArticleSQLComponent.this.tableCatComptable.getModel().addRow(rowVals);
            }
        });
        buttonSupprimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceArticleSQLComponent.this.tableCatComptable.removeSelectedRow();
            }
        });
        return panel;
    }

    protected JPanel createBOMpanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        final JCheckBox checkAutoPrice = new JCheckBox(this.getLabelFor("AUTO_PRIX_MIN_VENTE_NOMENCLATURE"));
        panel.add((Component)checkAutoPrice, c);
        this.addView(checkAutoPrice, "AUTO_PRIX_MIN_VENTE_NOMENCLATURE");
        ++c.gridx;
        final JCheckBox checkAutoPriceHA = new JCheckBox(this.getLabelFor("AUTO_PRIX_ACHAT_NOMENCLATURE"));
        panel.add((Component)checkAutoPriceHA, c);
        this.addView(checkAutoPriceHA, "AUTO_PRIX_ACHAT_NOMENCLATURE");
        checkAutoPrice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceArticleSQLComponent.this.updatePricesNomenclature(checkAutoPrice, checkAutoPriceHA);
            }
        });
        checkAutoPriceHA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceArticleSQLComponent.this.updatePricesNomenclature(checkAutoPrice, checkAutoPriceHA);
            }
        });
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        this.tableBom.setOpaque(false);
        panel.add((Component)new RowValuesTableEditionPanel(this.tableBom), c);
        this.tableBom.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ReferenceArticleSQLComponent.this.updatePricesNomenclature(checkAutoPrice, checkAutoPriceHA);
            }
        });
        return panel;
    }

    protected void updatePricesNomenclature(JCheckBox checkAutoPrice, JCheckBox checkAutoPriceHA) {
        Boolean vtAuto = checkAutoPrice.isSelected();
        Boolean haAuto = checkAutoPriceHA.isSelected();
        if (vtAuto.booleanValue() || haAuto.booleanValue()) {
            ProductHelper helper = new ProductHelper(this.getTable().getDBRoot());
            Tuple2<BigDecimal, BigDecimal> p = helper.getStandardBomPrices(this.tableBom.getRowValuesTable().getRowValuesTableModel().getCopyOfValues());
            if (haAuto.booleanValue() && p.get0() != null) {
                this.textPAHT.setText(p.get0().toString());
            }
            if (vtAuto.booleanValue() && p.get1() != null) {
                this.textPVHT.setText(p.get1().toString());
            }
        }
    }

    protected JPanel createTarifQtePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.fill = 1;
        this.tableTarifQteVente.setOpaque(false);
        panel.add((Component)new RowValuesTableEditionPanel(this.tableTarifQteVente), c);
        return panel;
    }

    protected void getMontantPanel(GridBagConstraints c, DefaultProps props) {
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        JPanel pDevise = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cDevise = new DefaultGridBagConstraints();
        cDevise.insets = new Insets(0, 0, 0, 4);
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Devise du fournisseur"), c);
        final ElementComboBox boxDevise = new ElementComboBox(true, 15);
        ++cDevise.gridx;
        cDevise.weightx = 1.0;
        pDevise.add((Component)boxDevise, cDevise);
        this.addView(boxDevise, "ID_DEVISE_HA");
        DefaultGridBagConstraints.lockMinimumSize(boxDevise);
        cDevise.weightx = 0.0;
        ++cDevise.gridx;
        pDevise.add((Component)new JLabel("Prix d'achat devise"), cDevise);
        final JTextField fieldHAD = new JTextField(15);
        cDevise.weightx = 1.0;
        ++cDevise.gridx;
        pDevise.add((Component)fieldHAD, cDevise);
        this.addView(fieldHAD, "PA_DEVISE");
        DefaultGridBagConstraints.lockMinimumSize(fieldHAD);
        ++c.gridx;
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)pDevise, c);
        fieldHAD.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                if (!ReferenceArticleSQLComponent.this.isFilling() && boxDevise != null && boxDevise.getSelectedRow() != null && !boxDevise.getSelectedRow().isUndefined()) {
                    BigDecimal ha = StringUtils.getBigDecimalFromUserText(fieldHAD.getText());
                    if (ha == null) {
                        ha = BigDecimal.ZERO;
                    }
                    CurrencyConverter c = new CurrencyConverter();
                    String devCode = boxDevise.getSelectedRow().getString("CODE");
                    ReferenceArticleSQLComponent.this.textPAHT.setText(c.convert(ha, devCode, c.getCompanyCurrencyCode(), new Date(), true).setScale((int)ReferenceArticleSQLComponent.this.getTable().getField("PA_DEVISE").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
                }
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cAchat = new DefaultGridBagConstraints();
        cAchat.insets = new Insets(0, 0, 0, 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("PA_HT"), 4), c);
        ++cAchat.gridx;
        cAchat.weightx = 1.0;
        p.add((Component)this.textPAHT, cAchat);
        this.textPAHT.getDocument().addDocumentListener(this.listenerMargeTextHA);
        ++cAchat.gridx;
        cAchat.weightx = 0.0;
        p.add((Component)new JLabel("Marge"), cAchat);
        cAchat.weightx = 1.0;
        ++cAchat.gridx;
        p.add((Component)this.textMarge, cAchat);
        this.textMarge.getDocument().addDocumentListener(this.listenerMargeTextMarge);
        ++cAchat.gridx;
        cAchat.weightx = 0.0;
        p.add((Component)this.labelMarge, cAchat);
        JLabel labelPds = new JLabel(this.getLabelFor("POIDS"));
        ++cAchat.gridx;
        cAchat.weightx = 0.0;
        p.add((Component)labelPds, cAchat);
        labelPds.setHorizontalAlignment(4);
        cAchat.weightx = 1.0;
        ++cAchat.gridx;
        p.add((Component)this.textPoids, cAchat);
        DefaultGridBagConstraints.lockMinimumSize(this.textPoids);
        String sService = props.getStringProperty("ArticleService");
        Boolean bService = Boolean.valueOf(sService);
        if (bService != null && bService.booleanValue()) {
            ++cAchat.gridx;
            cAchat.weightx = 0.0;
            p.add((Component)this.boxService, cAchat);
        }
        ++c.gridx;
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)p, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        if (this.getTable().contains("ID_COUT_REVIENT")) {
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_COUT_REVIENT"), 4), c);
            JPanel pCR = new JPanel(new GridBagLayout());
            DefaultGridBagConstraints cCR = new DefaultGridBagConstraints();
            cCR.insets = new Insets(0, 0, 0, 4);
            this.boxCR = new ElementComboBox(true, 15);
            pCR.add((Component)this.boxCR, cCR);
            this.addView(this.boxCR, "ID_COUT_REVIENT");
            DefaultGridBagConstraints.lockMinimumSize(this.boxCR);
            this.boxCR.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!ReferenceArticleSQLComponent.this.isFilling()) {
                        ReferenceArticleSQLComponent.this.textPVHT.getDocument().removeDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
                        ReferenceArticleSQLComponent.this.updateVtFromMarge();
                        ReferenceArticleSQLComponent.this.textPVHT.getDocument().addDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
                    }
                }
            });
            ++cCR.gridx;
            this.boxMargeWithCR = new JCheckBox(this.getLabelFor("MARGE_WITH_COUT_REVIENT"));
            pCR.add((Component)this.boxMargeWithCR, cCR);
            this.addView(this.boxMargeWithCR, "MARGE_WITH_COUT_REVIENT");
            this.boxMargeWithCR.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!ReferenceArticleSQLComponent.this.isFilling()) {
                        ReferenceArticleSQLComponent.this.textPVHT.getDocument().removeDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
                        ReferenceArticleSQLComponent.this.updateVtFromMarge();
                        ReferenceArticleSQLComponent.this.textPVHT.getDocument().addDocumentListener(ReferenceArticleSQLComponent.this.listenerMargeTextVT);
                    }
                }
            });
            ++c.gridx;
            c.gridwidth = 0;
            c.anchor = 17;
            c.weightx = 1.0;
            c.fill = 0;
            this.add((Component)pCR, c);
        }
        c.gridx = 0;
        ++c.gridy;
        JPanel p2 = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cVT = new DefaultGridBagConstraints();
        cVT.insets = new Insets(0, 0, 0, 4);
        c.weightx = 0.0;
        c.fill = 2;
        c.gridwidth = 1;
        this.add((Component)new JLabel(this.getLabelFor("PV_HT"), 4), c);
        ++cVT.gridx;
        cVT.weightx = 1.0;
        p2.add((Component)this.textPVHT, cVT);
        JLabel labelTaxe = new JLabel(this.getLabelFor("ID_TAXE"));
        ++cVT.gridx;
        cVT.weightx = 0.0;
        p2.add((Component)labelTaxe, cVT);
        labelTaxe.setHorizontalAlignment(4);
        ++cVT.gridx;
        p2.add((Component)this.comboSelTaxe, cVT);
        ++cVT.gridx;
        cVT.weightx = 0.0;
        p2.add((Component)new JLabel(this.getLabelFor("PV_TTC")), cVT);
        ++cVT.gridx;
        cVT.weightx = 1.0;
        p2.add((Component)this.textPVTTC, cVT);
        c.gridx = 1;
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)p2, c);
        this.addRequiredSQLObject(this.textPAHT, "PA_HT");
        this.addRequiredSQLObject(this.textPVHT, "PV_HT");
        DefaultGridBagConstraints.lockMinimumSize(this.textPVHT);
        this.addRequiredSQLObject(this.comboSelTaxe, "ID_TAXE");
        DefaultGridBagConstraints.lockMinimumSize(this.comboSelTaxe);
        DefaultGridBagConstraints.lockMaximumSize(this.comboSelTaxe);
        this.addRequiredSQLObject(this.textPVTTC, "PV_TTC");
        DefaultGridBagConstraints.lockMinimumSize(this.textPVTTC);
        DefaultGridBagConstraints.lockMinimumSize(this.textPAHT);
        DefaultGridBagConstraints.lockMinimumSize(this.textMarge);
        this.ttcDocListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextHT();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextHT();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextHT();
            }
        };
        this.htDocListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextTTC();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextTTC();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.setTextTTC();
            }
        };
        this.detailsListener = new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                ReferenceArticleSQLComponent.this.updatePiece();
            }
        };
        this.taxeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!ReferenceArticleSQLComponent.this.isFilling()) {
                    if (ReferenceArticleSQLComponent.this.textPVHT.getText().trim().length() > 0) {
                        ReferenceArticleSQLComponent.this.setTextTTC();
                    } else {
                        ReferenceArticleSQLComponent.this.setTextHT();
                    }
                }
                ReferenceArticleSQLComponent.this.tableTarifVente.fireModification();
            }
        };
        this.textPVHT.getDocument().addDocumentListener(this.htDocListener);
        this.textPVTTC.getDocument().addDocumentListener(this.ttcDocListener);
        this.comboSelTaxe.addValueListener(this.taxeListener);
        this.textMetrique1HA.getDocument().addDocumentListener(this.detailsListener);
        this.textMetrique1VT.getDocument().addDocumentListener(this.detailsListener);
        this.textValMetrique1.getDocument().addDocumentListener(this.detailsListener);
        this.textValMetrique2.getDocument().addDocumentListener(this.detailsListener);
        this.textValMetrique3.getDocument().addDocumentListener(this.detailsListener);
    }

    protected void setListenerModeVenteActive(boolean b) {
        if (b) {
            this.comboSelModeVente.addValueListener(this.propertyChangeListener);
        } else {
            this.comboSelModeVente.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void addModeVenteAvance(GridBagConstraints c) {
        DefaultProps props = DefaultNXProps.getInstance();
        JSeparator sep = new JSeparator();
        JLabel labelDetails = new JLabel("Article d\u00e9taill\u00e9", 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelDetails, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)sep, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(this.getLabelFor("ID_MODE_VENTE_ARTICLE"), 4), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.add((Component)this.comboSelModeVente, c);
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        this.add((Component)this.labelMetriqueHA1, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textMetrique1HA, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.labelMetriqueVT1, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textMetrique1VT, c);
        c.weightx = 0.0;
        JLabel labelMetrique1 = new JLabel(this.getLabelFor("VALEUR_METRIQUE_1"), 4);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)labelMetrique1, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textValMetrique1, c);
        ++c.gridx;
        c.weightx = 0.0;
        Boolean bMetrique1 = Boolean.valueOf(props.getStringProperty("ArticleLongueur"));
        labelMetrique1.setVisible(bMetrique1 == null || bMetrique1 != false);
        this.textValMetrique1.setVisible(bMetrique1 == null || bMetrique1 != false);
        JLabel labelMetrique2 = new JLabel(this.getLabelFor("VALEUR_METRIQUE_2"), 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelMetrique2, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textValMetrique2, c);
        ++c.gridx;
        c.weightx = 0.0;
        Boolean bMetrique2 = Boolean.valueOf(props.getStringProperty("ArticleLargeur"));
        labelMetrique2.setVisible(bMetrique2 == null || bMetrique2 != false);
        this.textValMetrique2.setVisible(bMetrique2 == null || bMetrique2 != false);
        JLabel labelMetrique3 = new JLabel(this.getLabelFor("VALEUR_METRIQUE_3"), 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelMetrique3, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textValMetrique3, c);
        ++c.gridx;
        Boolean bMetrique3 = Boolean.valueOf(props.getStringProperty("ArticlePoids"));
        labelMetrique3.setVisible(bMetrique3 == null || bMetrique3 != false);
        this.textValMetrique3.setVisible(bMetrique3 == null || bMetrique3 != false);
        JSeparator sep2 = new JSeparator();
        JLabel labelPiece = new JLabel("Article pi\u00e8ce", 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelPiece, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)sep2, c);
    }

    @Override
    public void update() {
        SQLRow row = this.getTable().getRow(this.getSelectedID());
        final int selectedID = this.getSelectedID();
        super.update();
        this.tableTarifVente.updateField("ID_ARTICLE", selectedID);
        this.tableCatComptable.updateField("ID_ARTICLE", selectedID);
        this.tableFourSec.updateField("ID_ARTICLE", selectedID);
        this.tableTarifQteVente.updateField("ID_ARTICLE", selectedID);
        this.tableTarifPromotionVente.updateField("ID_ARTICLE", selectedID);
        if (this.tableBom != null) {
            this.tableBom.updateField("ID_ARTICLE_PARENT", selectedID);
        }
        this.tableDes.updateField("ID_ARTICLE", selectedID);
        this.tableCodeClient.updateField("ID_ARTICLE", selectedID);
        if (this.codeFournisseurTable != null) {
            this.codeFournisseurTable.updateField("ID_ARTICLE", selectedID);
        }
        ((ReferenceArticleSQLElement)this.getElement()).initStock(selectedID);
        SQLSelect sel = new SQLSelect();
        SQLTable tableStock = this.getTable().getTable("STOCK");
        sel.addSelect(tableStock.getKey());
        Where w = new Where((FieldRef)tableStock.getField("ID_ARTICLE"), "=", selectedID).and(new Where((FieldRef)tableStock.getField("ID_DEPOT_STOCK"), "=", row.getForeignID("ID_DEPOT_STOCK")));
        sel.setWhere(w);
        List<SQLRow> stock = SQLRowListRSH.execute(sel);
        if (stock != null && stock.size() == 1) {
            try {
                row.createEmptyUpdateRow().put("ID_STOCK", stock.get(0).getID()).update();
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour du stock principal", e);
            }
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SQLRow rowArticle = ReferenceArticleSQLComponent.this.getTable().getRow(selectedID);
                Collection itemsRows = rowArticle.getReferentRows(ReferenceArticleSQLComponent.this.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE"));
                for (SQLRow rowArticleItem : itemsRows) {
                    SQLRow rowA = rowArticleItem.getForeign("ID_ARTICLE_PARENT");
                    if (rowA == null || rowA.isUndefined()) continue;
                    Boolean vtAuto = rowA.getBoolean("AUTO_PRIX_MIN_VENTE_NOMENCLATURE");
                    Boolean haAuto = rowA.getBoolean("AUTO_PRIX_ACHAT_NOMENCLATURE");
                    if (!vtAuto.booleanValue() && !haAuto.booleanValue()) continue;
                    ProductHelper helper = new ProductHelper(rowA.getTable().getDBRoot());
                    Tuple2<BigDecimal, BigDecimal> p = helper.getStandardBomPrices(rowA.getReferentRows(rowA.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT")));
                    SQLRowValues rowVals = rowA.createEmptyUpdateRow();
                    boolean up = false;
                    if (vtAuto.booleanValue() && p.get1() != null) {
                        rowVals.put("PRIX_METRIQUE_VT_1", p.get1());
                        rowVals.put("PV_HT", p.get1());
                        float t = TaxeCache.getCache().getFirstTaxe().getFloat("TAUX");
                        if (!rowA.isForeignEmpty("ID_TAXE")) {
                            t = TaxeCache.getCache().getTauxFromId(rowA.getForeignID("ID_TAXE")).floatValue();
                        }
                        rowVals.put("PV_TTC", p.get1().multiply(new BigDecimal(t).movePointLeft(2).add(BigDecimal.ONE)).setScale(2, RoundingMode.HALF_UP));
                        up = true;
                    }
                    if (haAuto.booleanValue() && p.get0() != null) {
                        rowVals.put("PRIX_METRIQUE_HA_1", p.get0());
                        rowVals.put("PA_HT", p.get0());
                        up = true;
                    }
                    if (!up) continue;
                    try {
                        rowVals.commit();
                    }
                    catch (SQLException e) {
                        ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour des tarifs des nomenclatures", e);
                    }
                }
            }
        };
        new Thread(r).run();
        ReferenceArticleSQLElement.updateDateAchat(this.getTable(), this.getTable().getRow(selectedID));
    }

    protected void selectModeVente(int id) {
        this.labelMetriqueHA1.setEnabled(true);
        this.labelMetriqueVT1.setEnabled(true);
        this.textMetrique1HA.setEnabled(true);
        this.textMetrique1VT.setEnabled(true);
        this.textPAHT.getDocument().removeDocumentListener(this.pieceHAArticle);
        this.textPVHT.getDocument().removeDocumentListener(this.pieceVTArticle);
        switch (id) {
            case 3: {
                this.labelMetriqueHA1.setText("Prix d'achat HT au m\u00e8tre carr\u00e9");
                this.labelMetriqueVT1.setText("Prix de vente HT au m\u00e8tre carr\u00e9");
                break;
            }
            case 2: 
            case 6: {
                this.labelMetriqueHA1.setText("Prix d'achat HT au m\u00e8tre");
                this.labelMetriqueVT1.setText("Prix de vente HT au m\u00e8tre");
                break;
            }
            case 4: {
                this.labelMetriqueHA1.setText("Prix d'achat HT au kilo");
                this.labelMetriqueVT1.setText("Prix de vente HT au kilo");
                break;
            }
            default: {
                this.labelMetriqueHA1.setEnabled(false);
                this.labelMetriqueVT1.setEnabled(false);
                this.textMetrique1HA.setEnabled(false);
                this.textMetrique1VT.setEnabled(false);
                this.textMetrique1HA.setText(this.textPAHT.getText().trim());
                this.textMetrique1VT.setText(this.textPVHT.getText().trim());
                this.textPAHT.getDocument().addDocumentListener(this.pieceHAArticle);
                this.textPVHT.getDocument().addDocumentListener(this.pieceVTArticle);
            }
        }
        this.tableTarifVente.fireModification();
    }

    @Override
    public int insert(SQLRow order) {
        int id = super.insert(order);
        this.tableTarifVente.updateField("ID_ARTICLE", id);
        this.tableCatComptable.updateField("ID_ARTICLE", id);
        this.tableFourSec.updateField("ID_ARTICLE", id);
        this.tableTarifQteVente.updateField("ID_ARTICLE", id);
        this.tableTarifPromotionVente.updateField("ID_ARTICLE", id);
        if (this.tableBom != null) {
            this.tableBom.updateField("ID_ARTICLE_PARENT", id);
        }
        this.tableDes.updateField("ID_ARTICLE", id);
        this.tableCodeClient.updateField("ID_ARTICLE", id);
        if (this.codeFournisseurTable != null) {
            this.codeFournisseurTable.updateField("ID_ARTICLE", id);
        }
        ((ReferenceArticleSQLElement)this.getElement()).initStock(id);
        ReferenceArticleSQLElement.updateDateAchat(this.getTable(), this.getTable().getRow(id));
        if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()).equalsIgnoreCase(this.textCode.getText().trim())) {
            SQLTable tableNum = this.getElement().getDirectory().getElement(NumerotationAutoSQLElement.class).getTable();
            SQLRowValues rowVals = new SQLRowValues(tableNum);
            SQLRow rowNumAuto = tableNum.getRow(2);
            if (rowNumAuto.getObject("ARTICLE_START") != null) {
                int val = rowNumAuto.getInt("ARTICLE_START");
                rowVals.put("ARTICLE_START", new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return id;
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        rowVals.put("ID_DEPOT_STOCK", DepotStockSQLElement.DEFAULT_ID);
        rowVals.put("ID_UNITE_VENTE", 2);
        rowVals.put("QTE_UNITAIRE", BigDecimal.ONE);
        rowVals.put("ID_MODE_VENTE_ARTICLE", 5);
        this.selectModeVente(5);
        rowVals.put("VALEUR_METRIQUE_1", Float.valueOf("1.0"));
        rowVals.put("PA_HT", BigDecimal.ZERO);
        rowVals.put("QTE_UNITAIRE", BigDecimal.ONE);
        rowVals.put("POIDS", Float.valueOf(0.0f));
        rowVals.put("GESTION_STOCK", Boolean.TRUE);
        return rowVals;
    }

    protected void setTextHT() {
        if (!this.isFilling()) {
            int id;
            this.textPVHT.getDocument().removeDocumentListener(this.htDocListener);
            BigDecimal ttc = StringUtils.getBigDecimalFromUserText(this.textPVTTC.getText());
            if (ttc != null && (id = this.comboSelTaxe.getSelectedId()) > 1) {
                Float resultTaux = TaxeCache.getCache().getTauxFromId(id);
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue() / 100.0f;
                this.textPVHT.setText(ttc.divide(BigDecimal.valueOf(taux).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION).setScale((int)this.getTable().getField("PV_HT").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
            }
            this.textPVHT.getDocument().addDocumentListener(this.htDocListener);
        }
    }

    protected void setTextTTC() {
        if (!this.isFilling()) {
            int id;
            this.textPVTTC.getDocument().removeDocumentListener(this.ttcDocListener);
            BigDecimal ht = StringUtils.getBigDecimalFromUserText(this.textPVHT.getText());
            if (ht != null && (id = this.comboSelTaxe.getSelectedId()) > 1) {
                Float resultTaux = TaxeCache.getCache().getTauxFromId(id);
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue() / 100.0f;
                this.textPVTTC.setText(ht.multiply(BigDecimal.valueOf(taux).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION).setScale((int)this.getTable().getField("PV_TTC").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
            }
            this.textPVTTC.getDocument().addDocumentListener(this.ttcDocListener);
        }
    }

    protected void updatePiece() {
        if (this.comboSelModeVente.getSelectedId() > 1 && this.comboSelModeVente.getSelectedId() != 5) {
            SQLRowValues rowVals = this.getDetailsRowValues();
            float poidsTot = ReferenceArticleSQLElement.getPoidsFromDetails(rowVals);
            this.textPoids.setText(String.valueOf(poidsTot));
            this.textPAHT.setText(ReferenceArticleSQLElement.getPrixHAFromDetails(rowVals).setScale((int)this.getTable().getField("PA_HT").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
            this.textPVHT.setText(ReferenceArticleSQLElement.getPrixVTFromDetails(rowVals).setScale((int)this.getTable().getField("PV_HT").getType().getDecimalDigits(), RoundingMode.HALF_UP).toString());
            this.tableTarifVente.fireModification();
        }
    }

    public int getSelectedTaxe() {
        return this.comboSelTaxe.getSelectedId();
    }

    public SQLRowValues getDetailsRowValues() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        BigDecimal pAchat = StringUtils.getBigDecimalFromUserText(this.textMetrique1HA.getText());
        if (pAchat == null) {
            pAchat = BigDecimal.ZERO;
        }
        rowVals.put("PRIX_METRIQUE_HA_1", pAchat);
        BigDecimal pVente = StringUtils.getBigDecimalFromUserText(this.textMetrique1VT.getText());
        if (pVente == null) {
            pVente = BigDecimal.ZERO;
        }
        rowVals.put("PRIX_METRIQUE_VT_1", pVente);
        this.put(rowVals, this.textValMetrique1);
        this.put(rowVals, this.textValMetrique2);
        this.put(rowVals, this.textValMetrique3);
        rowVals.put("ID_MODE_VENTE_ARTICLE", this.comboSelModeVente.getSelectedId());
        return rowVals;
    }

    protected void put(SQLRowValues rowVals, JTextField comp) {
        Float f = Float.valueOf(comp.getText() == null || comp.getText().trim().length() == 0 ? 0.0f : Float.valueOf(comp.getText()).floatValue());
        rowVals.put(this.getView(comp).getField().getName(), f);
    }
}

