/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.ui.NumericTextField;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class TransfertStockFromArticlePanel
extends JPanel {
    private BigDecimal stock = BigDecimal.ZERO;
    private final NumericTextField fieldQteTransfert = new NumericTextField(8);
    private final JButton buttonUpdate;
    private final SQLRequestComboBox comboStockDepart;
    private final SQLRequestComboBox comboStockArrive;
    final JLabel qteDepotDepart = new JLabel();
    final JLabel qteDepotArrive = new JLabel();
    final SQLRowAccessor article;
    final SQLElement stockDepotElt;

    public TransfertStockFromArticlePanel(final Configuration instance, final SQLRowAccessor article, SQLRowAccessor depot) {
        super(new GridBagLayout());
        if (article == null) {
            throw new IllegalArgumentException("Article cannot be null");
        }
        this.article = article;
        this.stockDepotElt = instance.getDirectory().getElement("DEPOT_STOCK");
        this.buttonUpdate = new JButton("Transf\u00e9rer les articles");
        this.comboStockDepart = new SQLRequestComboBox();
        JLabel labelStockDepart = new JLabel();
        ComboSQLRequest createComboRequestDepart = this.stockDepotElt.createComboRequest();
        SQLSelect selDepotValid = new SQLSelect();
        SQLTable tableStock = this.stockDepotElt.getTable().getTable("STOCK");
        selDepotValid.addSelect(tableStock.getField("ID_DEPOT_STOCK"));
        selDepotValid.setWhere(new Where((FieldRef)tableStock.getField("ID_ARTICLE"), "=", article.getID()).and(new Where((FieldRef)tableStock.getField("QTE_REEL"), ">", 0)));
        List listDepotValid = tableStock.getDBSystemRoot().getDataSource().executeCol(selDepotValid.asString());
        createComboRequestDepart.setWhere(Where.inValues(this.stockDepotElt.getTable().getKey(), listDepotValid));
        this.comboStockDepart.uiInit(createComboRequestDepart);
        this.comboStockArrive = new SQLRequestComboBox();
        final ComboSQLRequest createComboRequestArrive = this.stockDepotElt.createComboRequest();
        this.comboStockArrive.uiInit(createComboRequestArrive);
        this.fieldQteTransfert.setText("1");
        this.qteDepotDepart.setFont(this.qteDepotDepart.getFont().deriveFont(2));
        this.qteDepotArrive.setFont(this.qteDepotDepart.getFont().deriveFont(2));
        this.stock = BigDecimal.ZERO;
        this.qteDepotDepart.setText(" ");
        this.qteDepotArrive.setText(" ");
        this.fieldQteTransfert.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                TransfertStockFromArticlePanel.this.updateButtons();
            }
        });
        this.comboStockArrive.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransfertStockFromArticlePanel.this.updateButtons();
            }
        });
        this.comboStockDepart.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransfertStockFromArticlePanel.this.updateButtons();
            }
        });
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        if (!article.getString("CODE").trim().isEmpty()) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Code : ", 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)new JLabel(article.getString("CODE")), c);
            ++c.gridy;
        }
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("D\u00e9signation : ", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)new JLabel(article.getString("NOM")), c);
        SQLPreferences prefs = SQLPreferences.getMemCached(article.getTable().getDBRoot());
        boolean hasDeclinaison = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false);
        if (hasDeclinaison) {
            SQLRowAccessor nonEmptyForeignCouleur;
            SQLRowAccessor nonEmptyForeignTaille = article.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_TAILLE");
            if (nonEmptyForeignTaille != null) {
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)new JLabel("Taille : ", 4), c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)new JLabel(nonEmptyForeignTaille.getString("NOM")), c);
            }
            if ((nonEmptyForeignCouleur = article.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_COULEUR")) != null) {
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)new JLabel("Couleur : ", 4), c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)new JLabel(nonEmptyForeignCouleur.getString("NOM")), c);
            }
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        this.add((Component)new JLabel("Intitul\u00e9 du transfert"), c);
        final JTextField label = new JTextField();
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        this.add((Component)label, c);
        label.setText("Transfert de stock");
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        if (depot == null) {
            this.add((Component)new JLabel("Du d\u00e9p\u00f4t", 4), c);
            ++c.gridx;
            this.add((Component)this.comboStockDepart, c);
        } else {
            this.add((Component)new JLabel("Du d\u00e9p\u00f4t : ", 4), c);
            ++c.gridx;
            this.add((Component)labelStockDepart, c);
            labelStockDepart.setText(depot.getString("NOM"));
            this.comboStockDepart.setValue(depot);
        }
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        this.add((Component)this.qteDepotDepart, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Vers le d\u00e9p\u00f4t", 4), c);
        ++c.gridx;
        this.add((Component)this.comboStockArrive, c);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        this.add((Component)this.qteDepotArrive, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Quantit\u00e9", 4), c);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)this.fieldQteTransfert, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        JButton buttonCancel = new JButton("Annuler");
        JPanel pButton = new JPanel();
        pButton.add(buttonCancel);
        pButton.add(this.buttonUpdate);
        c.gridwidth = 2;
        c.anchor = 14;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)pButton, c);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(TransfertStockFromArticlePanel.this)).dispose();
            }
        });
        this.buttonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransfertStockFromArticlePanel.this.buttonUpdate.setEnabled(false);
                BigDecimal qteReel = TransfertStockFromArticlePanel.this.fieldQteTransfert.getValue();
                instance.getDirectory().getElement(ReferenceArticleSQLElement.class).transfert(Arrays.asList(Tuple2.create(article.asRow(), qteReel)), TransfertStockFromArticlePanel.this.comboStockDepart.getSelectedRow(), TransfertStockFromArticlePanel.this.comboStockArrive.getSelectedRow(), label.getText(), new Date());
                ((JFrame)SwingUtilities.getRoot(TransfertStockFromArticlePanel.this)).dispose();
            }
        });
        this.comboStockDepart.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    int fromId = (Integer)evt.getNewValue();
                    List<SQLRowValues> list = createComboRequestArrive.getValues();
                    for (SQLRowValues row : list) {
                        if (row.getID() == fromId) continue;
                        TransfertStockFromArticlePanel.this.comboStockArrive.setValue(row.getID());
                        break;
                    }
                }
            }
        });
        if (depot == null) {
            if (!listDepotValid.isEmpty()) {
                this.comboStockDepart.setValue(((Number)listDepotValid.get(0)).intValue());
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(TransfertStockFromArticlePanel.this, "Aucun stock pour cet article");
                        ((JFrame)SwingUtilities.getRoot(TransfertStockFromArticlePanel.this)).dispose();
                    }
                });
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TransfertStockFromArticlePanel.this.fieldQteTransfert.grabFocus();
                TransfertStockFromArticlePanel.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
        BigDecimal qte = this.fieldQteTransfert.getValue();
        this.buttonUpdate.setEnabled(this.stock.signum() > 0 && qte.signum() > 0 && this.stock.subtract(qte).signum() >= 0 && this.comboStockArrive.getSelectedRow() != null && this.comboStockDepart.getSelectedRow() != null && this.comboStockArrive.getSelectedRow().getID() != this.comboStockDepart.getSelectedRow().getID());
        int idDepart = this.comboStockDepart.getWantedID();
        if (idDepart != -1) {
            SQLRowAccessor stockRow = ProductComponent.findOrCreateStock(this.article, this.stockDepotElt.getTable().getRow(idDepart));
            this.stock = new BigDecimal(stockRow.getFloat("QTE_REEL"));
            this.qteDepotDepart.setText(String.valueOf(String.valueOf(this.stock)) + " en stock -> " + String.valueOf(this.stock.subtract(qte)));
        } else {
            this.stock = BigDecimal.ZERO;
            this.qteDepotDepart.setText("pas de d\u00e9p\u00f4t s\u00e9lectionn\u00e9");
        }
        int idArrive = this.comboStockArrive.getWantedID();
        if (idArrive != -1) {
            SQLRowAccessor stockRow = ProductComponent.findOrCreateStock(this.article, this.stockDepotElt.getTable().getRow(idArrive));
            BigDecimal stockArrive = new BigDecimal(stockRow.getFloat("QTE_REEL"));
            this.qteDepotArrive.setText(String.valueOf(String.valueOf(stockArrive)) + " en stock -> " + String.valueOf(stockArrive.add(qte)));
        } else {
            this.qteDepotArrive.setText("pas de d\u00e9p\u00f4t s\u00e9lectionn\u00e9");
        }
    }
}

