/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.sales.pos.model.TicketItem;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.POSLabel;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;

public class StockErrorPanel
extends JPanel {
    private final CaisseControler controller;

    public StockErrorPanel(final CaisseFrame caisseFrame, final Map<TicketItem, Integer> missingQty, final Runnable runnable) {
        this.controller = caisseFrame.getControler();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 18;
        c.fill = 0;
        int missing = 0;
        for (Integer q : missingQty.values()) {
            missing += q.intValue();
        }
        String label = "un article n'est pas en stock";
        if (missing > 1) {
            label = String.valueOf(missing) + " articles ne sont pas en stock";
        }
        POSLabel labels = new POSLabel(String.valueOf(label) + " : ");
        this.add((Component)labels, c);
        for (Map.Entry<TicketItem, Integer> e : missingQty.entrySet()) {
            ++c.gridy;
            String declinaison = e.getKey().getArticle().getDeclinaison();
            if (declinaison != null && declinaison.trim().isEmpty()) {
                this.add((Component)new POSLabel(String.valueOf(e.getKey().getArticle().getName()) + " " + declinaison + " : " + e.getValue()), c);
                continue;
            }
            this.add((Component)new POSLabel(String.valueOf(e.getKey().getArticle().getName()) + " : " + e.getValue()), c);
        }
        c.fill = 0;
        final SQLElementDirectory dir = caisseFrame.getConf().getDirectory();
        final SQLTable tDepot = dir.getElement(DepotStockSQLElement.class).getTable();
        final SQLTable tArticle = dir.getElement(ReferenceArticleSQLElement.class).getTable();
        SQLSelect select = new SQLSelect();
        select.addSelect(tDepot.getField("ID"));
        select.addSelect(tDepot.getField("NOM"));
        int nbChoice = 0;
        for (final SQLRow rowDepotDepart : SQLRowListRSH.execute(select)) {
            int idDepotDepart = rowDepotDepart.getInt("ID");
            String nomDepotDepart = rowDepotDepart.getString("NOM");
            final int idDepotIDestination = caisseFrame.getPOSConf().getDepotID();
            if (idDepotDepart == idDepotIDestination) continue;
            POSButton b = new POSButton("Cr\u00e9er un mouvement de stock depuis le d\u00e9p\u00f4t " + nomDepotDepart);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    System.err.println("StockErrorPanel.StockErrorPanel(...) mouvement de stock");
                    SQLRow selectedRowDepotArrivee = tDepot.getRow(idDepotIDestination);
                    Date date = new Date();
                    for (Map.Entry e : missingQty.entrySet()) {
                        int idArticle = ((TicketItem)e.getKey()).getArticle().getId();
                        BigDecimal qteReel = new BigDecimal((Integer)e.getValue());
                        SQLRow selectedRowArticle = tArticle.getRow(idArticle);
                        dir.getElement(MouvementStockSQLElement.class).transfertStock(qteReel, date, selectedRowArticle, rowDepotDepart, selectedRowDepotArrivee, "transfert depuis caisse");
                    }
                    caisseFrame.showCaisse();
                    runnable.run();
                }
            });
            ++c.gridy;
            this.add((Component)b, c);
            ++nbChoice;
        }
        if (nbChoice == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    caisseFrame.showCaisse();
                    runnable.run();
                }
            });
        } else {
            POSButton b2 = new POSButton("Annuler la validation du ticket");
            b2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.err.println("StockErrorPanel.StockErrorPanel(...) annulation");
                    caisseFrame.showCaisse();
                }
            });
            ++c.gridy;
            this.add((Component)b2, c);
        }
    }
}

