/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JButton;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;

public class POSButton
extends JButton {
    private Color enabledBackgroundColor = null;
    private Color disabledBackgroundColor = null;

    public POSButton(String label) {
        super(label);
        Font f = this.getFont().deriveFont(20.0f);
        this.setForeground(Color.WHITE);
        this.setBackground(CaissePanel.DARK_BLUE);
        this.setDisabledBackground(Color.LIGHT_GRAY);
        this.setFont(f);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setOpaque(true);
    }

    public void setDisabledBackground(Color bg) {
        this.disabledBackgroundColor = bg == null ? this.getBackground() : bg;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            if (this.enabledBackgroundColor != null && !this.enabledBackgroundColor.equals(this.getBackground())) {
                super.setBackground(this.enabledBackgroundColor);
            }
        } else if (this.disabledBackgroundColor != null && !this.disabledBackgroundColor.equals(this.getBackground())) {
            super.setBackground(this.disabledBackgroundColor);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.isEnabled()) {
            this.enabledBackgroundColor = this.getBackground();
        } else {
            this.disabledBackgroundColor = this.getBackground();
        }
    }
}

