/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.ServerFinderConfig;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.io.ESCSerialPrinter;
import org.openconcerto.erp.core.sales.pos.ui.TicketLineTable;
import org.openconcerto.erp.core.sales.pos.ui.TicketPrinterConfigPanel;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;

public class ConfigCaissePanel
extends JPanel {
    private final POSConfiguration configuration;
    private int userId;
    private int societeId;
    private int caisseId;
    private final ServerFinderPanel serverFinderPanel;
    private final JComboBox comboSociete;
    private final JComboBox comboCaisse;
    private final JComboBox comboUtilisateur;
    private final JComboBox comboDepot;
    private final TicketLineTable headerTable;
    private final TicketLineTable footerTable;
    private JTextField textTerminalCB;
    private final TicketPrinterConfigPanel ticketPanel1;
    private final TicketPrinterConfigPanel ticketPanel2;
    private JComboBox comboLCDType;
    private JTextField textLCDPort;
    private JTextField textLCDLine1;
    private JTextField textLCDLine2;
    protected int depotStockId = 2;

    public ConfigCaissePanel(ServerFinderPanel serverFinderPanel) {
        this.serverFinderPanel = serverFinderPanel;
        try {
            this.configuration = POSConfiguration.setInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't initialise POSConfiguration", e);
        }
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weighty = 0.0;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Fichier de configuration", 4), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        JTextField textConfigurationFile = new JTextField("");
        if (this.configuration.getConfigFile() != null) {
            textConfigurationFile.setText(this.configuration.getConfigFile().getAbsolutePath());
        }
        textConfigurationFile.setEditable(false);
        this.add((Component)textConfigurationFile, c);
        ++c.gridy;
        c.gridx = 0;
        JLabelBold titleConnexion = new JLabelBold("Connexion");
        c.gridwidth = 2;
        this.add((Component)titleConnexion, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Soci\u00e9t\u00e9", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.comboSociete = new JComboBox();
        this.comboSociete.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SQLRow r = (SQLRow)value;
                String label = "";
                if (r != null) {
                    label = String.valueOf(r.getString("NOM")) + " (" + r.getString("ID") + ")";
                }
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        this.add((Component)this.comboSociete, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Caisse", 4), c);
        ++c.gridx;
        this.comboCaisse = new JComboBox();
        this.comboCaisse.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SQLRow r = (SQLRow)value;
                String label = "";
                if (r != null) {
                    label = String.valueOf(r.getString("NOM")) + " (" + r.getString("ID") + ")";
                }
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        this.add((Component)this.comboCaisse, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Utilisateur", 4), c);
        ++c.gridx;
        this.comboUtilisateur = new JComboBox();
        this.comboUtilisateur.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SQLRow r = (SQLRow)value;
                String label = "";
                if (r != null) {
                    label = String.valueOf(r.getString("NOM")) + " " + r.getString("PRENOM") + " (" + r.getString("ID") + ")";
                }
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        this.add((Component)this.comboUtilisateur, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel("D\u00e9p\u00f4t de stock", 4), c);
        ++c.gridx;
        this.comboDepot = new JComboBox();
        this.comboDepot.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SQLRow r = (SQLRow)value;
                String label = "";
                if (r != null) {
                    label = String.valueOf(r.getString("CODE")) + "  " + r.getString("NOM") + " (" + r.getID() + ")".trim();
                }
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        this.add((Component)this.comboDepot, c);
        JLabelBold titleTicket = new JLabelBold("Ticket");
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)titleTicket, c);
        JTabbedPane tabsTicket = new JTabbedPane();
        ++c.gridy;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.fill = 1;
        c.anchor = 18;
        this.headerTable = new TicketLineTable();
        tabsTicket.addTab("Ent\u00eate", this.headerTable);
        this.footerTable = new TicketLineTable();
        tabsTicket.addTab("Pied de page", this.footerTable);
        this.add((Component)tabsTicket, c);
        JLabelBold titleImprimante = new JLabelBold("P\u00e9riph\u00e9riques");
        c.fill = 2;
        c.anchor = 17;
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)titleImprimante, c);
        ++c.gridy;
        JTabbedPane tabs = new JTabbedPane();
        this.ticketPanel1 = new TicketPrinterConfigPanel();
        this.ticketPanel1.setOpaque(false);
        this.ticketPanel2 = new TicketPrinterConfigPanel();
        this.ticketPanel2.setOpaque(false);
        tabs.addTab("Imprimante ticket principale", this.ticketPanel1);
        tabs.addTab("Imprimante ticket secondaire", this.ticketPanel2);
        tabs.addTab("Terminal CB", this.createCreditCardPanel());
        tabs.addTab("Afficheur LCD", this.createLCDPanel());
        this.add((Component)tabs, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        spacer.setPreferredSize(new Dimension(10, 10));
        this.add((Component)spacer, c);
        this.comboSociete.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigCaissePanel.this.societeId = ((SQLRow)e.getItem()).getID();
                    ConfigCaissePanel.this.reloadCaisses();
                }
            }
        });
        this.comboCaisse.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigCaissePanel.this.caisseId = ((SQLRow)e.getItem()).getID();
                }
            }
        });
        this.comboUtilisateur.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigCaissePanel.this.userId = ((SQLRow)e.getItem()).getID();
                }
            }
        });
        this.comboDepot.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigCaissePanel.this.depotStockId = ((SQLRow)e.getItem()).getID();
                }
            }
        });
    }

    private Component createLCDPanel() {
        final JPanel p = new JPanel();
        p.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        p.setLayout(new GridBagLayout());
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        p.add((Component)new JLabel("Type", 4), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 17;
        this.comboLCDType = new JComboBox<String>(new String[]{"Port s\u00e9rie", "Emulation imprimante"});
        p.add((Component)this.comboLCDType, c);
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 13;
        JLabel labelType = new JLabel("Port", 4);
        p.add((Component)labelType, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textLCDPort = new JTextField(20);
        p.add((Component)this.textLCDPort, c);
        c.weightx = 0.0;
        ++c.gridx;
        JButton selectPortButton = new JButton("S\u00e9lectionner");
        selectPortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message;
                String title;
                ArrayList<String> choices = new ArrayList<String>();
                if (ConfigCaissePanel.this.comboLCDType.getSelectedIndex() == 1) {
                    PrintService[] printServices;
                    PrintService[] printServiceArray = printServices = PrintServiceLookup.lookupPrintServices(null, null);
                    int n = printServices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PrintService printer = printServiceArray[n2];
                        choices.add(printer.getName());
                        ++n2;
                    }
                    title = "Afficheur LCD";
                    message = "Choisissez l'imprimante correspondante \u00e0 l'afficheur LCD";
                } else if (ConfigCaissePanel.this.comboLCDType.getSelectedIndex() == 0) {
                    choices.addAll(ESCSerialPrinter.getSerialPortNames());
                    title = "Port s\u00e9rie";
                    message = "Choisissez le port s\u00e9rie li\u00e9 \u00e0 l'afficheur LCD";
                } else {
                    return;
                }
                if (choices.isEmpty()) {
                    return;
                }
                String s = (String)JOptionPane.showInputDialog(p, message, title, -1, null, choices.toArray(), choices.get(0));
                if (s != null && s.length() > 0) {
                    ConfigCaissePanel.this.textLCDPort.setText(s);
                }
            }
        });
        p.add((Component)selectPortButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        p.add((Component)new JLabel("Message d'accueil de l'afficheur"), c);
        ++c.gridy;
        c.gridwidth = 1;
        p.add((Component)new JLabel("Ligne 1", 4), c);
        ++c.gridx;
        this.textLCDLine1 = new JTextField(20);
        p.add((Component)this.textLCDLine1, c);
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)new JLabel("Ligne 2", 4), c);
        ++c.gridx;
        this.textLCDLine2 = new JTextField(20);
        p.add((Component)this.textLCDLine2, c);
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        ++c.gridy;
        c.weighty = 1.0;
        p.add((Component)spacer, c);
        return p;
    }

    private JPanel createCreditCardPanel() {
        final JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        p.add((Component)new JLabel("Port s\u00e9rie", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textTerminalCB = new JTextField(20);
        p.add((Component)this.textTerminalCB, c);
        c.weightx = 0.0;
        ++c.gridx;
        JButton selectPortButton = new JButton("S\u00e9lectionner");
        selectPortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> choices = new ArrayList<String>();
                choices.addAll(ESCSerialPrinter.getSerialPortNames());
                String title = "Port s\u00e9rie";
                String message = "Choisissez le port s\u00e9rie li\u00e9 au terminal CB";
                if (choices.isEmpty()) {
                    return;
                }
                String s = (String)JOptionPane.showInputDialog(p, message, title, -1, null, choices.toArray(), choices.get(0));
                if (s != null && s.length() > 0) {
                    ConfigCaissePanel.this.textTerminalCB.setText(s);
                }
            }
        });
        p.add((Component)selectPortButton, c);
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        ++c.gridy;
        c.weighty = 1.0;
        p.add((Component)spacer, c);
        return p;
    }

    protected void reloadCaisses() {
        block7: {
            this.comboCaisse.setEnabled(false);
            int id = this.societeId;
            ServerFinderConfig config = this.serverFinderPanel.createServerFinderConfig();
            if (!config.isOnline()) {
                JOptionPane.showMessageDialog(this, "Impossible de se connecter au serveur");
                return;
            }
            System.out.println("Reloading POS information from: " + config);
            ComptaPropsConfiguration conf = config.createConf();
            try {
                try {
                    conf.setUpSocieteStructure(id);
                    SQLRow societe = conf.getRowSociete();
                    if (societe != null) {
                        final String name = societe.getString("DATABASE_NAME");
                        SQLSelect sel = new SQLSelect();
                        sel.addSelectStar(conf.getRootSociete().getTable("CAISSE"));
                        final List<SQLRow> caisses = SQLRowListRSH.execute(sel);
                        SQLSelect sel2 = new SQLSelect();
                        sel2.addSelectStar(conf.getRootSociete().getTable("DEPOT_STOCK"));
                        final List<SQLRow> depots = SQLRowListRSH.execute(sel2);
                        final int idCaisseToSelect = this.caisseId;
                        final int idDepotToSelect = this.depotStockId;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SQLRow r;
                                ConfigCaissePanel.this.caisseId = idCaisseToSelect;
                                ConfigCaissePanel.this.depotStockId = idDepotToSelect;
                                if (caisses.isEmpty()) {
                                    JOptionPane.showMessageDialog(ConfigCaissePanel.this, "Pas de caisses d\u00e9finies dans la soci\u00e9t\u00e9 " + name);
                                }
                                ConfigCaissePanel.this.comboCaisse.setModel(new DefaultComboBoxModel(new Vector(caisses)));
                                ConfigCaissePanel.this.comboDepot.setModel(new DefaultComboBoxModel(new Vector(depots)));
                                ConfigCaissePanel.this.comboUtilisateur.setEnabled(true);
                                ConfigCaissePanel.this.comboCaisse.setEnabled(true);
                                ConfigCaissePanel.this.comboDepot.setEnabled(true);
                                ComboBoxModel model = ConfigCaissePanel.this.comboCaisse.getModel();
                                int stop = model.getSize();
                                if (stop > 0) {
                                    ConfigCaissePanel.this.caisseId = ((SQLRow)model.getElementAt(0)).getID();
                                }
                                int i = 0;
                                while (i < stop) {
                                    r = (SQLRow)model.getElementAt(i);
                                    if (r.getID() == idCaisseToSelect) {
                                        ConfigCaissePanel.this.comboCaisse.setSelectedItem(r);
                                        break;
                                    }
                                    ++i;
                                }
                                ComboBoxModel model2 = ConfigCaissePanel.this.comboDepot.getModel();
                                int stop2 = model2.getSize();
                                if (stop2 > 0) {
                                    ConfigCaissePanel.this.depotStockId = ((SQLRow)model2.getElementAt(0)).getID();
                                }
                                i = 0;
                                while (i < stop2) {
                                    r = (SQLRow)model2.getElementAt(i);
                                    if (r.getID() == idDepotToSelect) {
                                        ConfigCaissePanel.this.comboDepot.setSelectedItem(r);
                                        break;
                                    }
                                    ++i;
                                }
                            }
                        });
                        break block7;
                    }
                    JOptionPane.showMessageDialog(this, "Impossible de trouver la soci\u00e9t\u00e9 d'ID " + id);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    conf.destroy();
                }
            }
            finally {
                conf.destroy();
            }
        }
    }

    public void loadConfiguration() {
        POSConfiguration configuration = this.configuration;
        this.textTerminalCB.setText(configuration.getCreditCardPort());
        String lcdType = configuration.getLCDType();
        if (lcdType.equals("serial")) {
            this.comboLCDType.setSelectedIndex(0);
        } else {
            this.comboLCDType.setSelectedIndex(1);
        }
        this.textLCDPort.setText(configuration.getLCDPort());
        this.textLCDLine1.setText(configuration.getLCDLine1());
        this.textLCDLine2.setText(configuration.getLCDLine2());
        this.userId = configuration.getUserID();
        this.societeId = configuration.getCompanyID();
        this.caisseId = configuration.getPosID();
        this.depotStockId = configuration.getDepotID();
        this.headerTable.fillFrom(configuration.getHeaderLines());
        this.footerTable.fillFrom(configuration.getFooterLines());
        this.ticketPanel1.setConfiguration(configuration.getTicketPrinterConfiguration1());
        this.ticketPanel2.setConfiguration(configuration.getTicketPrinterConfiguration2());
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent event) {
            }

            @Override
            public void componentMoved(ComponentEvent event) {
            }

            @Override
            public void componentResized(ComponentEvent event) {
            }

            @Override
            public void componentShown(ComponentEvent event) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ConfigCaissePanel.this.comboSociete.setEnabled(false);
                        ConfigCaissePanel.this.comboUtilisateur.setEnabled(false);
                        ConfigCaissePanel.this.comboCaisse.setEnabled(false);
                        ConfigCaissePanel.this.comboDepot.setEnabled(false);
                        ServerFinderConfig config = ConfigCaissePanel.this.serverFinderPanel.createServerFinderConfig();
                        if (!config.isOnline()) {
                            JOptionPane.showMessageDialog(ConfigCaissePanel.this, "Impossible de se connecter au serveur");
                            return;
                        }
                        ComptaPropsConfiguration server = config.createConf();
                        try {
                            try {
                                DBRoot root = server.getRoot();
                                SQLSelect sel = new SQLSelect();
                                sel.addSelectStar(root.findTable("SOCIETE_COMMON"));
                                final List<SQLRow> societes = SQLRowListRSH.execute(sel);
                                sel = new SQLSelect();
                                sel.addSelectStar(root.findTable("USER_COMMON"));
                                final List<SQLRow> utilisateurs = SQLRowListRSH.execute(sel);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ConfigCaissePanel.this.comboSociete.setModel(new DefaultComboBoxModel(new Vector(societes)));
                                        ConfigCaissePanel.this.comboUtilisateur.setModel(new DefaultComboBoxModel(new Vector(utilisateurs)));
                                        ConfigCaissePanel.this.comboSociete.setEnabled(true);
                                        ConfigCaissePanel.this.comboUtilisateur.setEnabled(true);
                                        ComboBoxModel model = ConfigCaissePanel.this.comboSociete.getModel();
                                        int stop = model.getSize();
                                        boolean societeFound = false;
                                        int i = 0;
                                        while (i < stop) {
                                            SQLRow r = (SQLRow)model.getElementAt(i);
                                            if (r.getID() == ConfigCaissePanel.this.societeId) {
                                                ConfigCaissePanel.this.comboSociete.setSelectedItem(r);
                                                ConfigCaissePanel.this.societeId = r.getID();
                                                societeFound = true;
                                                break;
                                            }
                                            ++i;
                                        }
                                        if (!societeFound && stop > 0) {
                                            ConfigCaissePanel.this.comboSociete.setSelectedItem(model.getElementAt(0));
                                            ConfigCaissePanel.this.societeId = ((SQLRow)model.getElementAt(0)).getID();
                                        }
                                        model = ConfigCaissePanel.this.comboUtilisateur.getModel();
                                        stop = model.getSize();
                                        boolean utilisateurFound = false;
                                        int i2 = 0;
                                        while (i2 < stop) {
                                            SQLRow r = (SQLRow)model.getElementAt(i2);
                                            if (r.getID() == ConfigCaissePanel.this.userId) {
                                                ConfigCaissePanel.this.comboUtilisateur.setSelectedItem(r);
                                                ConfigCaissePanel.this.userId = r.getID();
                                                utilisateurFound = true;
                                                break;
                                            }
                                            ++i2;
                                        }
                                        if (!utilisateurFound && stop > 0) {
                                            ConfigCaissePanel.this.comboUtilisateur.setSelectedItem(model.getElementAt(0));
                                            ConfigCaissePanel.this.userId = ((SQLRow)model.getElementAt(0)).getID();
                                        }
                                        Thread t = new Thread(){

                                            @Override
                                            public void run() {
                                                ConfigCaissePanel.this.reloadCaisses();
                                            }
                                        };
                                        t.start();
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                server.destroy();
                                server.tearDownLogging(true);
                            }
                        }
                        finally {
                            server.destroy();
                            server.tearDownLogging(true);
                        }
                    }
                });
                t.setDaemon(true);
                t.start();
            }
        });
    }

    public void dumpConfiguration() {
        System.out.println("Societe: id:" + this.societeId);
        System.out.println("Caisse: id:" + this.caisseId);
        System.out.println("Utilisateur:  id:" + this.userId);
        System.out.println("Depot:  id:" + this.depotStockId);
    }

    public void saveConfiguration() {
        POSConfiguration configuration = this.configuration;
        this.ticketPanel1.commitValues();
        this.ticketPanel2.commitValues();
        configuration.setUserID(this.userId);
        configuration.setCompanyID(this.societeId);
        configuration.setPosID(this.caisseId);
        configuration.setDepotID(this.depotStockId);
        configuration.setHeaderLines(this.headerTable.getLines());
        configuration.setFooterLines(this.footerTable.getLines());
        configuration.setCreditCardPort(this.textTerminalCB.getText());
        int selectedIndex = this.comboLCDType.getSelectedIndex();
        if (selectedIndex == 0) {
            configuration.setLCDType("serial");
        } else {
            configuration.setLCDType("printer");
        }
        configuration.setLCDPort(this.textLCDPort.getText());
        configuration.setLCDLine1(this.textLCDLine1.getText());
        configuration.setLCDLine2(this.textLCDLine2.getText());
        configuration.saveConfiguration();
    }
}

